/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.backup.BackupRestoreConstants;
import org.apache.hadoop.hbase.backup.impl.BackupCommands;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BackupDriver
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(BackupDriver.class);
    private CommandLine cmd;

    public BackupDriver() throws IOException {
        this.init();
    }

    protected void init() throws IOException {
        Log4jUtils.disableZkAndClientLoggers();
    }

    private int parseAndRun(String[] args) throws IOException {
        if (!BackupManager.isBackupEnabled(this.getConf())) {
            System.err.println(BackupRestoreConstants.ENABLE_BACKUP);
            return -1;
        }
        String cmd = null;
        String[] remainArgs = null;
        if (args == null || args.length == 0) {
            this.printToolUsage();
            return -1;
        }
        cmd = args[0];
        remainArgs = new String[args.length - 1];
        if (args.length > 1) {
            System.arraycopy(args, 1, remainArgs, 0, args.length - 1);
        }
        BackupRestoreConstants.BackupCommand type = BackupRestoreConstants.BackupCommand.HELP;
        if (BackupRestoreConstants.BackupCommand.CREATE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.CREATE;
        } else if (BackupRestoreConstants.BackupCommand.HELP.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.HELP;
        } else if (BackupRestoreConstants.BackupCommand.DELETE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.DELETE;
        } else if (BackupRestoreConstants.BackupCommand.DESCRIBE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.DESCRIBE;
        } else if (BackupRestoreConstants.BackupCommand.HISTORY.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.HISTORY;
        } else if (BackupRestoreConstants.BackupCommand.PROGRESS.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.PROGRESS;
        } else if (BackupRestoreConstants.BackupCommand.SET.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.SET;
        } else if (BackupRestoreConstants.BackupCommand.REPAIR.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.REPAIR;
        } else if (BackupRestoreConstants.BackupCommand.MERGE.name().equalsIgnoreCase(cmd)) {
            type = BackupRestoreConstants.BackupCommand.MERGE;
        } else {
            System.out.println("Unsupported command for backup: " + cmd);
            this.printToolUsage();
            return -1;
        }
        if (this.cmd.hasOption("d")) {
            Log4jUtils.setLogLevel((String)"org.apache.hadoop.hbase.backup", (String)"DEBUG");
        }
        BackupCommands.Command command = BackupCommands.createCommand(this.getConf(), type, this.cmd);
        if (type == BackupRestoreConstants.BackupCommand.CREATE && this.conf != null) {
            ((BackupCommands.CreateCommand)command).setConf(this.conf);
        }
        try {
            command.execute();
        }
        catch (IOException e) {
            if (e.getMessage().equals("Incorrect usage")) {
                int n = -1;
                return n;
            }
            throw e;
        }
        finally {
            command.finish();
        }
        return 0;
    }

    protected void addOptions() {
        this.addOptNoArg("d", "Enable debug loggings");
        this.addOptWithArg("t", "Table name. If specified, only backup images, which contain this table will be listed.");
        this.addOptWithArg("b", "Bandwidth per task (MapReduce task) in MB/s");
        this.addOptWithArg("l", "Backup ids list, comma-separated.");
        this.addOptWithArg("w", "Number of parallel MapReduce tasks to execute");
        this.addOptNoArg("i", "Ignore checksum verify between source snapshot and exported snapshot. Especially when the source and target file system types are different, we should use -i option to skip checksum-checks.");
        this.addOptWithArg("n", "Number of records of backup history. Default: 10");
        this.addOptWithArg("s", "Backup set name");
        this.addOptWithArg("p", "Backup destination root directory path");
        this.addOptWithArg("k", "Specifies maximum age of backup (in days) to keep during bulk delete");
        this.addOptWithArg("q", "Yarn queue name to run backup create command on");
    }

    protected void processOptions(CommandLine cmd) {
        this.cmd = cmd;
    }

    protected int doWork() throws Exception {
        return this.parseAndRun(this.cmd.getArgs());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Path hbasedir = CommonFSUtils.getRootDir((Configuration)conf);
        URI defaultFs = hbasedir.getFileSystem(conf).getUri();
        CommonFSUtils.setFsDefault((Configuration)conf, (Path)new Path(defaultFs));
        int ret = ToolRunner.run((Configuration)conf, (Tool)new BackupDriver(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws IOException {
        CommandLine cmd;
        Objects.requireNonNull(this.conf, "Tool configuration is not initialized");
        try {
            cmd = this.parseArgs(args);
            this.cmdLineArgs = args;
        }
        catch (Exception e) {
            System.err.println("Error when parsing command-line arguments: " + e.getMessage());
            this.printToolUsage();
            return 1;
        }
        this.processOptions(cmd);
        int ret = 1;
        try {
            ret = this.doWork();
        }
        catch (Exception e) {
            LOG.error("Error running command-line tool", (Throwable)e);
            return 1;
        }
        return ret;
    }

    protected void printToolUsage() throws IOException {
        System.out.println("Usage: hbase backup COMMAND [command-specific arguments]\nwhere COMMAND is one of:\n  create     create a new backup image\n  delete     delete an existing backup image\n  describe   show the detailed information of a backup image\n  history    show history of all successful backups\n  progress   show the progress of the latest backup request\n  set        backup set management\n  repair     repair backup system table\n  merge      merge backup images\nRun 'hbase backup COMMAND -h' to see help message for each command\n");
        System.out.println(BackupRestoreConstants.VERIFY_BACKUP);
    }
}

