/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupMergeJob;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceHFileSplitterJob;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MapReduceBackupMergeJob
implements BackupMergeJob {
    public static final Logger LOG = LoggerFactory.getLogger(MapReduceBackupMergeJob.class);
    protected Tool player;
    protected Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void run(String[] backupIds) throws IOException {
        this.player = new MapReduceHFileSplitterJob();
        String bulkOutputConfKey = "hfile.bulk.output";
        String bids = StringUtils.join((Object[])backupIds, (String)",");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merge backup images " + bids);
        }
        ArrayList<Pair<TableName, Path>> processedTableList = new ArrayList<Pair<TableName, Path>>();
        boolean finishedTables = false;
        Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
        BackupSystemTable table = new BackupSystemTable(conn);
        FileSystem fs = null;
        try {
            table.startBackupExclusiveOperation();
            table.startMergeOperation(backupIds);
            String mergedBackupId = BackupUtils.findMostRecentBackupId(backupIds);
            TableName[] tableNames = this.getTableNamesInBackupImages(backupIds);
            BackupInfo bInfo = table.readBackupInfo(backupIds[0]);
            String backupRoot = bInfo.getBackupRootDir();
            Path backupRootPath = new Path(backupRoot);
            fs = backupRootPath.getFileSystem(this.conf);
            for (int i = 0; i < tableNames.length; ++i) {
                LOG.info("Merge backup images for " + tableNames[i]);
                Object[] dirPaths = this.findInputDirectories(fs, backupRoot, tableNames[i], backupIds);
                String dirs = StringUtils.join((Object[])dirPaths, (String)",");
                Path tmpRestoreOutputDir = HBackupFileSystem.getBackupTmpDirPath(backupRoot);
                Path path = BackupUtils.getBulkOutputDir(tmpRestoreOutputDir, BackupUtils.getFileNameCompatibleString(tableNames[i]), this.getConf(), false);
                if (fs.exists(path) && !fs.delete(path, true)) {
                    LOG.warn("Can not delete: " + path);
                }
                Configuration conf = this.getConf();
                conf.set(bulkOutputConfKey, path.toString());
                String[] playerArgs = new String[]{dirs, tableNames[i].getNameAsString()};
                this.player.setConf(this.getConf());
                int result = this.player.run(playerArgs);
                if (!BackupUtils.succeeded(result)) {
                    throw new IOException("Can not merge backup images for " + dirs + " (check Hadoop/MR and HBase logs). Player return code =" + result);
                }
                processedTableList.add((Pair<TableName, Path>)new Pair((Object)tableNames[i], (Object)path));
                LOG.debug("Merge Job finished:" + result);
            }
            List<TableName> tableList = this.toTableNameList(processedTableList);
            table.updateProcessedTablesForMerge(tableList);
            finishedTables = true;
            Path tmpBackupDir = HBackupFileSystem.getBackupTmpDirPathForBackupId(backupRoot, mergedBackupId);
            Path backupDirPath = HBackupFileSystem.getBackupPath(backupRoot, mergedBackupId);
            if (!fs.rename(backupDirPath, tmpBackupDir)) {
                throw new IOException("Failed to rename " + backupDirPath + " to " + tmpBackupDir);
            }
            LOG.debug("Renamed " + backupDirPath + " to " + tmpBackupDir);
            for (Pair pair : processedTableList) {
                this.moveData(fs, backupRoot, (Path)pair.getSecond(), (TableName)pair.getFirst(), mergedBackupId);
            }
            List<String> backupsToDelete = this.getBackupIdsToDelete(backupIds, mergedBackupId);
            this.updateBackupManifest(tmpBackupDir.getParent().toString(), mergedBackupId, backupsToDelete);
            this.copyMetaData(fs, tmpBackupDir, backupDirPath);
            if (!fs.delete(tmpBackupDir, true)) {
                LOG.warn("Could not delete tmp dir: " + tmpBackupDir);
            }
            this.deleteBackupImages(backupsToDelete, conn, fs, backupRoot);
            table.finishMergeOperation();
            table.finishBackupExclusiveOperation();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            if (!finishedTables) {
                if (fs != null) {
                    this.cleanupBulkLoadDirs(fs, this.toPathList(processedTableList));
                }
                table.finishMergeOperation();
                table.finishBackupExclusiveOperation();
                throw new IOException("Backup merge operation failed, you should try it again", e);
            }
            throw new IOException("Backup merge operation failed, run backup repair tool to restore system's integrity", e);
        }
        finally {
            table.close();
            conn.close();
        }
    }

    protected void copyMetaData(FileSystem fs, Path tmpBackupDir, Path backupDirPath) throws IOException {
        RemoteIterator it = fs.listFiles(tmpBackupDir, true);
        ArrayList<Path> toKeep = new ArrayList<Path>();
        while (it.hasNext()) {
            String fileName;
            Path p = ((LocatedFileStatus)it.next()).getPath();
            if (fs.isDirectory(p) || (fileName = p.toString()).indexOf(".tabledesc") <= 0 && fileName.indexOf(".regioninfo") <= 0 && fileName.indexOf(".backup.manifest") <= 0) continue;
            toKeep.add(p);
        }
        for (Path p : toKeep) {
            Path newPath = this.convertToDest(p, backupDirPath);
            LOG.info("Copying tmp metadata from {} to {}", (Object)p, (Object)newPath);
            this.copyFile(fs, p, newPath);
        }
    }

    protected void copyFile(FileSystem fs, Path p, Path newPath) throws IOException {
        try (FSDataInputStream in = fs.open(p);
             FSDataOutputStream out = fs.create(newPath, true);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        boolean exists = fs.exists(newPath);
        if (!exists) {
            throw new IOException("Failed to copy meta file to: " + newPath);
        }
    }

    protected Path convertToDest(Path p, Path backupDirPath) {
        String backupId = backupDirPath.getName();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String name = null;
        while (!(name = p.getName()).equals(backupId)) {
            stack.push(name);
            p = p.getParent();
        }
        Path newPath = new Path(backupDirPath.toString());
        while (!stack.isEmpty()) {
            newPath = new Path(newPath, (String)stack.pop());
        }
        return newPath;
    }

    protected List<Path> toPathList(List<Pair<TableName, Path>> processedTableList) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (Pair<TableName, Path> p : processedTableList) {
            list.add((Path)p.getSecond());
        }
        return list;
    }

    protected List<TableName> toTableNameList(List<Pair<TableName, Path>> processedTableList) {
        ArrayList<TableName> list = new ArrayList<TableName>();
        for (Pair<TableName, Path> p : processedTableList) {
            list.add((TableName)p.getFirst());
        }
        return list;
    }

    protected void cleanupBulkLoadDirs(FileSystem fs, List<Path> pathList) throws IOException {
        for (Path path : pathList) {
            if (fs.delete(path, true)) continue;
            LOG.warn("Can't delete " + path);
        }
    }

    protected void updateBackupManifest(String backupRoot, String mergedBackupId, List<String> backupsToDelete) throws IllegalArgumentException, IOException {
        BackupManifest manifest = HBackupFileSystem.getManifest(this.conf, new Path(backupRoot), mergedBackupId);
        LOG.info("Removing ancestors from merged backup {} : {}", (Object)mergedBackupId, backupsToDelete);
        manifest.getBackupImage().removeAncestors(backupsToDelete);
        LOG.info("Creating new manifest file for merged backup {} at root {}", (Object)mergedBackupId, (Object)backupRoot);
        manifest.store(this.conf);
    }

    protected void deleteBackupImages(List<String> backupIds, Connection conn, FileSystem fs, String backupRoot) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(conn);){
            for (String backupId : backupIds) {
                LOG.info("Removing metadata for backup {}", (Object)backupId);
                table.deleteBackupInfo(backupId);
            }
        }
        for (String backupId : backupIds) {
            LOG.info("Purging backup {} from FileSystem", (Object)backupId);
            Path backupDirPath = HBackupFileSystem.getBackupPath(backupRoot, backupId);
            if (fs.delete(backupDirPath, true)) continue;
            LOG.warn("Could not delete " + backupDirPath);
        }
    }

    protected List<String> getBackupIdsToDelete(String[] backupIds, String mergedBackupId) {
        ArrayList<String> list = new ArrayList<String>();
        for (String id : backupIds) {
            if (id.equals(mergedBackupId)) continue;
            list.add(id);
        }
        return list;
    }

    protected void moveData(FileSystem fs, String backupRoot, Path bulkOutputPath, TableName tableName, String mergedBackupId) throws IllegalArgumentException, IOException {
        FileStatus[] fsts;
        Path dest = new Path(HBackupFileSystem.getTableBackupDir(backupRoot, mergedBackupId, tableName));
        for (FileStatus fst : fsts = fs.listStatus(bulkOutputPath)) {
            if (!fst.isDirectory()) continue;
            String family = fst.getPath().getName();
            Path newDst = new Path(dest, family);
            if (fs.exists(newDst)) {
                if (!fs.delete(newDst, true)) {
                    throw new IOException("failed to delete :" + newDst);
                }
            } else {
                fs.mkdirs(dest);
            }
            boolean result = fs.rename(fst.getPath(), dest);
            LOG.debug("MoveData from " + fst.getPath() + " to " + dest + " result=" + result);
        }
    }

    protected TableName[] getTableNamesInBackupImages(String[] backupIds) throws IOException {
        HashSet<TableName> allSet = new HashSet<TableName>();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
             BackupSystemTable table = new BackupSystemTable(conn);){
            for (String backupId : backupIds) {
                BackupInfo bInfo = table.readBackupInfo(backupId);
                allSet.addAll(bInfo.getTableNames());
            }
        }
        TableName[] ret = new TableName[allSet.size()];
        return allSet.toArray(ret);
    }

    protected Path[] findInputDirectories(FileSystem fs, String backupRoot, TableName tableName, String[] backupIds) throws IOException {
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (String backupId : backupIds) {
            Path fileBackupDirPath = new Path(HBackupFileSystem.getTableBackupDir(backupRoot, backupId, tableName));
            if (fs.exists(fileBackupDirPath)) {
                dirs.add(fileBackupDirPath);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("File: " + fileBackupDirPath + " does not exist.");
        }
        Path[] ret = new Path[dirs.size()];
        return dirs.toArray(ret);
    }
}

