/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IncrementalBackupManager
extends BackupManager {
    public static final Logger LOG = LoggerFactory.getLogger(IncrementalBackupManager.class);

    public IncrementalBackupManager(Connection conn, Configuration conf) throws IOException {
        super(conn, conf);
    }

    public Map<String, Long> getIncrBackupLogFileMap() throws IOException {
        String savedStartCode = this.readBackupStartCode();
        Map<TableName, Map<String, Long>> previousTimestampMap = this.readLogTimestampMap();
        Map<String, Long> previousTimestampMins = BackupUtils.getRSLogTimestampMins(previousTimestampMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("StartCode " + savedStartCode + "for backupID " + this.backupInfo.getBackupId());
        }
        if (savedStartCode == null || previousTimestampMins == null || previousTimestampMins.isEmpty()) {
            throw new IOException("Cannot read any previous back up timestamps from backup system table. In order to create an incremental backup, at least one full backup is needed.");
        }
        LOG.info("Execute roll log procedure for incremental backup ...");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("backupRoot", this.backupInfo.getBackupRootDir());
        try (Admin admin = this.conn.getAdmin();){
            admin.execProcedure("rolllog-proc", "rolllog", props);
        }
        HashMap<String, Long> newTimestamps = this.readRegionServerLastLogRollResult();
        List<String> logList = this.getLogFilesForNewBackup(previousTimestampMins, newTimestamps, this.conf, savedStartCode);
        logList = this.excludeProcV2WALs(logList);
        this.backupInfo.setIncrBackupFileList(logList);
        return newTimestamps;
    }

    private List<String> excludeProcV2WALs(List<String> logList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < logList.size(); ++i) {
            Path p = new Path(logList.get(i));
            String name = p.getName();
            if (name.startsWith("pv2-")) continue;
            list.add(logList.get(i));
        }
        return list;
    }

    private List<String> getLogFilesForNewBackup(Map<String, Long> olderTimestamps, Map<String, Long> newestTimestamps, Configuration conf, String savedStartCode) throws IOException {
        FileStatus[] oldlogs;
        long currentLogTS;
        String currentLogFile;
        Long oldTimeStamp;
        String host;
        Path p;
        FileStatus[] rss;
        LOG.debug("In getLogFilesForNewBackup()\nolderTimestamps: " + olderTimestamps + "\n newestTimestamps: " + newestTimestamps);
        Path walRootDir = CommonFSUtils.getWALRootDir((Configuration)conf);
        Path logDir = new Path(walRootDir, "WALs");
        Path oldLogDir = new Path(walRootDir, "oldWALs");
        FileSystem fs = walRootDir.getFileSystem(conf);
        NewestLogFilter pathFilter = new NewestLogFilter();
        ArrayList<String> resultLogFiles = new ArrayList<String>();
        ArrayList<String> newestLogs = new ArrayList<String>();
        for (FileStatus rs : rss = fs.listStatus(logDir)) {
            FileStatus[] logs;
            p = rs.getPath();
            host = BackupUtils.parseHostNameFromLogFile(p);
            if (host == null) continue;
            oldTimeStamp = olderTimestamps.get(host);
            if (oldTimeStamp == null) {
                logs = fs.listStatus(p);
            } else {
                pathFilter.setLastBackupTS(oldTimeStamp);
                logs = fs.listStatus(p, (PathFilter)pathFilter);
            }
            for (FileStatus log : logs) {
                LOG.debug("currentLogFile: " + log.getPath().toString());
                if (AbstractFSWALProvider.isMetaFile((Path)log.getPath())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skip hbase:meta log file: " + log.getPath().getName());
                    continue;
                }
                currentLogFile = log.getPath().toString();
                resultLogFiles.add(currentLogFile);
                currentLogTS = BackupUtils.getCreationTime(log.getPath());
                Long ts = newestTimestamps.get(host);
                if (ts == null) {
                    LOG.warn("ORPHAN log found: " + log + " host=" + host);
                    LOG.debug("Known hosts (from newestTimestamps):");
                    for (String s : newestTimestamps.keySet()) {
                        LOG.debug(s);
                    }
                }
                if (ts != null && currentLogTS <= ts) continue;
                newestLogs.add(currentLogFile);
            }
        }
        for (FileStatus oldlog : oldlogs = fs.listStatus(oldLogDir)) {
            p = oldlog.getPath();
            currentLogFile = p.toString();
            if (AbstractFSWALProvider.isMetaFile((Path)p)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skip .meta log file: " + currentLogFile);
                continue;
            }
            host = BackupUtils.parseHostFromOldLog(p);
            if (host == null) continue;
            currentLogTS = BackupUtils.getCreationTime(p);
            oldTimeStamp = olderTimestamps.get(host);
            if (oldTimeStamp == null) {
                if (currentLogTS < Long.parseLong(savedStartCode)) continue;
                resultLogFiles.add(currentLogFile);
            } else if (currentLogTS > oldTimeStamp) {
                resultLogFiles.add(currentLogFile);
            }
            Long newTimestamp = newestTimestamps.get(host);
            if (newTimestamp != null && currentLogTS <= newTimestamp) continue;
            newestLogs.add(currentLogFile);
        }
        resultLogFiles.removeAll(newestLogs);
        return resultLogFiles;
    }

    static class NewestLogFilter
    implements PathFilter {
        private Long lastBackupTS = 0L;

        protected void setLastBackupTS(Long ts) {
            this.lastBackupTS = ts;
        }

        public boolean accept(Path path) {
            if (AbstractFSWALProvider.isMetaFile((Path)path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skip .meta log file: " + path.getName());
                }
                return false;
            }
            try {
                long timestamp = BackupUtils.getCreationTime(path);
                return timestamp > this.lastBackupTS;
            }
            catch (Exception e) {
                LOG.warn("Cannot read timestamp of log file " + path);
                return false;
            }
        }
    }
}

