/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(about="Metrics for TimelineDataManager", context="yarn")
public class TimelineDataManagerMetrics {
    @Metric(value={"getEntities calls"})
    MutableCounterLong getEntitiesOps;
    @Metric(value={"Entities returned via getEntities"})
    MutableCounterLong getEntitiesTotal;
    @Metric(value={"getEntities processing time"})
    MutableRate getEntitiesTime;
    @Metric(value={"getEntity calls"})
    MutableCounterLong getEntityOps;
    @Metric(value={"getEntity processing time"})
    MutableRate getEntityTime;
    @Metric(value={"getEvents calls"})
    MutableCounterLong getEventsOps;
    @Metric(value={"Events returned via getEvents"})
    MutableCounterLong getEventsTotal;
    @Metric(value={"getEvents processing time"})
    MutableRate getEventsTime;
    @Metric(value={"postEntities calls"})
    MutableCounterLong postEntitiesOps;
    @Metric(value={"Entities posted via postEntities"})
    MutableCounterLong postEntitiesTotal;
    @Metric(value={"postEntities processing time"})
    MutableRate postEntitiesTime;
    @Metric(value={"putDomain calls"})
    MutableCounterLong putDomainOps;
    @Metric(value={"putDomain processing time"})
    MutableRate putDomainTime;
    @Metric(value={"getDomain calls"})
    MutableCounterLong getDomainOps;
    @Metric(value={"getDomain processing time"})
    MutableRate getDomainTime;
    @Metric(value={"getDomains calls"})
    MutableCounterLong getDomainsOps;
    @Metric(value={"Domains returned via getDomains"})
    MutableCounterLong getDomainsTotal;
    @Metric(value={"getDomains processing time"})
    MutableRate getDomainsTime;
    private static TimelineDataManagerMetrics instance = null;

    @Metric(value={"Total calls"})
    public long totalOps() {
        return this.getEntitiesOps.value() + this.getEntityOps.value() + this.getEventsOps.value() + this.postEntitiesOps.value() + this.putDomainOps.value() + this.getDomainOps.value() + this.getDomainsOps.value();
    }

    TimelineDataManagerMetrics() {
    }

    public static synchronized TimelineDataManagerMetrics create() {
        if (instance == null) {
            MetricsSystem ms = DefaultMetricsSystem.instance();
            instance = (TimelineDataManagerMetrics)ms.register((Object)new TimelineDataManagerMetrics());
        }
        return instance;
    }

    public void incrGetEntitiesOps() {
        this.getEntitiesOps.incr();
    }

    public void incrGetEntitiesTotal(long delta) {
        this.getEntitiesTotal.incr(delta);
    }

    public void addGetEntitiesTime(long msec) {
        this.getEntitiesTime.add(msec);
    }

    public void incrGetEntityOps() {
        this.getEntityOps.incr();
    }

    public void addGetEntityTime(long msec) {
        this.getEntityTime.add(msec);
    }

    public void incrGetEventsOps() {
        this.getEventsOps.incr();
    }

    public void incrGetEventsTotal(long delta) {
        this.getEventsTotal.incr(delta);
    }

    public void addGetEventsTime(long msec) {
        this.getEventsTime.add(msec);
    }

    public void incrPostEntitiesOps() {
        this.postEntitiesOps.incr();
    }

    public void incrPostEntitiesTotal(long delta) {
        this.postEntitiesTotal.incr(delta);
    }

    public void addPostEntitiesTime(long msec) {
        this.postEntitiesTime.add(msec);
    }

    public void incrPutDomainOps() {
        this.putDomainOps.incr();
    }

    public void addPutDomainTime(long msec) {
        this.putDomainTime.add(msec);
    }

    public void incrGetDomainOps() {
        this.getDomainOps.incr();
    }

    public void addGetDomainTime(long msec) {
        this.getDomainTime.add(msec);
    }

    public void incrGetDomainsOps() {
        this.getDomainsOps.incr();
    }

    public void incrGetDomainsTotal(long delta) {
        this.getDomainsTotal.incr(delta);
    }

    public void addGetDomainsTime(long msec) {
        this.getDomainsTime.add(msec);
    }
}

