/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.base.Splitter;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationAttemptId
implements Comparable<ApplicationAttemptId> {
    private static Splitter _spliter = Splitter.on((char)'_').trimResults();
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appAttemptIdStrPrefix = "appattempt";
    static final ThreadLocal<NumberFormat> attemptIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ApplicationAttemptId newInstance(ApplicationId appId, int attemptId) {
        ApplicationAttemptId appAttemptId = Records.newRecord(ApplicationAttemptId.class);
        appAttemptId.setApplicationId(appId);
        appAttemptId.setAttemptId(attemptId);
        appAttemptId.build();
        return appAttemptId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setAttemptId(int var1);

    public int hashCode() {
        int prime = 347671;
        int result = 5501;
        ApplicationId appId = this.getApplicationId();
        result = 347671 * result + appId.hashCode();
        result = 347671 * result + this.getAttemptId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttemptId other = (ApplicationAttemptId)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getAttemptId() == other.getAttemptId();
    }

    @Override
    public int compareTo(ApplicationAttemptId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getAttemptId() - other.getAttemptId();
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(appAttemptIdStrPrefix);
        sb.append("_");
        sb.append(this.getApplicationId().getClusterTimestamp()).append("_");
        sb.append(ApplicationId.appIdFormat.get().format(this.getApplicationId().getId()));
        sb.append("_").append(attemptIdFormat.get().format(this.getAttemptId()));
        return sb.toString();
    }

    protected abstract void build();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationAttemptId fromString(String applicationAttemptIdStr) {
        Iterator<String> it = _spliter.split((CharSequence)applicationAttemptIdStr).iterator();
        if (!((String)it.next()).equals(appAttemptIdStrPrefix)) {
            throw new IllegalArgumentException("Invalid AppAttemptId prefix: " + applicationAttemptIdStr);
        }
        try {
            return ApplicationAttemptId.toApplicationAttemptId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + applicationAttemptIdStr, n);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + applicationAttemptIdStr, e);
        }
    }

    private static ApplicationAttemptId toApplicationAttemptId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance(appId, Integer.parseInt(it.next()));
        return appAttemptId;
    }
}

