/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Container
implements Comparable<Container> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static Container newInstance(ContainerId containerId, NodeId nodeId, String nodeHttpAddress, Resource resource, Priority priority, Token containerToken) {
        return Container.newInstance(containerId, nodeId, nodeHttpAddress, resource, priority, containerToken, ExecutionType.GUARANTEED);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static Container newInstance(ContainerId containerId, NodeId nodeId, String nodeHttpAddress, Resource resource, Priority priority, Token containerToken, ExecutionType executionType) {
        Container container = Records.newRecord(Container.class);
        container.setId(containerId);
        container.setNodeId(nodeId);
        container.setNodeHttpAddress(nodeHttpAddress);
        container.setResource(resource);
        container.setPriority(priority);
        container.setContainerToken(containerToken);
        container.setExecutionType(executionType);
        return container;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerId getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setId(ContainerId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract NodeId getNodeId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeId(NodeId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getNodeHttpAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeHttpAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getResource();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResource(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Token getContainerToken();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setContainerToken(Token var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract ExecutionType getExecutionType();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExecutionType(ExecutionType var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public long getAllocationRequestId() {
        throw new UnsupportedOperationException();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public void setAllocationRequestId(long allocationRequestID) {
        throw new UnsupportedOperationException();
    }
}

