/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    private ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    private final AppContext context;
    protected ThreadPoolExecutor launcherPool;
    protected int initialPoolSize;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    protected BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue<ContainerLauncherEvent>();
    private final AtomicBoolean stopped;
    private ContainerManagementProtocolProxy cmProxy;

    private Container getContainer(ContainerLauncherEvent event) {
        Container old;
        ContainerId id = event.getContainerID();
        Container c = this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container(event.getTaskAttemptID(), event.getContainerID(), event.getContainerMgrAddress()))) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
        this.stopped = new AtomicBoolean(false);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.limitOnPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 500);
        LOG.info((Object)("Upper limit on the thread pool size is " + this.limitOnPoolSize));
        this.initialPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.threadpool-initial-size", 10);
        LOG.info((Object)("The thread pool initial size is " + this.initialPoolSize));
        super.serviceInit(conf);
        this.cmProxy = new ContainerManagementProtocolProxy(conf);
    }

    protected void serviceStart() throws Exception {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(this.initialPoolSize, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                ContainerLauncherEvent event = null;
                HashSet<String> allNodes = new HashSet<String>();
                while (!ContainerLauncherImpl.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    try {
                        event = ContainerLauncherImpl.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!ContainerLauncherImpl.this.stopped.get()) {
                            LOG.error((Object)("Returning, interrupted : " + e));
                        }
                        return;
                    }
                    allNodes.add(event.getContainerMgrAddress());
                    int poolSize = ContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != ContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = allNodes.size();
                        int idealPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize < idealPoolSize) {
                            int newPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, idealPoolSize + ContainerLauncherImpl.this.initialPoolSize);
                            LOG.info((Object)("Setting ContainerLauncher pool size to " + newPoolSize + " as number-of-nodes to talk to is " + numNodes));
                            ContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    ContainerLauncherImpl.this.launcherPool.execute(ContainerLauncherImpl.this.createEventProcessor(event));
                }
            }
        };
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    private void shutdownAllContainers() {
        for (Container ct : this.containers.values()) {
            if (ct == null) continue;
            ct.kill();
        }
    }

    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        this.shutdownAllContainers();
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        if (this.launcherPool != null) {
            this.launcherPool.shutdownNow();
        }
        super.serviceStop();
    }

    protected EventProcessor createEventProcessor(ContainerLauncherEvent event) {
        return new EventProcessor(event);
    }

    void sendContainerLaunchFailedMsg(TaskAttemptId taskAttemptID, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData getCMProxy(String containerMgrBindAddr, ContainerId containerId) throws IOException {
        return this.cmProxy.getProxy(containerMgrBindAddr, containerId);
    }

    class EventProcessor
    implements Runnable {
        private ContainerLauncherEvent event;

        EventProcessor(ContainerLauncherEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            ContainerId containerID = this.event.getContainerID();
            Container c = ContainerLauncherImpl.this.getContainer(this.event);
            switch ((ContainerLauncher.EventType)this.event.getType()) {
                case CONTAINER_REMOTE_LAUNCH: {
                    ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)this.event;
                    c.launch(launchEvent);
                    break;
                }
                case CONTAINER_REMOTE_CLEANUP: {
                    c.kill(this.event.getDumpContainerThreads());
                    break;
                }
                case CONTAINER_COMPLETED: {
                    c.done();
                }
            }
            ContainerLauncherImpl.this.removeContainerIfDone(containerID);
        }
    }

    private class Container {
        private ContainerState state = ContainerState.PREP;
        private TaskAttemptId taskAttemptID;
        private ContainerId containerID;
        private final String containerMgrAddress;

        public Container(TaskAttemptId taId, ContainerId containerID, String containerMgrAddress) {
            this.taskAttemptID = taId;
            this.containerMgrAddress = containerMgrAddress;
            this.containerID = containerID;
        }

        public synchronized boolean isCompletelyDone() {
            return this.state == ContainerState.DONE || this.state == ContainerState.FAILED;
        }

        public synchronized void done() {
            this.state = ContainerState.DONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void launch(ContainerRemoteLaunchEvent event) {
            LOG.info((Object)("Launching " + this.taskAttemptID));
            if (this.state == ContainerState.KILLED_BEFORE_LAUNCH) {
                this.state = ContainerState.DONE;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.taskAttemptID, "Container was killed before it was launched");
                return;
            }
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = ContainerLauncherImpl.this.getCMProxy(this.containerMgrAddress, this.containerID);
                ContainerLaunchContext containerLaunchContext = event.getContainerLaunchContext();
                StartContainerRequest startRequest = StartContainerRequest.newInstance((ContainerLaunchContext)containerLaunchContext, (Token)event.getContainerToken());
                ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
                list.add(startRequest);
                StartContainersRequest requestList = StartContainersRequest.newInstance(list);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(requestList);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(this.containerID)) {
                    throw ((SerializedException)response.getFailedRequests().get(this.containerID)).deSerialize();
                }
                ByteBuffer portInfo = (ByteBuffer)response.getAllServicesMetaData().get("mapreduce_shuffle");
                int port = -1;
                if (portInfo != null) {
                    port = ShuffleHandler.deserializeMetaData((ByteBuffer)portInfo);
                }
                LOG.info((Object)("Shuffle port returned by ContainerManager for " + this.taskAttemptID + " : " + port));
                if (port < 0) {
                    this.state = ContainerState.FAILED;
                    throw new IllegalStateException("Invalid shuffle port number " + port + " returned for " + this.taskAttemptID);
                }
                ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptContainerLaunchedEvent(this.taskAttemptID, port));
                this.state = ContainerState.RUNNING;
            }
            catch (Throwable t) {
                String message = "Container launch failed for " + this.containerID + " : " + StringUtils.stringifyException((Throwable)t);
                this.state = ContainerState.FAILED;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.taskAttemptID, message);
            }
            finally {
                if (proxy != null) {
                    ContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                }
            }
        }

        public void kill() {
            this.kill(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void kill(boolean dumpThreads) {
            if (this.state == ContainerState.PREP) {
                this.state = ContainerState.KILLED_BEFORE_LAUNCH;
            } else if (!this.isCompletelyDone()) {
                LOG.info((Object)("KILLING " + this.taskAttemptID));
                ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
                try {
                    proxy = ContainerLauncherImpl.this.getCMProxy(this.containerMgrAddress, this.containerID);
                    if (dumpThreads) {
                        SignalContainerRequest request = SignalContainerRequest.newInstance((ContainerId)this.containerID, (SignalContainerCommand)SignalContainerCommand.OUTPUT_THREAD_DUMP);
                        proxy.getContainerManagementProtocol().signalToContainer(request);
                    }
                    ArrayList<ContainerId> ids = new ArrayList<ContainerId>();
                    ids.add(this.containerID);
                    StopContainersRequest request = StopContainersRequest.newInstance(ids);
                    StopContainersResponse response = proxy.getContainerManagementProtocol().stopContainers(request);
                    if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(this.containerID)) {
                        throw ((SerializedException)response.getFailedRequests().get(this.containerID)).deSerialize();
                    }
                }
                catch (Throwable t) {
                    String message = "cleanup failed for container " + this.containerID + " : " + StringUtils.stringifyException((Throwable)t);
                    ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(this.taskAttemptID, message));
                    LOG.warn((Object)message);
                }
                finally {
                    if (proxy != null) {
                        ContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                    }
                }
                this.state = ContainerState.DONE;
            }
            ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptEvent(this.taskAttemptID, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        }
    }

    private static enum ContainerState {
        PREP,
        FAILED,
        RUNNING,
        DONE,
        KILLED_BEFORE_LAUNCH;

    }
}

