/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.tasktracker;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.JobID;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Localizer {
    static final Log LOG = LogFactory.getLog(Localizer.class);
    private FileSystem fs;
    private String[] localDirs;
    private TaskController taskController;
    private Map<String, AtomicBoolean> localizedUsers = new HashMap<String, AtomicBoolean>();

    public Localizer(FileSystem fileSys, String[] lDirs, TaskController tc) {
        this.fs = fileSys;
        this.localDirs = lDirs;
        this.taskController = tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeUserDirs(String user) throws IOException {
        AtomicBoolean localizedUser;
        if (user == null) {
            throw new IOException("User is null. Cannot initialized user-directories.");
        }
        Object object = this.localizedUsers;
        synchronized (object) {
            if (!this.localizedUsers.containsKey(user)) {
                this.localizedUsers.put(user, new AtomicBoolean(false));
            }
            localizedUser = this.localizedUsers.get(user);
        }
        object = localizedUser;
        synchronized (object) {
            if (localizedUser.get()) {
                LOG.info((Object)("User-directories for the user " + user + " are already initialized on this TT. Not doing anything."));
                return;
            }
            LOG.info((Object)("Initializing user " + user + " on this TT."));
            boolean userDirStatus = false;
            boolean jobCacheDirStatus = false;
            boolean distributedCacheDirStatus = false;
            for (String localDir : this.localDirs) {
                Path userDir = new Path(localDir, TaskTracker.getUserDir(user));
                if (this.fs.exists(userDir) || this.fs.mkdirs(userDir)) {
                    this.fs.setPermission(userDir, new FsPermission(448));
                    userDirStatus = true;
                    Path jobCacheDir = new Path(localDir, TaskTracker.getJobCacheSubdir(user));
                    if (this.fs.exists(jobCacheDir) || this.fs.mkdirs(jobCacheDir)) {
                        this.fs.setPermission(jobCacheDir, new FsPermission(448));
                        jobCacheDirStatus = true;
                    } else {
                        LOG.warn((Object)("Unable to create job cache directory : " + jobCacheDir));
                    }
                    Path distributedCacheDir = new Path(localDir, TaskTracker.getPrivateDistributedCacheDir(user));
                    if (this.fs.exists(distributedCacheDir) || this.fs.mkdirs(distributedCacheDir)) {
                        this.fs.setPermission(distributedCacheDir, new FsPermission(448));
                        distributedCacheDirStatus = true;
                        continue;
                    }
                    LOG.warn((Object)("Unable to create distributed-cache directory : " + distributedCacheDir));
                    continue;
                }
                LOG.warn((Object)("Unable to create the user directory : " + userDir));
            }
            if (!userDirStatus) {
                throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
            }
            if (!jobCacheDirStatus) {
                throw new IOException("Not able to initialize job-cache directories in any of the configured local directories for user " + user);
            }
            if (!distributedCacheDirStatus) {
                throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
            }
            TaskController.InitializationContext context = new TaskController.InitializationContext();
            context.user = user;
            context.workDir = null;
            this.taskController.initializeUser(context);
            localizedUser.set(true);
        }
    }

    public void initializeJobDirs(String user, JobID jobId) throws IOException {
        boolean initJobDirStatus = false;
        String jobDirPath = TaskTracker.getLocalJobDir(user, jobId.toString());
        for (String localDir : this.localDirs) {
            boolean jobDirStatus;
            Path jobDir = new Path(localDir, jobDirPath);
            if (this.fs.exists(jobDir)) {
                this.fs.delete(jobDir, true);
            }
            if (!(jobDirStatus = this.fs.mkdirs(jobDir))) {
                LOG.warn((Object)("Not able to create job directory " + jobDir.toString()));
            }
            initJobDirStatus = initJobDirStatus || jobDirStatus;
            this.fs.setPermission(jobDir, new FsPermission(448));
        }
        if (!initJobDirStatus) {
            throw new IOException("Not able to initialize job directories in any of the configured local directories for job " + jobId.toString());
        }
    }

    public void initializeAttemptDirs(String user, String jobId, String attemptId, boolean isCleanupAttempt) throws IOException {
        boolean initStatus = false;
        String attemptDirPath = TaskTracker.getLocalTaskDir(user, jobId, attemptId, isCleanupAttempt);
        for (String localDir : this.localDirs) {
            Path localAttemptDir = new Path(localDir, attemptDirPath);
            boolean attemptDirStatus = this.fs.mkdirs(localAttemptDir);
            if (!attemptDirStatus) {
                LOG.warn((Object)("localAttemptDir " + localAttemptDir.toString() + " couldn't be created."));
            }
            initStatus = initStatus || attemptDirStatus;
        }
        if (!initStatus) {
            throw new IOException("Not able to initialize attempt directories in any of the configured local directories for the attempt " + attemptId);
        }
    }

    public void initializeJobLogDir(JobID jobId) throws IOException {
        Path jobUserLogDir = new Path(TaskLog.getJobDir(jobId).getCanonicalPath());
        if (!this.fs.mkdirs(jobUserLogDir)) {
            throw new IOException("Could not create job user log directory: " + jobUserLogDir);
        }
        this.fs.setPermission(jobUserLogDir, new FsPermission(448));
    }
}

