/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStarted;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TaskAttemptStarted datum = new TaskAttemptStarted();

    public TaskAttemptStartedEvent(TaskAttemptID attemptId, TaskType taskType, long startTime, String trackerName, int httpPort) {
        this.datum.attemptId = new Utf8(attemptId.toString());
        this.datum.taskid = new Utf8(attemptId.getTaskID().toString());
        this.datum.startTime = startTime;
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.trackerName = new Utf8(trackerName);
        this.datum.httpPort = httpPort;
    }

    TaskAttemptStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskAttemptStarted)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(((Object)this.datum.taskid).toString());
    }

    public String getTrackerName() {
        return ((Object)this.datum.trackerName).toString();
    }

    public long getStartTime() {
        return this.datum.startTime;
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(((Object)this.datum.taskType).toString());
    }

    public int getHttpPort() {
        return this.datum.httpPort;
    }

    public TaskAttemptID getTaskAttemptId() {
        return TaskAttemptID.forName(((Object)this.datum.attemptId).toString());
    }

    @Override
    public EventType getEventType() {
        return this.getTaskId().getTaskType() == TaskType.MAP ? EventType.MAP_ATTEMPT_STARTED : EventType.REDUCE_ATTEMPT_STARTED;
    }
}

