/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventReader
implements Closeable {
    private String version;
    private Schema schema;
    private DataInputStream in;
    private Decoder decoder;
    private DatumReader<Event> reader;

    public EventReader(FileSystem fs, Path name) throws IOException {
        this((DataInputStream)fs.open(name));
    }

    public EventReader(DataInputStream in) throws IOException {
        this.in = in;
        this.version = in.readLine();
        if (!"Avro-Json".equals(this.version)) {
            throw new IOException("Incompatible event log version: " + this.version);
        }
        this.schema = Schema.parse((String)in.readLine());
        this.reader = new SpecificDatumReader(this.schema);
        this.decoder = DecoderFactory.get().jsonDecoder(this.schema, (InputStream)in);
    }

    public HistoryEvent getNextEvent() throws IOException {
        HistoryEvent result;
        Event wrapper;
        try {
            wrapper = (Event)((Object)this.reader.read(null, this.decoder));
        }
        catch (EOFException e) {
            return null;
        }
        switch (wrapper.type) {
            case JOB_SUBMITTED: {
                result = new JobSubmittedEvent();
                break;
            }
            case JOB_INITED: {
                result = new JobInitedEvent();
                break;
            }
            case JOB_FINISHED: {
                result = new JobFinishedEvent();
                break;
            }
            case JOB_PRIORITY_CHANGED: {
                result = new JobPriorityChangeEvent();
                break;
            }
            case JOB_STATUS_CHANGED: {
                result = new JobStatusChangedEvent();
                break;
            }
            case JOB_FAILED: {
                result = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_KILLED: {
                result = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_INFO_CHANGED: {
                result = new JobInfoChangeEvent();
                break;
            }
            case TASK_STARTED: {
                result = new TaskStartedEvent();
                break;
            }
            case TASK_FINISHED: {
                result = new TaskFinishedEvent();
                break;
            }
            case TASK_FAILED: {
                result = new TaskFailedEvent();
                break;
            }
            case TASK_UPDATED: {
                result = new TaskUpdatedEvent();
                break;
            }
            case MAP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case MAP_ATTEMPT_FINISHED: {
                result = new MapAttemptFinishedEvent();
                break;
            }
            case MAP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case MAP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FINISHED: {
                result = new ReduceAttemptFinishedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case SETUP_ATTEMPT_FINISHED: {
                result = new TaskAttemptFinishedEvent();
                break;
            }
            case SETUP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FINISHED: {
                result = new TaskAttemptFinishedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event type!");
            }
        }
        result.setDatum(wrapper.event);
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    static Counters fromAvro(JhCounters counters) {
        Counters result = new Counters();
        for (JhCounterGroup g : counters.groups) {
            CounterGroup group = new CounterGroup(((Object)g.name).toString(), ((Object)g.displayName).toString());
            for (JhCounter c : g.counts) {
                group.addCounter(new Counter(((Object)c.name).toString(), ((Object)c.displayName).toString(), c.value));
            }
            result.addGroup(group);
        }
        return result;
    }
}

