/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.util.StringUtils;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
implements Writable,
Iterable<Group> {
    private static final Log LOG = LogFactory.getLog(Counters.class);
    private static final char GROUP_OPEN = '{';
    private static final char GROUP_CLOSE = '}';
    private static final char COUNTER_OPEN = '[';
    private static final char COUNTER_CLOSE = ']';
    private static final char UNIT_OPEN = '(';
    private static final char UNIT_CLOSE = ')';
    private static char[] charsToEscape = new char[]{'{', '}', '[', ']', '(', ')'};
    private Map<String, Group> counters = new HashMap<String, Group>();
    private Map<Enum, Counter> cache = new IdentityHashMap<Enum, Counter>();

    static Counters downgrade(org.apache.hadoop.mapreduce.Counters newCounters) {
        Counters oldCounters = new Counters();
        for (CounterGroup newGroup : newCounters) {
            String groupName = newGroup.getName();
            Group oldGroup = oldCounters.getGroup(groupName);
            for (org.apache.hadoop.mapreduce.Counter newCounter : newGroup) {
                Counter oldCounter = oldGroup.getCounterForName(newCounter.getName());
                oldCounter.setDisplayName(newCounter.getDisplayName());
                oldCounter.increment(newCounter.getValue());
            }
        }
        return oldCounters;
    }

    public synchronized Collection<String> getGroupNames() {
        return this.counters.keySet();
    }

    @Override
    public synchronized Iterator<Group> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized Group getGroup(String groupName) {
        if (groupName.equals("org.apache.hadoop.mapred.Task$Counter")) {
            groupName = "org.apache.hadoop.mapreduce.TaskCounter";
            LOG.warn((Object)"Group org.apache.hadoop.mapred.Task$Counter is deprecated. Use org.apache.hadoop.mapreduce.TaskCounter instead");
        } else if (groupName.equals("org.apache.hadoop.mapred.JobInProgress$Counter")) {
            groupName = "org.apache.hadoop.mapreduce.JobCounter";
            LOG.warn((Object)"Group org.apache.hadoop.mapred.JobInProgress$Counter is deprecated. Use org.apache.hadoop.mapreduce.JobCounter instead");
        }
        Group result = this.counters.get(groupName);
        if (result == null) {
            result = new Group(groupName);
            this.counters.put(groupName, result);
        }
        return result;
    }

    public synchronized Counter findCounter(Enum key) {
        Counter counter = this.cache.get(key);
        if (counter == null) {
            Group group = this.getGroup(key.getDeclaringClass().getName());
            counter = group.getCounterForName(key.toString());
            this.cache.put(key, counter);
        }
        return counter;
    }

    public synchronized Counter findCounter(String group, String name) {
        if (name.equals("MAP_INPUT_BYTES")) {
            group = "FileInputFormatCounters";
            name = "BYTES_READ";
            LOG.warn((Object)"Counter name MAP_INPUT_BYTES is deprecated. Use FileInputFormatCounters as group name and  BYTES_READ as counter name instead");
        }
        return this.getGroup(group).getCounterForName(name);
    }

    @Deprecated
    public synchronized Counter findCounter(String group, int id, String name) {
        return this.findCounter(group, name);
    }

    public synchronized void incrCounter(Enum key, long amount) {
        this.findCounter(key).increment(amount);
    }

    public synchronized void incrCounter(String group, String counter, long amount) {
        this.findCounter(group, counter).increment(amount);
    }

    public synchronized long getCounter(Enum key) {
        return this.findCounter(key).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            group.displayName = otherGroup.displayName;
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public synchronized int size() {
        int result = 0;
        for (Group group : this) {
            result += group.size();
        }
        return result;
    }

    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (Group group : this.counters.values()) {
            Text.writeString((DataOutput)out, (String)group.getName());
            group.write(out);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        this.counters.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString((DataInput)in);
            Group group = new Group(groupName);
            group.readFields(in);
            this.counters.put(groupName, group);
        }
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        for (Group group : this) {
            log.info((Object)("  " + group.getDisplayName()));
            for (Counter counter : group) {
                log.info((Object)("    " + counter.getDisplayName() + "=" + counter.getCounter()));
            }
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.size());
        for (Group group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
        return sb.toString();
    }

    public synchronized String makeCompactString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(group.getDisplayName());
                buffer.append('.');
                buffer.append(counter.getDisplayName());
                buffer.append(':');
                buffer.append(counter.getCounter());
            }
        }
        return buffer.toString();
    }

    public synchronized String makeEscapedCompactString() {
        String[] groupsArray = new String[this.counters.size()];
        int i = 0;
        int length = 0;
        for (Group group : this) {
            String escapedString = group.makeEscapedCompactString();
            groupsArray[i++] = escapedString;
            length += escapedString.length();
        }
        StringBuilder builder = new StringBuilder(length);
        for (String group : groupsArray) {
            builder.append(group);
        }
        return builder.toString();
    }

    private static String getBlock(String str, char open, char close, IntWritable index) throws ParseException {
        StringBuilder split = new StringBuilder();
        int next = StringUtils.findNext((String)str, (char)open, (char)'\\', (int)index.get(), (StringBuilder)split);
        split.setLength(0);
        if (next >= 0) {
            ++next;
            if ((next = StringUtils.findNext((String)str, (char)close, (char)'\\', (int)next, (StringBuilder)split)) >= 0) {
                index.set(++next);
                return split.toString();
            }
            throw new ParseException("Unexpected end of block", next);
        }
        return null;
    }

    public static Counters fromEscapedCompactString(String compactString) throws ParseException {
        Counters counters = new Counters();
        IntWritable index = new IntWritable(0);
        String groupString = Counters.getBlock(compactString, '{', '}', index);
        while (groupString != null) {
            IntWritable groupIndex = new IntWritable(0);
            String groupName = Counters.getBlock(groupString, '(', ')', groupIndex);
            groupName = Counters.unescape(groupName);
            String groupDisplayName = Counters.getBlock(groupString, '(', ')', groupIndex);
            groupDisplayName = Counters.unescape(groupDisplayName);
            Group group = counters.getGroup(groupName);
            group.setDisplayName(groupDisplayName);
            String counterString = Counters.getBlock(groupString, '[', ']', groupIndex);
            while (counterString != null) {
                IntWritable counterIndex = new IntWritable(0);
                String counterName = Counters.getBlock(counterString, '(', ')', counterIndex);
                counterName = Counters.unescape(counterName);
                String counterDisplayName = Counters.getBlock(counterString, '(', ')', counterIndex);
                counterDisplayName = Counters.unescape(counterDisplayName);
                long value = Long.parseLong(Counters.getBlock(counterString, '(', ')', counterIndex));
                Counter counter = group.getCounterForName(counterName);
                counter.setDisplayName(counterDisplayName);
                counter.increment(value);
                counterString = Counters.getBlock(groupString, '[', ']', groupIndex);
            }
            groupString = Counters.getBlock(compactString, '{', '}', index);
        }
        return counters;
    }

    private static String escape(String string) {
        return StringUtils.escapeString((String)string, (char)'\\', (char[])charsToEscape);
    }

    private static String unescape(String string) {
        return StringUtils.unEscapeString((String)string, (char)'\\', (char[])charsToEscape);
    }

    public synchronized int hashCode() {
        return ((Object)this.counters).hashCode();
    }

    public synchronized boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof Counters) {
            Counters other = (Counters)obj;
            if (this.size() == other.size()) {
                isEqual = true;
                for (Map.Entry<String, Group> entry : this.counters.entrySet()) {
                    Group targetGroup;
                    String key = entry.getKey();
                    Group sourceGroup = entry.getValue();
                    if (sourceGroup.equals(targetGroup = other.getGroup(key))) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    public static class Group
    implements Writable,
    Iterable<Counter> {
        private String groupName;
        private String displayName;
        private Map<String, Counter> subcounters = new HashMap<String, Counter>();
        private ResourceBundle bundle = null;

        Group(String groupName) {
            try {
                this.bundle = Group.getResourceBundle(groupName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.groupName = groupName;
            this.displayName = this.localize("CounterGroupName", groupName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating group " + groupName + " with " + (this.bundle == null ? "nothing" : "bundle")));
            }
        }

        private static ResourceBundle getResourceBundle(String enumClassName) {
            String bundleName = enumClassName.replace('$', '_');
            return ResourceBundle.getBundle(bundleName);
        }

        public String getName() {
            return this.groupName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String makeEscapedCompactString() {
            String[] subcountersArray = new String[this.subcounters.size()];
            String escapedName = Counters.escape(this.getName());
            String escapedDispName = Counters.escape(this.getDisplayName());
            int i = 0;
            int length = escapedName.length() + escapedDispName.length();
            for (Counter counter : this.subcounters.values()) {
                String escapedStr = counter.makeEscapedCompactString();
                subcountersArray[i++] = escapedStr;
                length += escapedStr.length();
            }
            StringBuilder builder = new StringBuilder(length += 6);
            builder.append('{');
            builder.append('(');
            builder.append(escapedName);
            builder.append(')');
            builder.append('(');
            builder.append(escapedDispName);
            builder.append(')');
            for (Counter counter : this.subcounters.values()) {
                builder.append(counter.makeEscapedCompactString());
            }
            builder.append('}');
            return builder.toString();
        }

        public int hashCode() {
            return ((Object)this.subcounters).hashCode();
        }

        public synchronized boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj != null && obj instanceof Group) {
                Group g = (Group)obj;
                if (this.size() == g.size()) {
                    isEqual = true;
                    for (Map.Entry<String, Counter> entry : this.subcounters.entrySet()) {
                        Counter c2;
                        String key = entry.getKey();
                        Counter c1 = entry.getValue();
                        if (c1.contentEquals(c2 = g.getCounterForName(key))) continue;
                        isEqual = false;
                        break;
                    }
                }
            }
            return isEqual;
        }

        public synchronized long getCounter(String counterName) {
            for (Counter counter : this.subcounters.values()) {
                if (counter == null || !counter.getDisplayName().equals(counterName)) continue;
                return counter.getValue();
            }
            return 0L;
        }

        @Deprecated
        public synchronized Counter getCounter(int id, String name) {
            return this.getCounterForName(name);
        }

        public synchronized Counter getCounterForName(String name) {
            Counter result = this.subcounters.get(name);
            if (result == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding " + name));
                }
                result = new Counter(name, this.localize(name + ".name", name), 0L);
                this.subcounters.put(name, result);
            }
            return result;
        }

        public synchronized int size() {
            return this.subcounters.size();
        }

        private String localize(String key, String defaultValue) {
            String result = defaultValue;
            if (this.bundle != null) {
                try {
                    result = this.bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            return result;
        }

        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.displayName);
            WritableUtils.writeVInt((DataOutput)out, (int)this.subcounters.size());
            for (Counter counter : this.subcounters.values()) {
                counter.write(out);
            }
        }

        public synchronized void readFields(DataInput in) throws IOException {
            this.displayName = Text.readString((DataInput)in);
            this.subcounters.clear();
            int size = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < size; ++i) {
                Counter counter = new Counter();
                counter.readFields(in);
                this.subcounters.put(counter.getName(), counter);
            }
        }

        @Override
        public synchronized Iterator<Counter> iterator() {
            return new ArrayList<Counter>(this.subcounters.values()).iterator();
        }
    }

    public static class Counter
    extends org.apache.hadoop.mapreduce.Counter {
        Counter() {
        }

        Counter(String name, String displayName, long value) {
            super(name, displayName);
            this.increment(value);
        }

        @Override
        public void setDisplayName(String newName) {
            super.setDisplayName(newName);
        }

        public synchronized String makeEscapedCompactString() {
            String escapedName = Counters.escape(this.getName());
            String escapedDispName = Counters.escape(this.getDisplayName());
            long currentValue = this.getValue();
            int length = escapedName.length() + escapedDispName.length() + 4;
            StringBuilder builder = new StringBuilder(length += 8);
            builder.append('[');
            builder.append('(');
            builder.append(escapedName);
            builder.append(')');
            builder.append('(');
            builder.append(escapedDispName);
            builder.append(')');
            builder.append('(');
            builder.append(currentValue);
            builder.append(')');
            builder.append(']');
            return builder.toString();
        }

        @Deprecated
        synchronized boolean contentEquals(Counter c) {
            return this.equals(c);
        }

        public synchronized long getCounter() {
            return this.getValue();
        }
    }
}

