/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HddsServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HddsServerUtil.class);

    private HddsServerUtil() {
    }

    public static InetSocketAddress getScmAddressForDataNodes(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address", "ozone.scm.client.address"});
        if (!host.isPresent()) {
            host = Optional.of(HddsUtils.getSingleSCMAddress((Configuration)conf).getHostName());
        }
        int port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address"}).orElse(9861);
        return NetUtils.createSocketAddr((String)(host.get() + ":" + port));
    }

    public static InetSocketAddress getScmClientBindAddress(Configuration conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.client.address"}).orElse(9860);
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmBlockClientBindAddress(Configuration conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.block.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.block.client.address"}).orElse(9863);
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmSecurityInetAddress(Configuration conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.security.service.bind.host"}).orElse("0.0.0.0");
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.security.service.address"});
        return NetUtils.createSocketAddr((String)(host + ":" + port.orElse(conf.getInt("ozone.scm.security.service.port", 9961))));
    }

    public static InetSocketAddress getScmDataNodeBindAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(9861)));
    }

    public static InetSocketAddress getReconDataNodeBindAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.recon.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.recon.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(9891)));
    }

    public static long getScmheartbeatCheckerInterval(Configuration conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.thread.interval", "3s", TimeUnit.MILLISECONDS);
    }

    public static long getScmHeartbeatInterval(Configuration conf) {
        return conf.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public static long getStaleNodeInterval(Configuration conf) {
        long staleNodeIntervalMs = conf.getTimeDuration("ozone.scm.stale.node.interval", "5m", TimeUnit.MILLISECONDS);
        long heartbeatThreadFrequencyMs = HddsServerUtil.getScmheartbeatCheckerInterval(conf);
        long heartbeatIntervalMs = HddsServerUtil.getScmHeartbeatInterval(conf);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs("ozone.scm.stale.node.interval", staleNodeIntervalMs, "ozone.scm.heartbeat.thread.interval", heartbeatThreadFrequencyMs, 5L, 1000L);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs("ozone.scm.stale.node.interval", staleNodeIntervalMs, "hdds.heartbeat.interval", heartbeatIntervalMs, 3L, 1000L);
        return staleNodeIntervalMs;
    }

    public static long getDeadNodeInterval(Configuration conf) {
        long staleNodeIntervalMs = HddsServerUtil.getStaleNodeInterval(conf);
        long deadNodeIntervalMs = conf.getTimeDuration("ozone.scm.dead.node.interval", "10m", TimeUnit.MILLISECONDS);
        return ServerUtils.sanitizeUserArgs("ozone.scm.dead.node.interval", deadNodeIntervalMs, "ozone.scm.stale.node.interval", staleNodeIntervalMs, 2L, 1000L);
    }

    public static long getScmRpcTimeOutInMilliseconds(Configuration conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-timeout", "1s", TimeUnit.MILLISECONDS);
    }

    public static int getLogWarnInterval(Configuration conf) {
        return conf.getInt("ozone.scm.heartbeat.log.warn.interval.count", 10);
    }

    public static int getContainerPort(Configuration conf) {
        return conf.getInt("dfs.container.ipc", 9859);
    }

    public static String getOzoneDatanodeRatisDirectory(Configuration conf) {
        String storageDir = conf.get("dfs.container.ratis.datanode.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = ServerUtils.getDefaultRatisDirectory(conf);
        }
        return storageDir;
    }

    public static String getDatanodeIdFilePath(Configuration conf) {
        String dataNodeIDDirPath = conf.get("ozone.scm.datanode.id.dir");
        if (dataNodeIDDirPath == null) {
            File metaDirPath = ServerUtils.getOzoneMetaDirPath(conf);
            if (metaDirPath == null) {
                throw new IllegalArgumentException("Unable to locate meta datadirectory when getting datanode id path");
            }
            dataNodeIDDirPath = metaDirPath.toString();
        }
        return new File(dataNodeIDDirPath, "datanode.id").toString();
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress address = HddsServerUtil.getScmAddressForSecurityProtocol((Configuration)conf);
        RetryPolicy retryPolicy = RetryPolicies.retryForeverWithFixedSleep((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        return new SCMSecurityProtocolClientSideTranslatorPB((SCMSecurityProtocolPB)RPC.getProtocolProxy(SCMSecurityProtocolPB.class, (long)scmVersion, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf), (RetryPolicy)retryPolicy).getProxy());
    }

    public static InetSocketAddress getScmAddressForSecurityProtocol(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.security.service.address", "ozone.scm.client.address"});
        if (!host.isPresent()) {
            host = Optional.of(HddsUtils.getSingleSCMAddress((Configuration)conf).getHostName());
        }
        int port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.scm.security.service.port"}).orElse(9961);
        return NetUtils.createSocketAddr((String)(host.get() + ":" + port));
    }

    public static SCMSecurityProtocol getScmSecurityClient(OzoneConfiguration conf, UserGroupInformation ugi) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress scmSecurityProtoAdd = HddsServerUtil.getScmAddressForSecurityProtocol((Configuration)conf);
        return new SCMSecurityProtocolClientSideTranslatorPB((SCMSecurityProtocolPB)RPC.getProxy(SCMSecurityProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmSecurityProtoAdd, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
    }

    public static MetricsSystem initializeMetrics(OzoneConfiguration configuration, String serverName) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)serverName);
        try {
            JvmMetrics.create((String)serverName, (String)configuration.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        }
        catch (MetricsException e) {
            LOG.info("Metrics source JvmMetrics already added to DataNode.");
        }
        return metricsSystem;
    }
}

