/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.util.RSUtil;

@InterfaceAudience.Private
public class RSLegacyRawDecoder
extends RawErasureDecoder {
    private int[] errSignature;
    private int[] primitivePower;

    public RSLegacyRawDecoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
        if (this.getNumAllUnits() >= RSUtil.GF.getFieldSize()) {
            throw new HadoopIllegalArgumentException("Invalid numDataUnits and numParityUnits");
        }
        this.errSignature = new int[this.getNumParityUnits()];
        this.primitivePower = RSUtil.getPrimitivePower(this.getNumDataUnits(), this.getNumParityUnits());
    }

    @Override
    public void decode(ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) {
        ByteBuffer[] newInputs = new ByteBuffer[inputs.length];
        int[] newErasedIndexes = new int[erasedIndexes.length];
        ByteBuffer[] newOutputs = new ByteBuffer[outputs.length];
        this.adjustOrder(inputs, newInputs, erasedIndexes, newErasedIndexes, outputs, newOutputs);
        super.decode(newInputs, newErasedIndexes, newOutputs);
    }

    @Override
    public void decode(byte[][] inputs, int[] erasedIndexes, byte[][] outputs) {
        byte[][] newInputs = new byte[inputs.length][];
        int[] newErasedIndexes = new int[erasedIndexes.length];
        byte[][] newOutputs = new byte[outputs.length][];
        this.adjustOrder((T[])inputs, (T[])newInputs, erasedIndexes, newErasedIndexes, (T[])outputs, (T[])newOutputs);
        super.decode(newInputs, newErasedIndexes, newOutputs);
    }

    private void doDecodeImpl(ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) {
        ByteBuffer valid = CoderUtil.findFirstValidInput(inputs);
        int dataLen = valid.remaining();
        for (int i = 0; i < erasedIndexes.length; ++i) {
            this.errSignature[i] = this.primitivePower[erasedIndexes[i]];
            RSUtil.GF.substitute(inputs, dataLen, outputs[i], this.primitivePower[i]);
        }
        RSUtil.GF.solveVandermondeSystem(this.errSignature, outputs, erasedIndexes.length);
    }

    private void doDecodeImpl(byte[][] inputs, int[] inputOffsets, int dataLen, int[] erasedIndexes, byte[][] outputs, int[] outputOffsets) {
        for (int i = 0; i < erasedIndexes.length; ++i) {
            this.errSignature[i] = this.primitivePower[erasedIndexes[i]];
            RSUtil.GF.substitute(inputs, inputOffsets, dataLen, outputs[i], outputOffsets[i], this.primitivePower[i]);
        }
        RSUtil.GF.solveVandermondeSystem(this.errSignature, outputs, outputOffsets, erasedIndexes.length, dataLen);
    }

    @Override
    protected void doDecode(ByteArrayDecodingState decodingState) {
        int i;
        int dataLen = decodingState.decodeLength;
        CoderUtil.resetOutputBuffers(decodingState.outputs, decodingState.outputOffsets, dataLen);
        byte[][] bytesArrayBuffers = new byte[this.getNumParityUnits()][];
        byte[][] adjustedByteArrayOutputsParameter = new byte[this.getNumParityUnits()][];
        int[] adjustedOutputOffsets = new int[this.getNumParityUnits()];
        int[] erasedOrNotToReadIndexes = CoderUtil.getNullIndexes(decodingState.inputs);
        int outputIdx = 0;
        for (i = 0; i < decodingState.erasedIndexes.length; ++i) {
            boolean found = false;
            for (int j = 0; j < erasedOrNotToReadIndexes.length; ++j) {
                if (decodingState.erasedIndexes[i] != erasedOrNotToReadIndexes[j]) continue;
                found = true;
                adjustedByteArrayOutputsParameter[j] = CoderUtil.resetBuffer(decodingState.outputs[outputIdx], decodingState.outputOffsets[outputIdx], dataLen);
                adjustedOutputOffsets[j] = decodingState.outputOffsets[outputIdx];
                ++outputIdx;
            }
            if (found) continue;
            throw new HadoopIllegalArgumentException("Inputs not fully corresponding to erasedIndexes in null places");
        }
        int bufferIdx = 0;
        for (i = 0; i < erasedOrNotToReadIndexes.length; ++i) {
            if (adjustedByteArrayOutputsParameter[i] != null) continue;
            adjustedByteArrayOutputsParameter[i] = CoderUtil.resetBuffer(RSLegacyRawDecoder.checkGetBytesArrayBuffer(bytesArrayBuffers, bufferIdx, dataLen), 0, dataLen);
            adjustedOutputOffsets[i] = 0;
            ++bufferIdx;
        }
        this.doDecodeImpl(decodingState.inputs, decodingState.inputOffsets, dataLen, erasedOrNotToReadIndexes, adjustedByteArrayOutputsParameter, adjustedOutputOffsets);
    }

    @Override
    protected void doDecode(ByteBufferDecodingState decodingState) {
        int i;
        int dataLen = decodingState.decodeLength;
        CoderUtil.resetOutputBuffers(decodingState.outputs, dataLen);
        int[] erasedOrNotToReadIndexes = CoderUtil.getNullIndexes(decodingState.inputs);
        ByteBuffer[] directBuffers = new ByteBuffer[this.getNumParityUnits()];
        ByteBuffer[] adjustedDirectBufferOutputsParameter = new ByteBuffer[this.getNumParityUnits()];
        int outputIdx = 0;
        for (i = 0; i < decodingState.erasedIndexes.length; ++i) {
            boolean found = false;
            for (int j = 0; j < erasedOrNotToReadIndexes.length; ++j) {
                if (decodingState.erasedIndexes[i] != erasedOrNotToReadIndexes[j]) continue;
                found = true;
                adjustedDirectBufferOutputsParameter[j] = CoderUtil.resetBuffer(decodingState.outputs[outputIdx++], dataLen);
            }
            if (found) continue;
            throw new HadoopIllegalArgumentException("Inputs not fully corresponding to erasedIndexes in null places");
        }
        int bufferIdx = 0;
        for (i = 0; i < erasedOrNotToReadIndexes.length; ++i) {
            if (adjustedDirectBufferOutputsParameter[i] != null) continue;
            ByteBuffer buffer = RSLegacyRawDecoder.checkGetDirectBuffer(directBuffers, bufferIdx, dataLen);
            buffer.position(0);
            buffer.limit(dataLen);
            adjustedDirectBufferOutputsParameter[i] = CoderUtil.resetBuffer(buffer, dataLen);
            ++bufferIdx;
        }
        this.doDecodeImpl(decodingState.inputs, erasedOrNotToReadIndexes, adjustedDirectBufferOutputsParameter);
    }

    private <T> void adjustOrder(T[] inputs, T[] inputs2, int[] erasedIndexes, int[] erasedIndexes2, T[] outputs, T[] outputs2) {
        int i;
        System.arraycopy(inputs, this.getNumDataUnits(), inputs2, 0, this.getNumParityUnits());
        System.arraycopy(inputs, 0, inputs2, this.getNumParityUnits(), this.getNumDataUnits());
        int numErasedDataUnits = 0;
        int numErasedParityUnits = 0;
        int idx = 0;
        for (i = 0; i < erasedIndexes.length; ++i) {
            if (erasedIndexes[i] < this.getNumDataUnits()) continue;
            erasedIndexes2[idx++] = erasedIndexes[i] - this.getNumDataUnits();
            ++numErasedParityUnits;
        }
        for (i = 0; i < erasedIndexes.length; ++i) {
            if (erasedIndexes[i] >= this.getNumDataUnits()) continue;
            erasedIndexes2[idx++] = erasedIndexes[i] + this.getNumParityUnits();
            ++numErasedDataUnits;
        }
        System.arraycopy(outputs, numErasedDataUnits, outputs2, 0, numErasedParityUnits);
        System.arraycopy(outputs, 0, outputs2, numErasedParityUnits, numErasedDataUnits);
    }

    private static byte[] checkGetBytesArrayBuffer(byte[][] bytesArrayBuffers, int idx, int bufferLen) {
        if (bytesArrayBuffers[idx] == null || bytesArrayBuffers[idx].length < bufferLen) {
            bytesArrayBuffers[idx] = new byte[bufferLen];
        }
        return bytesArrayBuffers[idx];
    }

    private static ByteBuffer checkGetDirectBuffer(ByteBuffer[] directBuffers, int idx, int bufferLen) {
        if (directBuffers[idx] == null || directBuffers[idx].capacity() < bufferLen) {
            directBuffers[idx] = ByteBuffer.allocateDirect(bufferLen);
        }
        return directBuffers[idx];
    }
}

