/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.util.Quantile;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.internal.matchers.GreaterThan;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class MetricsAsserts {
    static final Log LOG = LogFactory.getLog(MetricsAsserts.class);
    private static final double EPSILON = 1.0E-5;

    public static MetricsSystem mockMetricsSystem() {
        MetricsSystem ms = (MetricsSystem)Mockito.mock(MetricsSystem.class);
        DefaultMetricsSystem.setInstance((MetricsSystem)ms);
        return ms;
    }

    public static MetricsRecordBuilder mockMetricsRecordBuilder() {
        final MetricsCollector mc = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder rb = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                StringBuilder sb = new StringBuilder();
                for (Object o : args) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(o));
                }
                String methodName = invocation.getMethod().getName();
                LOG.debug((Object)(methodName + ": " + sb));
                return methodName.equals("parent") || methodName.equals("endRecord") ? mc : invocation.getMock();
            }
        });
        Mockito.when((Object)mc.addRecord(Mockito.anyString())).thenReturn((Object)rb);
        Mockito.when((Object)mc.addRecord(MetricsAsserts.anyInfo())).thenReturn((Object)rb);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source, boolean all) {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsCollector mc = rb.parent();
        source.getMetrics(mc, all);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(String name) {
        return MetricsAsserts.getMetrics(DefaultMetricsSystem.instance().getSource(name));
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source) {
        return MetricsAsserts.getMetrics(source, true);
    }

    public static MetricsInfo eqName(MetricsInfo info) {
        return (MetricsInfo)Mockito.argThat((Matcher)new InfoWithSameName(info));
    }

    public static MetricsInfo anyInfo() {
        return (MetricsInfo)Mockito.argThat((Matcher)new AnyInfo());
    }

    public static void assertGauge(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntGauge(name, rb));
    }

    public static int getIntGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Integer)captor.capture()).intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Integer)captor.getValue();
    }

    public static void assertCounter(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntCounter(name, rb));
    }

    public static int getIntCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Integer)captor.capture()).intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Integer)captor.getValue();
    }

    public static void assertGauge(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongGauge(name, rb));
    }

    public static long getLongGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Long)captor.capture()).longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Long)captor.getValue();
    }

    public static void assertGauge(String name, double expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getDoubleGauge(name, rb), (double)1.0E-5);
    }

    public static double getDoubleGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Double.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Double)captor.capture()).doubleValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Double)captor.getValue();
    }

    public static void assertCounter(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongCounter(name, rb));
    }

    public static long getLongCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Long)captor.capture()).longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Long)captor.getValue();
    }

    public static String getStringMetric(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).tag(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), (String)captor.capture());
        MetricsAsserts.checkCaptured(captor, name);
        return (String)captor.getValue();
    }

    public static void assertGauge(String name, float expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getFloatGauge(name, rb), (double)1.0E-5);
    }

    public static float getFloatGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Float.class);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.atLeast((int)0))).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Float)captor.capture()).floatValue());
        MetricsAsserts.checkCaptured(captor, name);
        return ((Float)captor.getValue()).floatValue();
    }

    private static void checkCaptured(ArgumentCaptor<?> captor, String name) {
        Assert.assertEquals((String)("Expected exactly one metric for name " + name), (long)1L, (long)captor.getAllValues().size());
    }

    public static void assertGauge(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertGauge(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounterGt(String name, long greater, MetricsRecordBuilder rb) {
        Assert.assertThat((String)("Bad value for metric " + name), (Object)MetricsAsserts.getLongCounter(name, rb), (Matcher)new GreaterThan((Comparable)Long.valueOf(greater)));
    }

    public static void assertCounterGt(String name, long greater, MetricsSource source) {
        MetricsAsserts.assertCounterGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertGaugeGt(String name, double greater, MetricsRecordBuilder rb) {
        Assert.assertThat((String)("Bad value for metric " + name), (Object)MetricsAsserts.getDoubleGauge(name, rb), (Matcher)new GreaterThan((Comparable)Double.valueOf(greater)));
    }

    public static void assertGaugeGt(String name, double greater, MetricsSource source) {
        MetricsAsserts.assertGaugeGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertQuantileGauges(String prefix, MetricsRecordBuilder rb) {
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(MetricsAsserts.eqName(Interns.info((String)(prefix + "NumOps"), (String)"")), AdditionalMatchers.geq((long)0L));
        for (Quantile q : MutableQuantiles.quantiles) {
            String nameTemplate = prefix + "%dthPercentileLatency";
            int percentile = (int)(100.0 * q.quantile);
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(MetricsAsserts.eqName(Interns.info((String)String.format(nameTemplate, percentile), (String)"")), AdditionalMatchers.geq((long)0L));
        }
    }

    private static class AnyInfo
    extends ArgumentMatcher<MetricsInfo> {
        private AnyInfo() {
        }

        public boolean matches(Object info) {
            return info instanceof MetricsInfo;
        }
    }

    private static class InfoWithSameName
    extends ArgumentMatcher<MetricsInfo> {
        private final String expected;

        InfoWithSameName(MetricsInfo info) {
            this.expected = (String)Preconditions.checkNotNull((Object)info.name(), (Object)"info name");
        }

        public boolean matches(Object info) {
            return this.expected.equals(((MetricsInfo)info).name());
        }

        public void describeTo(Description desc) {
            desc.appendText("Info with name=" + this.expected);
        }
    }
}

