/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLdapGroupsMapping
extends TestLdapGroupsMappingBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestLdapGroupsMapping.class);
    private static final byte[] AUTHENTICATE_SUCCESS_MSG = new byte[]{48, 12, 2, 1, 1, 97, 7, 10, 1, 0, 4, 0, 4, 0};

    @Before
    public void setupMocks() throws NamingException {
        SearchResult mockUserResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when(this.mockUserNamingEnum.nextElement()).thenReturn((Object)mockUserResult);
        Mockito.when((Object)mockUserResult.getNameInNamespace()).thenReturn((Object)"CN=some_user,DC=test,DC=com");
    }

    @Test
    public void testGetGroups() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn((Object)this.mockUserNamingEnum, (Object[])new NamingEnumeration[]{this.mockGroupNamingEnum});
        this.doTestGetGroups(Arrays.asList(this.testGroups), 2);
    }

    @Test
    public void testGetGroupsWithConnectionClosed() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")}).thenReturn((Object)this.mockUserNamingEnum, (Object[])new NamingEnumeration[]{this.mockGroupNamingEnum});
        this.doTestGetGroups(Arrays.asList(this.testGroups), 3);
    }

    @Test
    public void testGetGroupsWithLdapDown() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")});
        this.doTestGetGroups(Arrays.asList(new String[0]), 3);
    }

    private void doTestGetGroups(List<String> expectedGroups, int searchTimes) throws IOException, NamingException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        this.mappingSpy.setConf(conf);
        List groups = this.mappingSpy.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.mockContext, (VerificationMode)Mockito.times((int)searchTimes))).search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testExtractPassword() throws IOException {
        File testDir = GenericTestUtils.getTestDir();
        testDir.mkdirs();
        File secretFile = new File(testDir, "secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write("hadoop");
        ((Writer)writer).close();
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"hadoop", (Object)mapping.extractPassword(secretFile.getPath()));
    }

    @Test
    public void testConfGetPassword() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] bindpass = new char[]{'b', 'i', 'n', 'd', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password"));
        try {
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.bind.password", bindpass);
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password", storepass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])bindpass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password").getCredential());
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"bindpass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.bind.password", ""));
        Assert.assertEquals((Object)"storepass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.ssl.keystore.password", ""));
        Assert.assertEquals((Object)"", (Object)mapping.getPassword(conf, "invalid-alias", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLdapConnectionTimeout() throws IOException, InterruptedException {
        int connectionTimeoutMs = 3000;
        try (final ServerSocket serverSock = new ServerSocket(0);){
            final CountDownLatch finLatch = new CountDownLatch(1);
            Thread ldapServer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try (Socket ignored = serverSock.accept();){
                        finLatch.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            ldapServer.start();
            LdapGroupsMapping mapping = new LdapGroupsMapping();
            Configuration conf = new Configuration();
            conf.set("hadoop.security.group.mapping.ldap.url", "ldap://localhost:" + serverSock.getLocalPort());
            conf.setInt("hadoop.security.group.mapping.ldap.connection.timeout.ms", 3000);
            mapping.setConf(conf);
            try {
                mapping.doGetGroups("hadoop");
                Assert.fail((String)"The LDAP query should have timed out!");
            }
            catch (NamingException ne) {
                LOG.debug("Got the exception while LDAP querying: ", (Throwable)ne);
                GenericTestUtils.assertExceptionContains("LDAP response read timed out, timeout used:3000ms", ne);
                Assert.assertFalse((boolean)ne.getMessage().contains("remaining name"));
            }
            finally {
                finLatch.countDown();
            }
            ldapServer.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLdapReadTimeout() throws IOException, InterruptedException {
        int readTimeoutMs = 4000;
        try (final ServerSocket serverSock = new ServerSocket(0);){
            final CountDownLatch finLatch = new CountDownLatch(1);
            Thread ldapServer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try (Socket clientSock = serverSock.accept();){
                        IOUtils.skipFully((InputStream)clientSock.getInputStream(), (long)1L);
                        clientSock.getOutputStream().write(AUTHENTICATE_SUCCESS_MSG);
                        finLatch.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            ldapServer.start();
            LdapGroupsMapping mapping = new LdapGroupsMapping();
            Configuration conf = new Configuration();
            conf.set("hadoop.security.group.mapping.ldap.url", "ldap://localhost:" + serverSock.getLocalPort());
            conf.setInt("hadoop.security.group.mapping.ldap.read.timeout.ms", 4000);
            mapping.setConf(conf);
            try {
                mapping.doGetGroups("hadoop");
                Assert.fail((String)"The LDAP query should have timed out!");
            }
            catch (NamingException ne) {
                LOG.debug("Got the exception while LDAP querying: ", (Throwable)ne);
                GenericTestUtils.assertExceptionContains("LDAP response read timed out, timeout used:4000ms", ne);
                GenericTestUtils.assertExceptionContains("remaining name", ne);
            }
            finally {
                finLatch.countDown();
            }
            ldapServer.join();
        }
    }

    @Test(timeout=10000L)
    public void testSetConf() throws Exception {
        Configuration conf = new Configuration();
        Configuration mockConf = (Configuration)Mockito.spy((Object)conf);
        Mockito.when((Object)mockConf.getPassword(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("injected IOException")});
        mockConf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        this.mappingSpy.setConf(mockConf);
    }
}

