/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCopyPreserveFlag {
    private static final int MODIFICATION_TIME = 12345000;
    private static final int ACCESS_TIME = 23456000;
    private static final Path DIR_FROM = new Path("d0");
    private static final Path DIR_TO1 = new Path("d1");
    private static final Path DIR_TO2 = new Path("d2");
    private static final Path FROM = new Path(DIR_FROM, "f0");
    private static final Path TO = new Path(DIR_TO1, "f1");
    private static final FsPermission PERMISSIONS = new FsPermission(FsAction.ALL, FsAction.EXECUTE, FsAction.READ_WRITE);
    private FileSystem fs;
    private Path testDir;
    private Configuration conf;

    @Before
    public void initialize() throws Exception {
        this.conf = new Configuration(false);
        this.conf.set("fs.file.impl", LocalFileSystem.class.getName());
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new FileSystemTestHelper().getTestRootPath(this.fs);
        this.testDir = new Path(this.fs.makeQualified(this.testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fs.getUri());
        this.fs.setWorkingDirectory(this.testDir);
        this.fs.mkdirs(DIR_FROM);
        this.fs.mkdirs(DIR_TO1);
        this.fs.createNewFile(FROM);
        FSDataOutputStream output = this.fs.create(FROM, true);
        for (int i = 0; i < 100; ++i) {
            output.writeInt(i);
            output.writeChar(10);
        }
        output.close();
        this.fs.setTimes(FROM, 12345000L, 23456000L);
        this.fs.setPermission(FROM, PERMISSIONS);
        this.fs.setTimes(DIR_FROM, 12345000L, 23456000L);
        this.fs.setPermission(DIR_FROM, PERMISSIONS);
    }

    @After
    public void cleanup() throws Exception {
        this.fs.delete(this.testDir, true);
        this.fs.close();
    }

    private void assertAttributesPreserved(Path to) throws IOException {
        FileStatus status = this.fs.getFileStatus(to);
        Assert.assertEquals((long)12345000L, (long)status.getModificationTime());
        Assert.assertEquals((long)23456000L, (long)status.getAccessTime());
        Assert.assertEquals((Object)PERMISSIONS, (Object)status.getPermission());
    }

    private void assertAttributesChanged(Path to) throws IOException {
        FileStatus status = this.fs.getFileStatus(to);
        Assert.assertNotEquals((long)12345000L, (long)status.getModificationTime());
        Assert.assertNotEquals((long)23456000L, (long)status.getAccessTime());
        Assert.assertNotEquals((Object)PERMISSIONS, (Object)status.getPermission());
    }

    private void run(CommandWithDestination cmd, String ... args) {
        cmd.setConf(this.conf);
        Assert.assertEquals((long)0L, (long)cmd.run(args));
    }

    @Test(timeout=10000L)
    public void testPutWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test(timeout=10000L)
    public void testPutWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test(timeout=10000L)
    public void testGetWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test(timeout=10000L)
    public void testGetWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test(timeout=10000L)
    public void testCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test(timeout=10000L)
    public void testCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test(timeout=10000L)
    public void testDirectoryCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", DIR_FROM.toString(), DIR_TO2.toString());
        this.assertAttributesPreserved(DIR_TO2);
    }

    @Test(timeout=10000L)
    public void testDirectoryCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), DIR_FROM.toString(), DIR_TO2.toString());
        this.assertAttributesChanged(DIR_TO2);
    }
}

