/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.ConfigRedactor;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigRedactor {
    private static final String REDACTED_TEXT = "<redacted>";
    private static final String ORIGINAL_VALUE = "Hello, World!";

    @Test
    public void redact() throws Exception {
        String processedText;
        Configuration conf = new Configuration();
        ConfigRedactor redactor = new ConfigRedactor(conf);
        List<String> sensitiveKeys = Arrays.asList("fs.s3a.secret.key", "fs.s3n.awsSecretKey", "fs.azure.account.key.abcdefg.blob.core.windows.net", "dfs.webhdfs.oauth2.access.token", "dfs.webhdfs.oauth2.refresh.token", "ssl.server.keystore.keypassword", "ssl.server.keystore.password", "httpfs.ssl.keystore.pass", "hadoop.security.sensitive-config-keys");
        for (String key : sensitiveKeys) {
            processedText = redactor.redact(key, ORIGINAL_VALUE);
            Assert.assertEquals((String)("Config parameter wasn't redacted and should be: " + key), (Object)REDACTED_TEXT, (Object)processedText);
        }
        List<String> normalKeys = Arrays.asList("fs.defaultFS", "dfs.replication", "ssl.server.keystore.location", "httpfs.config.dir", "hadoop.security.credstore.java-keystore-provider.password-file");
        for (String key : normalKeys) {
            processedText = redactor.redact(key, ORIGINAL_VALUE);
            Assert.assertEquals((String)("Config parameter was redacted and shouldn't be: " + key), (Object)ORIGINAL_VALUE, (Object)processedText);
        }
    }
}

