/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ShellBasedIdMapping;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestShellBasedIdMapping {
    private static final Map<Integer, Integer> EMPTY_PASS_THROUGH_MAP = new ShellBasedIdMapping.PassThroughMap();

    @Test
    public void testStaticMapParsing() throws IOException {
        File tempStaticMapFile = File.createTempFile("nfs-", ".map");
        String staticMapFileContents = "uid 10 100\ngid 10 200\nuid 11 201 # comment at the end of a line\nuid 12 301\n# Comment at the beginning of a line\n    # Comment that starts late in the line\nuid 10000 10001# line without whitespace before comment\nuid 13 302\ngid\t11\t201\n\ngid 12 202";
        FileOutputStream out = new FileOutputStream(tempStaticMapFile);
        ((OutputStream)out).write("uid 10 100\ngid 10 200\nuid 11 201 # comment at the end of a line\nuid 12 301\n# Comment at the beginning of a line\n    # Comment that starts late in the line\nuid 10000 10001# line without whitespace before comment\nuid 13 302\ngid\t11\t201\n\ngid 12 202".getBytes());
        ((OutputStream)out).close();
        ShellBasedIdMapping.StaticMapping parsedMap = ShellBasedIdMapping.parseStaticMap((File)tempStaticMapFile);
        Assert.assertEquals((long)10L, (long)((Integer)parsedMap.uidMapping.get(100)).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)parsedMap.uidMapping.get(201)).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)parsedMap.uidMapping.get(301)).intValue());
        Assert.assertEquals((long)13L, (long)((Integer)parsedMap.uidMapping.get(302)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)parsedMap.gidMapping.get(200)).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)parsedMap.gidMapping.get(201)).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)parsedMap.gidMapping.get(202)).intValue());
        Assert.assertEquals((long)10000L, (long)((Integer)parsedMap.uidMapping.get(10001)).intValue());
        Assert.assertEquals((long)1000L, (long)((Integer)parsedMap.uidMapping.get(1000)).intValue());
    }

    @Test
    public void testStaticMapping() throws IOException {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        ShellBasedIdMapping.PassThroughMap uidStaticMap = new ShellBasedIdMapping.PassThroughMap();
        ShellBasedIdMapping.PassThroughMap gidStaticMap = new ShellBasedIdMapping.PassThroughMap();
        uidStaticMap.put(11501, 10);
        gidStaticMap.put(497, 200);
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        String GET_ALL_USERS_CMD = "echo \"atm:x:1000:1000:Aaron T. Myers,,,:/home/atm:/bin/bash\nhdfs:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\" | cut -d: -f1,3";
        String GET_ALL_GROUPS_CMD = "echo \"hdfs:*:11501:hrt_hdfs\nmapred:x:497\nmapred2:x:498\" | cut -d: -f1,3";
        ShellBasedIdMapping.updateMapInternal((BiMap)uMap, (String)"user", (String)GET_ALL_USERS_CMD, (String)":", (Map)uidStaticMap);
        ShellBasedIdMapping.updateMapInternal((BiMap)gMap, (String)"group", (String)GET_ALL_GROUPS_CMD, (String)":", (Map)gidStaticMap);
        Assert.assertEquals((Object)"hdfs", (Object)uMap.get((Object)10));
        Assert.assertEquals((long)10L, (long)((Integer)uMap.inverse().get((Object)"hdfs")).intValue());
        Assert.assertEquals((Object)"atm", (Object)uMap.get((Object)1000));
        Assert.assertEquals((long)1000L, (long)((Integer)uMap.inverse().get((Object)"atm")).intValue());
        Assert.assertEquals((Object)"hdfs", (Object)gMap.get((Object)11501));
        Assert.assertEquals((long)11501L, (long)((Integer)gMap.inverse().get((Object)"hdfs")).intValue());
        Assert.assertEquals((Object)"mapred", (Object)gMap.get((Object)200));
        Assert.assertEquals((long)200L, (long)((Integer)gMap.inverse().get((Object)"mapred")).intValue());
        Assert.assertEquals((Object)"mapred2", (Object)gMap.get((Object)498));
        Assert.assertEquals((long)498L, (long)((Integer)gMap.inverse().get((Object)"mapred2")).intValue());
    }

    @Test
    public void testDuplicates() throws IOException {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        String GET_ALL_USERS_CMD = "echo \"root:x:0:0:root:/root:/bin/bash\nhdfs:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs:x:11502:10788:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs1:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs2:x:11502:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nbin:x:2:2:bin:/bin:/bin/sh\nbin:x:1:1:bin:/bin:/sbin/nologin\ndaemon:x:1:1:daemon:/usr/sbin:/bin/sh\ndaemon:x:2:2:daemon:/sbin:/sbin/nologin\" | cut -d: -f1,3";
        String GET_ALL_GROUPS_CMD = "echo \"hdfs:*:11501:hrt_hdfs\nmapred:x:497\nmapred2:x:497\nmapred:x:498\nmapred3:x:498\" | cut -d: -f1,3";
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        ShellBasedIdMapping.updateMapInternal((BiMap)uMap, (String)"user", (String)GET_ALL_USERS_CMD, (String)":", EMPTY_PASS_THROUGH_MAP);
        Assert.assertEquals((long)5L, (long)uMap.size());
        Assert.assertEquals((Object)"root", (Object)uMap.get((Object)0));
        Assert.assertEquals((Object)"hdfs", (Object)uMap.get((Object)11501));
        Assert.assertEquals((Object)"hdfs2", (Object)uMap.get((Object)11502));
        Assert.assertEquals((Object)"bin", (Object)uMap.get((Object)2));
        Assert.assertEquals((Object)"daemon", (Object)uMap.get((Object)1));
        ShellBasedIdMapping.updateMapInternal((BiMap)gMap, (String)"group", (String)GET_ALL_GROUPS_CMD, (String)":", EMPTY_PASS_THROUGH_MAP);
        Assert.assertTrue((gMap.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"hdfs", (Object)gMap.get((Object)11501));
        Assert.assertEquals((Object)"mapred", (Object)gMap.get((Object)497));
        Assert.assertEquals((Object)"mapred3", (Object)gMap.get((Object)498));
    }

    @Test
    public void testIdOutOfIntegerRange() throws IOException {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        String GET_ALL_USERS_CMD = "echo \"nfsnobody:x:4294967294:4294967294:Anonymous NFS User:/var/lib/nfs:/sbin/nologin\nnfsnobody1:x:4294967295:4294967295:Anonymous NFS User:/var/lib/nfs1:/sbin/nologin\nmaxint:x:2147483647:2147483647:Grid Distributed File System:/home/maxint:/bin/bash\nminint:x:2147483648:2147483648:Grid Distributed File System:/home/minint:/bin/bash\narchivebackup:*:1031:4294967294:Archive Backup:/home/users/archivebackup:/bin/sh\nhdfs:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\ndaemon:x:2:2:daemon:/sbin:/sbin/nologin\" | cut -d: -f1,3";
        String GET_ALL_GROUPS_CMD = "echo \"hdfs:*:11501:hrt_hdfs\nrpcuser:*:29:\nnfsnobody:*:4294967294:\nnfsnobody1:*:4294967295:\nmaxint:*:2147483647:\nminint:*:2147483648:\nmapred3:x:498\" | cut -d: -f1,3";
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        ShellBasedIdMapping.updateMapInternal((BiMap)uMap, (String)"user", (String)GET_ALL_USERS_CMD, (String)":", EMPTY_PASS_THROUGH_MAP);
        Assert.assertTrue((uMap.size() == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nfsnobody", (Object)uMap.get((Object)-2));
        Assert.assertEquals((Object)"nfsnobody1", (Object)uMap.get((Object)-1));
        Assert.assertEquals((Object)"maxint", (Object)uMap.get((Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)"minint", (Object)uMap.get((Object)Integer.MIN_VALUE));
        Assert.assertEquals((Object)"archivebackup", (Object)uMap.get((Object)1031));
        Assert.assertEquals((Object)"hdfs", (Object)uMap.get((Object)11501));
        Assert.assertEquals((Object)"daemon", (Object)uMap.get((Object)2));
        ShellBasedIdMapping.updateMapInternal((BiMap)gMap, (String)"group", (String)GET_ALL_GROUPS_CMD, (String)":", EMPTY_PASS_THROUGH_MAP);
        Assert.assertTrue((gMap.size() == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"hdfs", (Object)gMap.get((Object)11501));
        Assert.assertEquals((Object)"rpcuser", (Object)gMap.get((Object)29));
        Assert.assertEquals((Object)"nfsnobody", (Object)gMap.get((Object)-2));
        Assert.assertEquals((Object)"nfsnobody1", (Object)gMap.get((Object)-1));
        Assert.assertEquals((Object)"maxint", (Object)gMap.get((Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)"minint", (Object)gMap.get((Object)Integer.MIN_VALUE));
        Assert.assertEquals((Object)"mapred3", (Object)gMap.get((Object)498));
    }

    @Test
    public void testUserUpdateSetting() throws IOException {
        ShellBasedIdMapping iug = new ShellBasedIdMapping(new Configuration());
        Assert.assertEquals((long)iug.getTimeout(), (long)900000L);
        Configuration conf = new Configuration();
        conf.setLong("usergroupid.update.millis", 0L);
        iug = new ShellBasedIdMapping(conf);
        Assert.assertEquals((long)iug.getTimeout(), (long)60000L);
        conf.setLong("usergroupid.update.millis", 1800000L);
        iug = new ShellBasedIdMapping(conf);
        Assert.assertEquals((long)iug.getTimeout(), (long)1800000L);
    }
}

