/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIOUtils {
    private static final String TEST_FILE_NAME = "test_file";

    @Test
    public void testCopyBytesShouldCloseStreamsWhenCloseIsTrue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldCloseInputSteamWhenOutputStreamCloseThrowsException() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)outputStream)).close();
        try {
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldNotCloseStreamsWhenCloseIsFalse() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)false);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atMost((int)0))).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atMost((int)0))).close();
    }

    @Test
    public void testCopyBytesWithCountShouldCloseStreamsWhenCloseIsTrue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)true);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesWithCountShouldNotCloseStreamsWhenCloseIsFalse() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)false);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atMost((int)0))).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atMost((int)0))).close();
    }

    @Test
    public void testCopyBytesWithCountShouldThrowOutTheStreamClosureExceptions() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[4096], 0, 1);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException("Exception in closing the stream")).when((Object)outputStream)).close();
        try {
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (long)1L, (boolean)true);
            Assert.fail((String)"Should throw out the exception");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Not throwing the expected exception.", (Object)"Exception in closing the stream", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFully() throws IOException {
        int INPUT_BUFFER_LEN = 10000;
        int HALFWAY = 5001;
        byte[] input = new byte[10000];
        for (int i = 0; i < input.length; ++i) {
            input[i] = (byte)(i & 0xFF);
        }
        byte[] output = new byte[input.length];
        try {
            int i;
            RandomAccessFile raf = new RandomAccessFile(TEST_FILE_NAME, "rw");
            FileChannel fc = raf.getChannel();
            ByteBuffer buf = ByteBuffer.wrap(input);
            IOUtils.writeFully((WritableByteChannel)fc, (ByteBuffer)buf);
            raf.seek(0L);
            raf.read(output);
            for (i = 0; i < input.length; ++i) {
                Assert.assertEquals((long)input[i], (long)output[i]);
            }
            buf.rewind();
            IOUtils.writeFully((FileChannel)fc, (ByteBuffer)buf, (long)5001L);
            for (i = 0; i < 5001; ++i) {
                Assert.assertEquals((long)input[i], (long)output[i]);
            }
            raf.seek(0L);
            raf.read(output);
            for (i = 5001; i < input.length; ++i) {
                Assert.assertEquals((long)input[i - 5001], (long)output[i]);
            }
        }
        finally {
            File f = new File(TEST_FILE_NAME);
            if (f.exists()) {
                f.delete();
            }
        }
    }

    @Test
    public void testWrappedReadForCompressedData() throws IOException {
        byte[] buf = new byte[2];
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)mockStream.read(buf, 0, 1)).thenReturn((Object)1);
        Mockito.when((Object)mockStream.read(buf, 0, 2)).thenThrow(new Throwable[]{new InternalError()});
        try {
            Assert.assertEquals((String)"Check expected value", (long)1L, (long)IOUtils.wrappedReadForCompressedData((InputStream)mockStream, (byte[])buf, (int)0, (int)1));
        }
        catch (IOException ioe) {
            Assert.fail((String)"Unexpected error while reading");
        }
        try {
            IOUtils.wrappedReadForCompressedData((InputStream)mockStream, (byte[])buf, (int)0, (int)2);
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains("Error while reading compressed data", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipFully() throws IOException {
        byte[] inArray = new byte[]{0, 1, 2, 3, 4};
        ByteArrayInputStream in = new ByteArrayInputStream(inArray);
        try {
            in.mark(inArray.length);
            IOUtils.skipFully((InputStream)in, (long)2L);
            IOUtils.skipFully((InputStream)in, (long)2L);
            try {
                IOUtils.skipFully((InputStream)in, (long)2L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)"Premature EOF from inputStream after skipping 1 byte(s).", (Object)e.getMessage());
            }
            in.reset();
            try {
                IOUtils.skipFully((InputStream)in, (long)20L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)"Premature EOF from inputStream after skipping 5 byte(s).", (Object)e.getMessage());
            }
            in.reset();
            IOUtils.skipFully((InputStream)in, (long)5L);
            try {
                IOUtils.skipFully((InputStream)in, (long)10L);
                Assert.fail((String)"expected to get a PrematureEOFException");
            }
            catch (EOFException e) {
                Assert.assertEquals((Object)"Premature EOF from inputStream after skipping 0 byte(s).", (Object)e.getMessage());
            }
        }
        finally {
            in.close();
        }
    }
}

