/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.net.URI;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestKeyProviderCryptoExtension {
    private static final String CIPHER = "AES";
    private static final String ENCRYPTION_KEY_NAME = "fooKey";
    private static Configuration conf;
    private static KeyProvider kp;
    private static KeyProviderCryptoExtension kpExt;
    private static KeyProvider.Options options;
    private static KeyProvider.KeyVersion encryptionKey;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        kpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
        options = new KeyProvider.Options(conf);
        options.setCipher(CIPHER);
        options.setBitLength(128);
        encryptionKey = kp.createKey(ENCRYPTION_KEY_NAME, SecureRandom.getSeed(16), options);
    }

    @Test
    public void testGenerateEncryptedKey() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(encryptionKey.getName());
        Assert.assertEquals((String)"Version name of EEK should be EEK", (Object)"EEK", (Object)ek1.getEncryptedKeyVersion().getVersionName());
        Assert.assertEquals((String)"Name of EEK should be encryption key name", (Object)ENCRYPTION_KEY_NAME, (Object)ek1.getEncryptionKeyName());
        Assert.assertNotNull((String)"Expected encrypted key material", (Object)ek1.getEncryptedKeyVersion().getMaterial());
        Assert.assertEquals((String)"Length of encryption key material and EEK material should be the same", (long)encryptionKey.getMaterial().length, (long)ek1.getEncryptedKeyVersion().getMaterial().length);
        KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
        Assert.assertEquals((Object)"EK", (Object)k1.getVersionName());
        Assert.assertEquals((long)encryptionKey.getMaterial().length, (long)k1.getMaterial().length);
        if (Arrays.equals(k1.getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal encryption key material");
        }
        if (Arrays.equals(ek1.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal decrypted key material");
        }
        KeyProvider.KeyVersion k1a = kpExt.decryptEncryptedKey(ek1);
        Assert.assertArrayEquals((byte[])k1.getMaterial(), (byte[])k1a.getMaterial());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.generateEncryptedKey(encryptionKey.getName());
        KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
        if (Arrays.equals(k1.getMaterial(), k2.getMaterial())) {
            Assert.fail((String)"Generated EEKs should have different material!");
        }
        if (Arrays.equals(ek1.getEncryptedKeyIv(), ek2.getEncryptedKeyIv())) {
            Assert.fail((String)"Generated EEKs should have different IVs!");
        }
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion eek = kpExt.generateEncryptedKey(encryptionKey.getName());
        byte[] encryptedKeyIv = eek.getEncryptedKeyIv();
        byte[] encryptedKeyMaterial = eek.getEncryptedKeyVersion().getMaterial();
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(encryptionKey.getMaterial(), CIPHER), new IvParameterSpec(KeyProviderCryptoExtension.EncryptedKeyVersion.deriveIV((byte[])encryptedKeyIv)));
        byte[] manualMaterial = cipher.doFinal(encryptedKeyMaterial);
        KeyProviderCryptoExtension.EncryptedKeyVersion eek2 = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)eek.getEncryptionKeyName(), (String)eek.getEncryptionKeyVersionName(), (byte[])eek.getEncryptedKeyIv(), (byte[])eek.getEncryptedKeyVersion().getMaterial());
        KeyProvider.KeyVersion decryptedKey = kpExt.decryptEncryptedKey(eek2);
        byte[] apiMaterial = decryptedKey.getMaterial();
        Assert.assertArrayEquals((String)"Wrong key material from decryptEncryptedKey", (byte[])manualMaterial, (byte[])apiMaterial);
    }
}

