/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class TestAccessControlList {
    private static final Logger LOG = LoggerFactory.getLogger(TestAccessControlList.class);

    @Test
    public void testNetgroups() throws Exception {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            LOG.info("Not testing netgroups, this test only runs when native code is compiled");
            return;
        }
        String groupMappingClassName = System.getProperty("TestAccessControlListGroupMapping");
        if (groupMappingClassName == null) {
            LOG.info("Not testing netgroups, no group mapping class specified, use -DTestAccessControlListGroupMapping=$className to specify group mapping class (must implement GroupMappingServiceProvider interface and support netgroups)");
            return;
        }
        LOG.info("Testing netgroups using: " + groupMappingClassName);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", groupMappingClassName);
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)conf);
        AccessControlList acl = new AccessControlList("ja my");
        acl = new AccessControlList("sinatra ratpack,@lasVegas");
        acl = new AccessControlList(" somegroup,@someNetgroup");
        acl = new AccessControlList("carlPerkins ratpack,@lasVegas");
        acl.addGroup("@memphis");
        this.validateNetgroups(groups, acl);
        groups.refresh();
        this.validateNetgroups(groups, acl);
    }

    private void validateNetgroups(Groups groups, AccessControlList acl) throws Exception {
        List elvisGroups = groups.getGroups("elvis");
        Assert.assertTrue((boolean)elvisGroups.contains("@lasVegas"));
        Assert.assertTrue((boolean)elvisGroups.contains("@memphis"));
        List jerryLeeLewisGroups = groups.getGroups("jerryLeeLewis");
        Assert.assertTrue((boolean)jerryLeeLewisGroups.contains("@memphis"));
        UserGroupInformation elvis = UserGroupInformation.createRemoteUser((String)"elvis");
        this.assertUserAllowed(elvis, acl);
        UserGroupInformation carlPerkins = UserGroupInformation.createRemoteUser((String)"carlPerkins");
        this.assertUserAllowed(carlPerkins, acl);
        UserGroupInformation littleRichard = UserGroupInformation.createRemoteUser((String)"littleRichard");
        this.assertUserNotAllowed(littleRichard, acl);
    }

    @Test
    public void testWildCardAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("*");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("  * ");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList(" *");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("*  ");
        Assert.assertTrue((boolean)acl.isAllAllowed());
    }

    @Test
    public void testAclString() {
        AccessControlList acl = new AccessControlList("*");
        Assert.assertEquals((Object)"All users are allowed", (Object)acl.toString());
        this.validateGetAclString(acl);
        acl = new AccessControlList(" ");
        Assert.assertEquals((Object)"No users are allowed", (Object)acl.toString());
        acl = new AccessControlList("user1,user2");
        Assert.assertEquals((Object)"Users [user1, user2] are allowed", (Object)acl.toString());
        this.validateGetAclString(acl);
        acl = new AccessControlList("user1,user2 ");
        Assert.assertEquals((Object)"Users [user1, user2] are allowed", (Object)acl.toString());
        this.validateGetAclString(acl);
        acl = new AccessControlList(" group1,group2");
        Assert.assertTrue((boolean)acl.toString().equals("Members of the groups [group1, group2] are allowed"));
        this.validateGetAclString(acl);
        acl = new AccessControlList("user1,user2 group1,group2");
        Assert.assertTrue((boolean)acl.toString().equals("Users [user1, user2] and members of the groups [group1, group2] are allowed"));
        this.validateGetAclString(acl);
    }

    private void validateGetAclString(AccessControlList acl) {
        Assert.assertTrue((boolean)acl.toString().equals(new AccessControlList(acl.getAclString()).toString()));
    }

    @Test
    public void testAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("drwho tardis");
        Collection users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)1L);
        Assert.assertEquals(users.iterator().next(), (Object)"drwho");
        Collection groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)1L);
        Assert.assertEquals(groups.iterator().next(), (Object)"tardis");
        acl = new AccessControlList("drwho");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)1L);
        Assert.assertEquals(users.iterator().next(), (Object)"drwho");
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)0L);
        acl = new AccessControlList("drwho ");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)1L);
        Assert.assertEquals(users.iterator().next(), (Object)"drwho");
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)0L);
        acl = new AccessControlList(" tardis");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)0L);
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)1L);
        Assert.assertEquals(groups.iterator().next(), (Object)"tardis");
        acl = new AccessControlList("drwho,joe tardis, users");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)2L);
        Iterator iter = users.iterator();
        Assert.assertEquals(iter.next(), (Object)"drwho");
        Assert.assertEquals(iter.next(), (Object)"joe");
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)2L);
        iter = groups.iterator();
        Assert.assertEquals(iter.next(), (Object)"tardis");
        Assert.assertEquals(iter.next(), (Object)"users");
    }

    @Test
    public void testAddRemoveAPI() {
        AccessControlList acl = new AccessControlList(" ");
        Assert.assertEquals((long)0L, (long)acl.getUsers().size());
        Assert.assertEquals((long)0L, (long)acl.getGroups().size());
        Assert.assertEquals((Object)" ", (Object)acl.getAclString());
        acl.addUser("drwho");
        Collection users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)1L);
        Assert.assertEquals(users.iterator().next(), (Object)"drwho");
        Assert.assertEquals((Object)"drwho ", (Object)acl.getAclString());
        acl.addGroup("tardis");
        Collection groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)1L);
        Assert.assertEquals(groups.iterator().next(), (Object)"tardis");
        Assert.assertEquals((Object)"drwho tardis", (Object)acl.getAclString());
        acl.addUser("joe");
        acl.addGroup("users");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)2L);
        Iterator iter = users.iterator();
        Assert.assertEquals(iter.next(), (Object)"drwho");
        Assert.assertEquals(iter.next(), (Object)"joe");
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)2L);
        iter = groups.iterator();
        Assert.assertEquals(iter.next(), (Object)"tardis");
        Assert.assertEquals(iter.next(), (Object)"users");
        Assert.assertEquals((Object)"drwho,joe tardis,users", (Object)acl.getAclString());
        acl.removeUser("joe");
        acl.removeGroup("users");
        users = acl.getUsers();
        Assert.assertEquals((long)users.size(), (long)1L);
        Assert.assertFalse((boolean)users.contains("joe"));
        groups = acl.getGroups();
        Assert.assertEquals((long)groups.size(), (long)1L);
        Assert.assertFalse((boolean)groups.contains("users"));
        Assert.assertEquals((Object)"drwho tardis", (Object)acl.getAclString());
        acl.removeGroup("tardis");
        groups = acl.getGroups();
        Assert.assertEquals((long)0L, (long)groups.size());
        Assert.assertFalse((boolean)groups.contains("tardis"));
        Assert.assertEquals((Object)"drwho ", (Object)acl.getAclString());
        acl.removeUser("drwho");
        Assert.assertEquals((long)0L, (long)users.size());
        Assert.assertFalse((boolean)users.contains("drwho"));
        Assert.assertEquals((long)0L, (long)acl.getGroups().size());
        Assert.assertEquals((long)0L, (long)acl.getUsers().size());
        Assert.assertEquals((Object)" ", (Object)acl.getAclString());
    }

    @Test
    public void testAddRemoveWildCard() {
        AccessControlList acl = new AccessControlList("drwho tardis");
        Throwable th = null;
        try {
            acl.addUser(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.addGroup(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.removeUser(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.removeGroup(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((boolean)(th instanceof IllegalArgumentException));
    }

    @Test
    public void testAddRemoveToWildCardACL() {
        AccessControlList acl = new AccessControlList(" * ");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@APACHE.ORG", (String[])new String[]{"aliens"});
        UserGroupInformation drwho2 = UserGroupInformation.createUserForTesting((String)"drwho2@APACHE.ORG", (String[])new String[]{"tardis"});
        acl.addUser("drwho");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        Assert.assertFalse((boolean)acl.getAclString().contains("drwho"));
        acl.addGroup("tardis");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        Assert.assertFalse((boolean)acl.getAclString().contains("tardis"));
        acl.removeUser("drwho");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        this.assertUserAllowed(drwho, acl);
        acl.removeGroup("tardis");
        Assert.assertTrue((boolean)acl.isAllAllowed());
        this.assertUserAllowed(drwho2, acl);
    }

    @Test
    public void testIsUserAllowed() {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation susan = UserGroupInformation.createUserForTesting((String)"susan@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation barbara = UserGroupInformation.createUserForTesting((String)"barbara@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        UserGroupInformation ian = UserGroupInformation.createUserForTesting((String)"ian@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        AccessControlList acl = new AccessControlList("drwho humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho ");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList(" humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho,ian aliens,teachers");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserAllowed(barbara, acl);
        this.assertUserAllowed(ian, acl);
        acl = new AccessControlList("");
        UserGroupInformation spyUser = (UserGroupInformation)Mockito.spy((Object)drwho);
        acl.isUserAllowed(spyUser);
        ((UserGroupInformation)Mockito.verify((Object)spyUser, (VerificationMode)Mockito.never())).getGroupNames();
    }

    private void assertUserAllowed(UserGroupInformation ugi, AccessControlList acl) {
        Assert.assertTrue((String)("User " + ugi + " is not granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }

    private void assertUserNotAllowed(UserGroupInformation ugi, AccessControlList acl) {
        Assert.assertFalse((String)("User " + ugi + " is incorrectly granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }
}

