/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandler;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.MissingArgumentException;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.YarnWebServiceUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SchedConfCLI
extends Configured
implements Tool {
    private static final String ADD_QUEUES_OPTION = "addQueues";
    private static final String REMOVE_QUEUES_OPTION = "removeQueues";
    private static final String UPDATE_QUEUES_OPTION = "updateQueues";
    private static final String GLOBAL_OPTIONS = "globalUpdates";
    private static final String FORMAT_CONF = "formatConfig";
    private static final String HELP_CMD = "help";
    private static final String CONF_ERR_MSG = "Specify configuration key value as confKey=confVal.";

    public SchedConfCLI() {
        super(new YarnConfiguration());
    }

    public static void main(String[] args) throws Exception {
        SchedConfCLI cli = new SchedConfCLI();
        int exitCode = cli.run(args);
        System.exit(exitCode);
    }

    @Override
    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("add", ADD_QUEUES_OPTION, true, "Add queues with configurations");
        opts.addOption("remove", REMOVE_QUEUES_OPTION, true, "Remove queues");
        opts.addOption("update", UPDATE_QUEUES_OPTION, true, "Update queue configurations");
        opts.addOption("global", GLOBAL_OPTIONS, true, "Update global scheduler configurations");
        opts.addOption("format", FORMAT_CONF, false, "Format Scheduler Configuration and reload from capacity-scheduler.xml");
        opts.addOption("h", HELP_CMD, false, "Displays help for all commands.");
        int exitCode = -1;
        CommandLine parsedCli = null;
        try {
            parsedCli = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.err.println("Missing argument for options");
            this.printUsage();
            return exitCode;
        }
        if (parsedCli.hasOption(HELP_CMD)) {
            this.printUsage();
            return 0;
        }
        boolean hasOption = false;
        boolean format = false;
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        try {
            if (parsedCli.hasOption(ADD_QUEUES_OPTION)) {
                hasOption = true;
                this.addQueues(parsedCli.getOptionValue(ADD_QUEUES_OPTION), updateInfo);
            }
            if (parsedCli.hasOption(REMOVE_QUEUES_OPTION)) {
                hasOption = true;
                this.removeQueues(parsedCli.getOptionValue(REMOVE_QUEUES_OPTION), updateInfo);
            }
            if (parsedCli.hasOption(UPDATE_QUEUES_OPTION)) {
                hasOption = true;
                this.updateQueues(parsedCli.getOptionValue(UPDATE_QUEUES_OPTION), updateInfo);
            }
            if (parsedCli.hasOption(GLOBAL_OPTIONS)) {
                hasOption = true;
                this.globalUpdates(parsedCli.getOptionValue(GLOBAL_OPTIONS), updateInfo);
            }
            if (parsedCli.hasOption(FORMAT_CONF)) {
                hasOption = true;
                format = true;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        if (!hasOption) {
            System.err.println("Invalid Command Usage: ");
            this.printUsage();
            return -1;
        }
        Configuration conf = this.getConf();
        if (format) {
            return WebAppUtils.execOnActiveRM(conf, this::formatSchedulerConf, null);
        }
        return WebAppUtils.execOnActiveRM(conf, this::updateSchedulerConfOnRMNode, updateInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int formatSchedulerConf(String webAppAddress, WebResource resource) throws Exception {
        Configuration conf = this.getConf();
        SSLFactory clientSslFactory = null;
        if (YarnConfiguration.useHttps(conf)) {
            clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        }
        Client webServiceClient = this.createWebServiceClient(clientSslFactory);
        ClientResponse response = null;
        resource = resource != null ? resource : webServiceClient.resource(webAppAddress);
        try {
            WebResource.Builder builder = null;
            builder = UserGroupInformation.isSecurityEnabled() ? resource.path("ws").path("v1").path("cluster").path("/scheduler-conf/format").accept(new String[]{"application/xml", "application/json"}) : resource.path("ws").path("v1").path("cluster").path("/scheduler-conf/format").queryParam("user.name", UserGroupInformation.getCurrentUser().getShortUserName()).accept(new String[]{"application/xml", "application/json"});
            response = (ClientResponse)builder.get(ClientResponse.class);
            if (response != null) {
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    System.out.println((String)response.getEntity(String.class));
                    int n = 0;
                    return n;
                }
                System.err.println("Failed to format scheduler configuration: " + (String)response.getEntity(String.class));
            } else {
                System.err.println("Failed to format scheduler configuration: null response");
            }
            int n = -1;
            return n;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (webServiceClient != null) {
                webServiceClient.destroy();
            }
            if (clientSslFactory != null) {
                clientSslFactory.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int updateSchedulerConfOnRMNode(String webAppAddress, SchedConfUpdateInfo updateInfo) throws Exception {
        Configuration conf = this.getConf();
        SSLFactory clientSslFactory = null;
        if (YarnConfiguration.useHttps(conf)) {
            clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        }
        Client webServiceClient = this.createWebServiceClient(clientSslFactory);
        ClientResponse response = null;
        WebResource resource = webServiceClient.resource(webAppAddress);
        try {
            WebResource.Builder builder = null;
            builder = UserGroupInformation.isSecurityEnabled() ? resource.path("ws").path("v1").path("cluster").path("scheduler-conf").accept(new String[]{"application/json"}) : resource.path("ws").path("v1").path("cluster").queryParam("user.name", UserGroupInformation.getCurrentUser().getShortUserName()).path("scheduler-conf").accept(new String[]{"application/json"});
            builder.entity((Object)YarnWebServiceUtils.toJson(updateInfo, SchedConfUpdateInfo.class), "application/json");
            response = (ClientResponse)builder.put(ClientResponse.class);
            if (response != null) {
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    System.out.println("Configuration changed successfully.");
                    int n = 0;
                    return n;
                }
                System.err.println("Configuration change unsuccessful: " + (String)response.getEntity(String.class));
            } else {
                System.err.println("Configuration change unsuccessful: null response");
            }
            int n = -1;
            return n;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (webServiceClient != null) {
                webServiceClient.destroy();
            }
            if (clientSslFactory != null) {
                clientSslFactory.destroy();
            }
        }
    }

    private Client createWebServiceClient(final SSLFactory clientSslFactory) {
        Client webServiceClient = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                HttpURLConnection conn = null;
                try {
                    AuthenticatedURL aUrl;
                    if (clientSslFactory != null) {
                        clientSslFactory.init();
                        aUrl = new AuthenticatedURL(null, clientSslFactory);
                    } else {
                        aUrl = new AuthenticatedURL();
                    }
                    conn = aUrl.openConnection(url, token);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                return conn;
            }
        }));
        webServiceClient.setChunkedEncodingSize(null);
        return webServiceClient;
    }

    @VisibleForTesting
    void addQueues(String args, SchedConfUpdateInfo updateInfo) {
        if (args == null) {
            return;
        }
        ArrayList<QueueConfigInfo> queueConfigInfos = new ArrayList<QueueConfigInfo>();
        for (String arg : args.split(";")) {
            queueConfigInfos.add(this.getQueueConfigInfo(arg));
        }
        updateInfo.setAddQueueInfo(queueConfigInfos);
    }

    @VisibleForTesting
    void removeQueues(String args, SchedConfUpdateInfo updateInfo) {
        if (args == null) {
            return;
        }
        List<String> queuesToRemove = Arrays.asList(args.split(";"));
        updateInfo.setRemoveQueueInfo(new ArrayList<String>(queuesToRemove));
    }

    @VisibleForTesting
    void updateQueues(String args, SchedConfUpdateInfo updateInfo) {
        if (args == null) {
            return;
        }
        ArrayList<QueueConfigInfo> queueConfigInfos = new ArrayList<QueueConfigInfo>();
        for (String arg : args.split(";")) {
            queueConfigInfos.add(this.getQueueConfigInfo(arg));
        }
        updateInfo.setUpdateQueueInfo(queueConfigInfos);
    }

    @VisibleForTesting
    void globalUpdates(String args, SchedConfUpdateInfo updateInfo) {
        if (args == null) {
            return;
        }
        HashMap<String, String> globalUpdates = new HashMap<String, String>();
        for (String globalUpdate : args.split(",")) {
            this.putKeyValuePair(globalUpdates, globalUpdate);
        }
        updateInfo.setGlobalParams(globalUpdates);
    }

    private QueueConfigInfo getQueueConfigInfo(String arg) {
        String[] args = arg.split(":");
        String queuePath = args[0];
        HashMap<String, String> queueConfigs = new HashMap<String, String>();
        if (args.length > 1) {
            String[] queueArgs = args[1].split(",");
            for (int i = 0; i < queueArgs.length; ++i) {
                this.putKeyValuePair(queueConfigs, queueArgs[i]);
            }
        }
        return new QueueConfigInfo(queuePath, queueConfigs);
    }

    private void putKeyValuePair(Map<String, String> kv, String args) {
        String[] argParts = args.split("=");
        if (argParts.length == 1) {
            if (argParts[0].isEmpty() || !args.contains("=")) {
                throw new IllegalArgumentException(CONF_ERR_MSG);
            }
            kv.put(argParts[0], null);
        } else {
            if (argParts.length > 2) {
                throw new IllegalArgumentException(CONF_ERR_MSG);
            }
            if (argParts[0].isEmpty()) {
                throw new IllegalArgumentException(CONF_ERR_MSG);
            }
            kv.put(argParts[0], argParts[1]);
        }
    }

    private void printUsage() {
        System.out.println("yarn schedulerconf [-add \"queueAddPath1:confKey1=confVal1,confKey2=confVal2;queueAddPath2:confKey3=confVal3\"] [-remove \"queueRemovePath1;queueRemovePath2\"] [-update \"queueUpdatePath1:confKey1=confVal1\"] [-global globalConfKey1=globalConfVal1,globalConfKey2=globalConfVal2] [-format]\nExample (adding queues): yarn schedulerconf -add \"root.a.a1:capacity=100,maximum-capacity=100;root.a.a2:capacity=0,maximum-capacity=0\"\nExample (removing queues): yarn schedulerconf -remove \"root.a.a1;root.a.a2\"\nExample (updating queues): yarn schedulerconf -update \"root.a.a1:capacity=25,maximum-capacity=25;root.a.a2:capacity=75,maximum-capacity=75\"\nExample (global scheduler update): yarn schedulerconf -global yarn.scheduler.capacity.maximum-applications=10000\nExample (format scheduler configuration): yarn schedulerconf -format\nNote: This is an alpha feature, the syntax/options are subject to change, please run at your own risk.");
    }
}

