/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUpstreamException;
import org.apache.guacamole.GuacamoleUpstreamNotFoundException;
import org.apache.guacamole.GuacamoleUpstreamTimeoutException;
import org.apache.guacamole.GuacamoleUpstreamUnavailableException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverGuacamoleSocket
implements GuacamoleSocket {
    private static final Logger logger = LoggerFactory.getLogger(FailoverGuacamoleSocket.class);
    private static final int DEFAULT_INSTRUCTION_QUEUE_LIMIT = 131072;
    private final GuacamoleSocket socket;
    private final Queue<GuacamoleInstruction> instructionQueue = new LinkedList<GuacamoleInstruction>();
    private final GuacamoleReader queuedReader = new GuacamoleReader(){

        @Override
        public boolean available() throws GuacamoleException {
            return !FailoverGuacamoleSocket.this.instructionQueue.isEmpty() || FailoverGuacamoleSocket.this.socket.getReader().available();
        }

        @Override
        public char[] read() throws GuacamoleException {
            if (!FailoverGuacamoleSocket.this.instructionQueue.isEmpty()) {
                GuacamoleInstruction instruction = (GuacamoleInstruction)FailoverGuacamoleSocket.this.instructionQueue.remove();
                return instruction.toString().toCharArray();
            }
            return FailoverGuacamoleSocket.this.socket.getReader().read();
        }

        @Override
        public GuacamoleInstruction readInstruction() throws GuacamoleException {
            if (!FailoverGuacamoleSocket.this.instructionQueue.isEmpty()) {
                return (GuacamoleInstruction)FailoverGuacamoleSocket.this.instructionQueue.remove();
            }
            return FailoverGuacamoleSocket.this.socket.getReader().readInstruction();
        }
    };

    private static void handleUpstreamErrors(GuacamoleInstruction instruction) throws GuacamoleUpstreamException {
        int statusCode;
        List<String> args = instruction.getArgs();
        if (args.size() < 2) {
            logger.debug("Received \"error\" instruction without status code.");
            return;
        }
        try {
            statusCode = Integer.parseInt(args.get(1));
        }
        catch (NumberFormatException e) {
            logger.debug("Received \"error\" instruction with non-numeric status code.", (Throwable)e);
            return;
        }
        GuacamoleStatus status = GuacamoleStatus.fromGuacamoleStatusCode(statusCode);
        if (status == null) {
            logger.debug("Received \"error\" instruction with unknown/invalid status code: {}", (Object)statusCode);
            return;
        }
        switch (status) {
            case UPSTREAM_ERROR: {
                throw new GuacamoleUpstreamException(args.get(0));
            }
            case UPSTREAM_NOT_FOUND: {
                throw new GuacamoleUpstreamNotFoundException(args.get(0));
            }
            case UPSTREAM_TIMEOUT: {
                throw new GuacamoleUpstreamTimeoutException(args.get(0));
            }
            case UPSTREAM_UNAVAILABLE: {
                throw new GuacamoleUpstreamUnavailableException(args.get(0));
            }
        }
    }

    public FailoverGuacamoleSocket(GuacamoleSocket socket, int instructionQueueLimit) throws GuacamoleException, GuacamoleUpstreamException {
        GuacamoleInstruction instruction;
        int totalQueueSize = 0;
        GuacamoleReader reader = socket.getReader();
        while ((instruction = reader.readInstruction()) != null) {
            this.instructionQueue.add(instruction);
            String opcode = instruction.getOpcode();
            if (opcode.equals("sync")) break;
            if (opcode.equals("error")) {
                FailoverGuacamoleSocket.handleUpstreamErrors(instruction);
                break;
            }
            if ((totalQueueSize += instruction.toString().length()) < instructionQueueLimit) continue;
            break;
        }
        this.socket = socket;
    }

    public FailoverGuacamoleSocket(GuacamoleSocket socket) throws GuacamoleException, GuacamoleUpstreamException {
        this(socket, 131072);
    }

    @Override
    public GuacamoleReader getReader() {
        return this.queuedReader;
    }

    @Override
    public GuacamoleWriter getWriter() {
        return this.socket.getWriter();
    }

    @Override
    public void close() throws GuacamoleException {
        this.socket.close();
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }
}

