/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import java.util.List;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleProtocolCapability;
import org.apache.guacamole.protocol.GuacamoleProtocolVersion;

public class ConfiguredGuacamoleSocket
implements GuacamoleSocket {
    private GuacamoleSocket socket;
    private GuacamoleConfiguration config;
    private String id;
    private GuacamoleProtocolVersion protocolVersion = GuacamoleProtocolVersion.VERSION_1_0_0;

    private GuacamoleInstruction expect(GuacamoleReader reader, String opcode) throws GuacamoleException {
        GuacamoleInstruction instruction = reader.readInstruction();
        if (instruction == null) {
            throw new GuacamoleServerException("End of stream while waiting for \"" + opcode + "\".");
        }
        if (!instruction.getOpcode().equals(opcode)) {
            throw new GuacamoleServerException("Expected \"" + opcode + "\" instruction but instead received \"" + instruction.getOpcode() + "\".");
        }
        return instruction;
    }

    public ConfiguredGuacamoleSocket(GuacamoleSocket socket, GuacamoleConfiguration config) throws GuacamoleException {
        this(socket, config, new GuacamoleClientInformation());
    }

    public ConfiguredGuacamoleSocket(GuacamoleSocket socket, GuacamoleConfiguration config, GuacamoleClientInformation info) throws GuacamoleException {
        String timezone;
        this.socket = socket;
        this.config = config;
        GuacamoleReader reader = socket.getReader();
        GuacamoleWriter writer = socket.getWriter();
        String select_arg = config.getConnectionID();
        if (select_arg == null) {
            select_arg = config.getProtocol();
        }
        writer.writeInstruction(new GuacamoleInstruction("select", select_arg));
        GuacamoleInstruction args = this.expect(reader, "args");
        List<String> arg_names = args.getArgs();
        String[] arg_values = new String[arg_names.size()];
        for (int i = 0; i < arg_names.size(); ++i) {
            GuacamoleProtocolVersion version;
            String arg_name = arg_names.get(i);
            if (i == 0 && (version = GuacamoleProtocolVersion.parseVersion(arg_name)) != null) {
                if (version.atLeast(GuacamoleProtocolVersion.LATEST)) {
                    version = GuacamoleProtocolVersion.LATEST;
                }
                arg_values[i] = version.toString();
                this.protocolVersion = version;
                continue;
            }
            String value = config.getParameter(arg_name);
            arg_values[i] = value != null ? value : "";
        }
        writer.writeInstruction(new GuacamoleInstruction("size", Integer.toString(info.getOptimalScreenWidth()), Integer.toString(info.getOptimalScreenHeight()), Integer.toString(info.getOptimalResolution())));
        writer.writeInstruction(new GuacamoleInstruction("audio", info.getAudioMimetypes().toArray(new String[0])));
        writer.writeInstruction(new GuacamoleInstruction("video", info.getVideoMimetypes().toArray(new String[0])));
        writer.writeInstruction(new GuacamoleInstruction("image", info.getImageMimetypes().toArray(new String[0])));
        if (GuacamoleProtocolCapability.TIMEZONE_HANDSHAKE.isSupported(this.protocolVersion) && (timezone = info.getTimezone()) != null) {
            writer.writeInstruction(new GuacamoleInstruction("timezone", info.getTimezone()));
        }
        writer.writeInstruction(new GuacamoleInstruction("connect", arg_values));
        GuacamoleInstruction ready = this.expect(reader, "ready");
        List<String> ready_args = ready.getArgs();
        if (ready_args.isEmpty()) {
            throw new GuacamoleServerException("No connection ID received");
        }
        this.id = ready.getArgs().get(0);
    }

    public GuacamoleConfiguration getConfiguration() {
        return this.config;
    }

    public String getConnectionID() {
        return this.id;
    }

    public GuacamoleProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public GuacamoleWriter getWriter() {
        return this.socket.getWriter();
    }

    @Override
    public GuacamoleReader getReader() {
        return this.socket.getReader();
    }

    @Override
    public void close() throws GuacamoleException {
        this.socket.close();
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }
}

