/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.gsp;

import grails.core.GrailsApplication;
import grails.core.GrailsDomainClass;
import grails.util.CacheEntry;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import grails.util.GrailsStringUtils;
import groovy.text.Template;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grails.buffer.CodecPrintWriter;
import org.grails.buffer.FastStringWriter;
import org.grails.encoder.EncodedAppenderWriterFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.StreamingEncoderWriter;
import org.grails.gsp.GroovyPageBinding;
import org.grails.gsp.GroovyPageMetaInfo;
import org.grails.gsp.GroovyPagesTemplateEngine;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.taglib.GrailsTagException;
import org.grails.taglib.TemplateVariableBinding;
import org.grails.taglib.encoder.WithCodecHelper;
import org.grails.web.gsp.io.GrailsConventionGroovyPageLocator;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GroovyPagesTemplateRenderer
implements InitializingBean {
    private GrailsConventionGroovyPageLocator groovyPageLocator;
    private GroovyPagesTemplateEngine groovyPagesTemplateEngine;
    private ConcurrentMap<String, CacheEntry<Template>> templateCache = new ConcurrentHashMap<String, CacheEntry<Template>>();
    private Object scaffoldingTemplateGenerator;
    private Map<String, Collection<String>> scaffoldedActionMap;
    private Map<String, GrailsDomainClass> controllerToScaffoldedDomainClassMap;
    private Method generateViewMethod;
    private boolean reloadEnabled;
    private boolean cacheEnabled = !Environment.isDevelopmentMode();

    public void afterPropertiesSet() throws Exception {
        if (this.scaffoldingTemplateGenerator != null) {
            this.generateViewMethod = ReflectionUtils.findMethod(this.scaffoldingTemplateGenerator.getClass(), (String)"generateView", (Class[])new Class[]{GrailsDomainClass.class, String.class, Writer.class});
        }
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    public void render(GrailsWebRequest webRequest, TemplateVariableBinding pageScope, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        Assert.state((this.groovyPagesTemplateEngine != null ? 1 : 0) != 0, (String)"Property [groovyPagesTemplateEngine] must be set!");
        String templateName = this.getStringValue(attrs, "template");
        if (GrailsStringUtils.isBlank((String)templateName)) {
            throw new GrailsTagException("Tag [render] is missing required attribute [template]");
        }
        String uri = webRequest.getAttributes().getTemplateUri((CharSequence)templateName, (ServletRequest)webRequest.getRequest());
        String contextPath = this.getStringValue(attrs, "contextPath");
        String pluginName = this.getStringValue(attrs, "plugin");
        Object controller = webRequest.getAttribute("org.grails.CONTROLLER", 0);
        Template t = this.findAndCacheTemplate(controller, pageScope, templateName, contextPath, pluginName, uri);
        if (t == null) {
            if (this.getBooleanValue(attrs, "optional")) {
                return;
            }
            throw new GrailsTagException("Template not found for name [" + templateName + "] and path [" + uri + "]");
        }
        this.makeTemplate(webRequest, t, attrs, body, out);
    }

    private Template findAndCacheTemplate(Object controller, GrailsWebRequest webRequest, GroovyPageBinding pageScope, String templateName, String contextPath, String pluginName, String uri) throws IOException {
        return this.findAndCacheTemplate(controller, (TemplateVariableBinding)pageScope, templateName, contextPath, pluginName, uri);
    }

    private Template findAndCacheTemplate(Object controller, TemplateVariableBinding pageScope, String templateName, String contextPath, String pluginName, final String uri) throws IOException {
        String templatePath = GrailsStringUtils.isNotEmpty((String)contextPath) ? GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, templateName}) : templateName;
        final GroovyPageScriptSource scriptSource = pluginName == null ? this.groovyPageLocator.findTemplateInBinding(controller, templatePath, pageScope) : this.groovyPageLocator.findTemplateInBinding(controller, pluginName, templatePath, pageScope);
        Object cacheKey = scriptSource == null ? contextPath + pluginName + uri : (pluginName != null ? contextPath + pluginName + scriptSource.getURI() : scriptSource.getURI());
        return (Template)CacheEntry.getValue(this.templateCache, (Object)cacheKey, (long)(this.reloadEnabled ? GroovyPageMetaInfo.LASTMODIFIED_CHECK_INTERVAL : -1L), null, (Callable)new Callable<CacheEntry<Template>>(){

            @Override
            public CacheEntry<Template> call() {
                return new CacheEntry<Template>(){
                    boolean allowCaching;
                    boolean neverExpire;
                    {
                        this.allowCaching = GroovyPagesTemplateRenderer.this.cacheEnabled;
                        this.neverExpire = false;
                    }

                    protected boolean hasExpired(long timeout, Object cacheRequestObject) {
                        return this.neverExpire ? false : (this.allowCaching ? super.hasExpired(timeout, cacheRequestObject) : true);
                    }

                    public boolean isInitialized() {
                        return this.allowCaching ? super.isInitialized() : false;
                    }

                    public void setValue(Template val) {
                        if (this.allowCaching) {
                            super.setValue((Object)val);
                        }
                    }

                    protected Template updateValue(Template oldValue, Callable<Template> updater, Object cacheRequestObject) throws Exception {
                        Template t = null;
                        if (scriptSource != null) {
                            t = GroovyPagesTemplateRenderer.this.groovyPagesTemplateEngine.createTemplate((ScriptSource)scriptSource);
                        }
                        if (t == null && GroovyPagesTemplateRenderer.this.scaffoldingTemplateGenerator != null) {
                            t = GroovyPagesTemplateRenderer.this.generateScaffoldedTemplate(GrailsWebRequest.lookup(), uri);
                            this.allowCaching = true;
                            this.neverExpire = true;
                        }
                        return t;
                    }
                };
            }
        }, (boolean)true, null);
    }

    private void makeTemplate(GrailsWebRequest webRequest, Template t, Map<String, Object> attrs, Object body, Writer out) throws IOException {
        Writer newOut = this.wrapWriterWithEncoder(webRequest, attrs, out);
        boolean writerWrapped = newOut != out;
        out = newOut;
        String var = this.getStringValue(attrs, "var");
        LinkedHashMap<String, Object> b = new LinkedHashMap<String, Object>();
        b.put("body", body);
        if (attrs.get("model") instanceof Map) {
            b.putAll((Map)attrs.get("model"));
        }
        if (attrs.containsKey("bean")) {
            if (GrailsStringUtils.isNotBlank((String)var)) {
                b.put(var, attrs.get("bean"));
            } else {
                b.put("it", attrs.get("bean"));
            }
        }
        if (attrs.containsKey("collection")) {
            String key = null;
            Iterator iterator = InvokerHelper.asIterator((Object)attrs.get("collection"));
            while (iterator.hasNext()) {
                Object it = iterator.next();
                if (key == null && GrailsStringUtils.isBlank((String)var) && it != null) {
                    key = GrailsNameUtils.getPropertyName(it.getClass());
                }
                LinkedHashMap<String, Object> itmap = new LinkedHashMap<String, Object>();
                itmap.putAll(b);
                if (GrailsStringUtils.isNotBlank((String)var)) {
                    itmap.put(var, it);
                } else {
                    itmap.put("it", it);
                    itmap.put(key, it);
                }
                t.make(itmap).writeTo(out);
            }
        } else {
            t.make(b).writeTo(out);
        }
        if (writerWrapped) {
            out.flush();
        }
    }

    private Writer wrapWriterWithEncoder(GrailsWebRequest webRequest, Map<String, Object> attrs, Writer out) {
        Map codecSettings;
        String codecForTaglibs;
        Object encodeAs = attrs.get("encodeAs");
        if (encodeAs != null && (codecForTaglibs = (String)(codecSettings = WithCodecHelper.makeSettingsCanonical((Object)encodeAs)).get("taglib")) != null) {
            Encoder encoder = WithCodecHelper.lookupEncoder((GrailsApplication)webRequest.getAttributes().getGrailsApplication(), (String)codecForTaglibs);
            out = out instanceof EncodedAppenderWriterFactory ? ((EncodedAppenderWriterFactory)out).getWriterForEncoder(encoder, webRequest.getEncodingStateRegistry()) : (encoder instanceof StreamingEncoder ? new StreamingEncoderWriter((Writer)out, (StreamingEncoder)encoder, webRequest.getEncodingStateRegistry()) : new CodecPrintWriter((Writer)out, encoder, webRequest.getEncodingStateRegistry()));
        }
        return out;
    }

    private Template generateScaffoldedTemplate(GrailsWebRequest webRequest, String uri) throws IOException {
        GrailsDomainClass domainClass;
        Template t = null;
        Collection<String> controllerActions = this.scaffoldedActionMap.get(webRequest.getControllerName());
        if (controllerActions != null && controllerActions.contains(webRequest.getActionName()) && (domainClass = this.controllerToScaffoldedDomainClassMap.get(webRequest.getControllerName())) != null) {
            String scaffoldedtemplateName;
            int i = uri.lastIndexOf(47);
            String string = scaffoldedtemplateName = i > -1 ? uri.substring(i) : uri;
            if (scaffoldedtemplateName.toLowerCase().endsWith(".gsp")) {
                scaffoldedtemplateName = scaffoldedtemplateName.substring(0, scaffoldedtemplateName.length() - 4);
            }
            FastStringWriter sw = new FastStringWriter();
            ReflectionUtils.invokeMethod((Method)this.generateViewMethod, (Object)this.scaffoldingTemplateGenerator, (Object[])new Object[]{domainClass, scaffoldedtemplateName, sw});
            t = this.groovyPagesTemplateEngine.createTemplate((Resource)new ByteArrayResource(sw.toString().getBytes(StandardCharsets.UTF_8), uri), false);
        }
        return t;
    }

    private String getStringValue(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return String.valueOf(val);
    }

    private boolean getBooleanValue(Map<String, Object> attrs, String key) {
        String val = this.getStringValue(attrs, key);
        if (val.isBlank()) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator locator) {
        this.groovyPageLocator = locator;
    }

    public void setGroovyPagesTemplateEngine(GroovyPagesTemplateEngine engine) {
        this.groovyPagesTemplateEngine = engine;
    }

    public void setScaffoldingTemplateGenerator(Object generator) {
        this.scaffoldingTemplateGenerator = generator;
    }

    public void setScaffoldedActionMap(Map map) {
        this.scaffoldedActionMap = map;
    }

    public void setControllerToScaffoldedDomainClassMap(Map map) {
        this.controllerToScaffoldedDomainClassMap = map;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

