/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.sitemesh3;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.grails.web.gsp.io.GrailsConventionGroovyPageLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.mvc.ParameterizableViewController;

public class GrailsLayoutHandlerMapping
extends AbstractHandlerMapping {
    @Autowired
    GrailsConventionGroovyPageLocator groovyPageLocator;
    Map<String, ParameterizableViewController> layoutCache = new HashMap<String, ParameterizableViewController>();

    public GrailsLayoutHandlerMapping() {
        this.setOrder(-6);
    }

    protected Object getHandlerInternal(HttpServletRequest request) {
        if (request.getAttribute("jakarta.servlet.forward.request_uri") == null) {
            return null;
        }
        String servletPath = request.getServletPath();
        if (servletPath.startsWith("/layouts")) {
            ParameterizableViewController pvc = this.layoutCache.get(servletPath);
            if (pvc == null) {
                if (this.groovyPageLocator.findViewByPath(servletPath) == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Unable to find resource " + servletPath);
                }
                pvc = new ParameterizableViewController();
                pvc.setSupportedMethods(new String[]{HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name()});
                pvc.setViewName(servletPath);
                this.layoutCache.put(servletPath, pvc);
            }
            return pvc;
        }
        return null;
    }
}

