/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.options;

import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.grails.cli.command.options.CompilerOptionHandler;
import org.grails.cli.compiler.GroovyCompilerConfiguration;
import org.grails.cli.compiler.GroovyCompilerScope;
import org.grails.cli.compiler.RepositoryConfigurationFactory;
import org.grails.cli.compiler.grape.RepositoryConfiguration;

public class OptionSetGroovyCompilerConfiguration
implements GroovyCompilerConfiguration {
    private final OptionSet options;
    private final CompilerOptionHandler optionHandler;
    private final List<RepositoryConfiguration> repositoryConfiguration;

    protected OptionSetGroovyCompilerConfiguration(OptionSet optionSet, CompilerOptionHandler compilerOptionHandler) {
        this(optionSet, compilerOptionHandler, RepositoryConfigurationFactory.createDefaultRepositoryConfiguration());
    }

    public OptionSetGroovyCompilerConfiguration(OptionSet optionSet, CompilerOptionHandler compilerOptionHandler, List<RepositoryConfiguration> repositoryConfiguration) {
        this.options = optionSet;
        this.optionHandler = compilerOptionHandler;
        this.repositoryConfiguration = repositoryConfiguration;
    }

    protected OptionSet getOptions() {
        return this.options;
    }

    @Override
    public GroovyCompilerScope getScope() {
        return GroovyCompilerScope.DEFAULT;
    }

    @Override
    public boolean isGuessImports() {
        return !this.options.has(this.optionHandler.getNoGuessImportsOption());
    }

    @Override
    public boolean isGuessDependencies() {
        return !this.options.has(this.optionHandler.getNoGuessDependenciesOption());
    }

    @Override
    public boolean isAutoconfigure() {
        return (Boolean)this.optionHandler.getAutoconfigureOption().value(this.options);
    }

    @Override
    public String[] getClasspath() {
        OptionSpec<String> classpathOption = this.optionHandler.getClasspathOption();
        if (this.options.has(classpathOption)) {
            return ((String)this.options.valueOf(classpathOption)).split(":");
        }
        return DEFAULT_CLASSPATH;
    }

    @Override
    public List<RepositoryConfiguration> getRepositoryConfiguration() {
        return this.repositoryConfiguration;
    }

    @Override
    public boolean isQuiet() {
        return false;
    }
}

