/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.lang.reflect.Method;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeanUtils;

public class SimpleEnumMarshaller
implements ObjectMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return object.getClass().isEnum();
    }

    @Override
    public void marshalObject(Object en, JSON json) throws ConverterException {
        try {
            Method nameMethod = BeanUtils.findDeclaredMethod(en.getClass(), (String)"name", (Class[])new Class[0]);
            try {
                json.convertAnother(nameMethod.invoke(en, new Object[0]));
            }
            catch (Exception e) {
                json.convertAnother("");
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Enum with class " + en.getClass().getName(), e);
        }
    }
}

