/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.configuration;

import grails.config.Config;
import grails.converters.JSON;
import grails.converters.XML;
import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.core.support.proxy.DefaultProxyHandler;
import grails.core.support.proxy.ProxyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.config.PropertySourcesConfig;
import org.grails.web.converters.Converter;
import org.grails.web.converters.configuration.ChainedConverterConfiguration;
import org.grails.web.converters.configuration.ConverterConfiguration;
import org.grails.web.converters.configuration.ConvertersConfigurationHolder;
import org.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.grails.web.converters.configuration.ObjectMarshallerRegisterer;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.converters.marshaller.ProxyUnwrappingMarshaller;
import org.grails.web.converters.marshaller.json.ArrayMarshaller;
import org.grails.web.converters.marshaller.json.ByteArrayMarshaller;
import org.grails.web.converters.marshaller.json.CalendarMarshaller;
import org.grails.web.converters.marshaller.json.CollectionMarshaller;
import org.grails.web.converters.marshaller.json.DateMarshaller;
import org.grails.web.converters.marshaller.json.DeepDomainClassMarshaller;
import org.grails.web.converters.marshaller.json.DomainClassMarshaller;
import org.grails.web.converters.marshaller.json.EnumMarshaller;
import org.grails.web.converters.marshaller.json.GroovyBeanMarshaller;
import org.grails.web.converters.marshaller.json.InstantMarshaller;
import org.grails.web.converters.marshaller.json.JavascriptDateMarshaller;
import org.grails.web.converters.marshaller.json.LocalDateMarshaller;
import org.grails.web.converters.marshaller.json.LocalDateTimeMarshaller;
import org.grails.web.converters.marshaller.json.OffsetDateTimeMarshaller;
import org.grails.web.converters.marshaller.json.SimpleEnumMarshaller;
import org.grails.web.converters.marshaller.json.ToStringBeanMarshaller;
import org.grails.web.converters.marshaller.json.ZonedDateTimeMarshaller;
import org.grails.web.converters.marshaller.xml.Base64ByteArrayMarshaller;
import org.grails.web.converters.marshaller.xml.GenericJavaBeanMarshaller;
import org.grails.web.converters.marshaller.xml.MapMarshaller;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConvertersConfigurationInitializer
implements ApplicationContextAware,
GrailsApplicationAware,
InitializingBean {
    public static final String SETTING_CONVERTERS_JSON_DATE = "grails.converters.json.date";
    public static final String SETTING_CONVERTERS_JSON_DEFAULT_DEEP = "grails.converters.json.default.deep";
    public static final String SETTING_CONVERTERS_ENCODING = "grails.converters.encoding";
    public static final String SETTING_CONVERTERS_CIRCULAR_REFERENCE_BEHAVIOUR = "grails.converters.default.circular.reference.behaviour";
    public static final String SETTING_CONVERTERS_JSON_CIRCULAR_REFERENCE_BEHAVIOUR = "grails.converters.json.circular.reference.behaviour";
    public static final String SETTING_CONVERTERS_PRETTY_PRINT = "grails.converters.default.pretty.print";
    public static final String SETTING_CONVERTERS_JSON_PRETTY_PRINT = "grails.converters.json.pretty.print";
    public static final String SETTING_CONVERTERS_JSON_CACHE_OBJECTS = "grails.converters.json.cacheObjectMarshallerSelectionByClass";
    public static final String SETTING_CONVERTERS_XML_DEEP = "grails.converters.xml.default.deep";
    private ApplicationContext applicationContext;
    private GrailsApplication grailsApplication;
    public final Log LOG = LogFactory.getLog(ConvertersConfigurationInitializer.class);

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"Initializing Converters Default Configurations...");
        }
        this.initJSONConfiguration();
        this.initXMLConfiguration();
        this.initDeepJSONConfiguration();
        this.initDeepXMLConfiguration();
    }

    private void initJSONConfiguration() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"Initializing default JSON Converters Configuration...");
        }
        ArrayList marshallers = new ArrayList();
        marshallers.addAll(this.getPreviouslyConfiguredMarshallers(JSON.class));
        marshallers.add(new ArrayMarshaller());
        marshallers.add(new ByteArrayMarshaller());
        marshallers.add(new CollectionMarshaller());
        marshallers.add(new org.grails.web.converters.marshaller.json.MapMarshaller());
        Config grailsConfig = this.getGrailsConfig();
        String jsonEnumFormat = (String)grailsConfig.getProperty("grails.converters.json.enum.format", String.class, (Object)"default");
        if ("simple".equals(jsonEnumFormat)) {
            marshallers.add(new SimpleEnumMarshaller());
        } else {
            marshallers.add(new EnumMarshaller());
        }
        marshallers.add(new ProxyUnwrappingMarshaller());
        if ("javascript".equals(grailsConfig.getProperty(SETTING_CONVERTERS_JSON_DATE, String.class, (Object)"default", Arrays.asList("javascript", "default")))) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Using Javascript JSON Date Marshaller.");
            }
            marshallers.add(new JavascriptDateMarshaller());
        } else {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Using default JSON Date Marshaller");
            }
            marshallers.add(new DateMarshaller());
        }
        marshallers.add(new CalendarMarshaller());
        marshallers.add(new InstantMarshaller());
        marshallers.add(new LocalDateMarshaller());
        marshallers.add(new LocalDateTimeMarshaller());
        marshallers.add(new OffsetDateTimeMarshaller());
        marshallers.add(new ZonedDateTimeMarshaller());
        marshallers.add(new ToStringBeanMarshaller());
        boolean includeDomainVersion = this.includeDomainVersionProperty(grailsConfig, "json");
        boolean includeDomainClassName = this.includeDomainClassProperty(grailsConfig, "json");
        ProxyHandler proxyHandler = this.getProxyHandler();
        if (((Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_JSON_DEFAULT_DEEP, Boolean.class, (Object)false)).booleanValue()) {
            this.LOG.debug((Object)"Using DeepDomainClassMarshaller as default.");
            marshallers.add(new DeepDomainClassMarshaller(includeDomainVersion, includeDomainClassName, proxyHandler, this.grailsApplication));
        } else {
            marshallers.add(new DomainClassMarshaller(includeDomainVersion, includeDomainClassName, proxyHandler, this.grailsApplication));
        }
        marshallers.add(new GroovyBeanMarshaller());
        marshallers.add(new org.grails.web.converters.marshaller.json.GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers, proxyHandler);
        cfg.setEncoding(grailsConfig.getProperty(SETTING_CONVERTERS_ENCODING, "UTF-8"));
        String defaultCirRefBehaviour = grailsConfig.getProperty(SETTING_CONVERTERS_CIRCULAR_REFERENCE_BEHAVIOUR, "DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf((String)grailsConfig.getProperty(SETTING_CONVERTERS_JSON_CIRCULAR_REFERENCE_BEHAVIOUR, String.class, (Object)defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = (Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_PRETTY_PRINT, Boolean.class, (Object)false);
        Boolean prettyPrint = (Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_JSON_PRETTY_PRINT, Boolean.class, (Object)defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        cfg.setCacheObjectMarshallerByClass((Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_JSON_CACHE_OBJECTS, Boolean.class, (Object)true));
        this.registerObjectMarshallersFromApplicationContext(cfg, JSON.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, new ChainedConverterConfiguration(cfg, proxyHandler));
    }

    private Config getGrailsConfig() {
        Object grailsConfig = this.grailsApplication != null ? this.grailsApplication.getConfig() : new PropertySourcesConfig();
        return grailsConfig;
    }

    private void initDeepJSONConfiguration() {
        DefaultConverterConfiguration<JSON> deepConfig = new DefaultConverterConfiguration<JSON>(ConvertersConfigurationHolder.getConverterConfiguration(JSON.class), this.getProxyHandler());
        deepConfig.registerObjectMarshaller(new DeepDomainClassMarshaller(this.includeDomainVersionProperty(this.getGrailsConfig(), "json"), this.includeDomainClassProperty(this.getGrailsConfig(), "json"), this.getProxyHandler(), this.grailsApplication));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(JSON.class, "deep", deepConfig);
    }

    private void initXMLConfiguration() {
        this.LOG.debug((Object)"Initializing default XML Converters Configuration...");
        ArrayList marshallers = new ArrayList();
        marshallers.addAll(this.getPreviouslyConfiguredMarshallers(XML.class));
        marshallers.add(new Base64ByteArrayMarshaller());
        marshallers.add(new org.grails.web.converters.marshaller.xml.ArrayMarshaller());
        marshallers.add(new org.grails.web.converters.marshaller.xml.CollectionMarshaller());
        marshallers.add(new MapMarshaller());
        Config grailsConfig = this.getGrailsConfig();
        String xmlEnumFormat = (String)grailsConfig.getProperty("grails.converters.xml.enum.format", String.class, (Object)"default");
        if ("simple".equals(xmlEnumFormat)) {
            marshallers.add(new org.grails.web.converters.marshaller.xml.SimpleEnumMarshaller());
        } else {
            marshallers.add(new org.grails.web.converters.marshaller.xml.EnumMarshaller());
        }
        marshallers.add(new org.grails.web.converters.marshaller.xml.DateMarshaller());
        marshallers.add(new ProxyUnwrappingMarshaller());
        marshallers.add(new org.grails.web.converters.marshaller.xml.ToStringBeanMarshaller());
        ProxyHandler proxyHandler = this.getProxyHandler();
        boolean includeDomainVersion = this.includeDomainVersionProperty(grailsConfig, "xml");
        if (((Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_XML_DEEP, Boolean.class, (Object)false)).booleanValue()) {
            marshallers.add(new org.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(includeDomainVersion, proxyHandler, this.grailsApplication));
        } else {
            marshallers.add(new org.grails.web.converters.marshaller.xml.DomainClassMarshaller(includeDomainVersion, proxyHandler, this.grailsApplication));
        }
        marshallers.add(new org.grails.web.converters.marshaller.xml.GroovyBeanMarshaller());
        marshallers.add(new GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers, proxyHandler);
        cfg.setEncoding(grailsConfig.getProperty(SETTING_CONVERTERS_ENCODING, "UTF-8"));
        String defaultCirRefBehaviour = grailsConfig.getProperty(SETTING_CONVERTERS_CIRCULAR_REFERENCE_BEHAVIOUR, "DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf((String)grailsConfig.getProperty("grails.converters.xml.circular.reference.behaviour", String.class, (Object)defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = (Boolean)grailsConfig.getProperty(SETTING_CONVERTERS_PRETTY_PRINT, Boolean.class, (Object)false);
        Boolean prettyPrint = (Boolean)grailsConfig.getProperty("grails.converters.xml.pretty.print", Boolean.class, (Object)defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        cfg.setCacheObjectMarshallerByClass((Boolean)grailsConfig.getProperty("grails.converters.xml.cacheObjectMarshallerSelectionByClass", Boolean.class, (Object)true));
        this.registerObjectMarshallersFromApplicationContext(cfg, XML.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, new ChainedConverterConfiguration(cfg, proxyHandler));
    }

    private ProxyHandler getProxyHandler() {
        Object proxyHandler = this.applicationContext != null ? (ProxyHandler)this.applicationContext.getBean(ProxyHandler.class) : new DefaultProxyHandler();
        return proxyHandler;
    }

    private void initDeepXMLConfiguration() {
        DefaultConverterConfiguration<XML> deepConfig = new DefaultConverterConfiguration<XML>(ConvertersConfigurationHolder.getConverterConfiguration(XML.class), this.getProxyHandler());
        deepConfig.registerObjectMarshaller(new org.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(this.includeDomainVersionProperty(this.getGrailsConfig(), "xml"), this.includeDomainClassProperty(this.getGrailsConfig(), "xml"), this.getProxyHandler(), this.grailsApplication));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(XML.class, "deep", deepConfig);
    }

    private boolean includeDomainVersionProperty(Config grailsConfig, String converterType) {
        return (Boolean)grailsConfig.getProperty(String.format("grails.converters.%s.domain.include.version", converterType), Boolean.class, (Object)((Boolean)grailsConfig.getProperty("grails.converters.domain.include.version", Boolean.class, (Object)false)));
    }

    private boolean includeDomainClassProperty(Config grailsConfig, String converterType) {
        return (Boolean)grailsConfig.getProperty(String.format("grails.converters.%s.domain.include.class", converterType), Boolean.class, (Object)((Boolean)grailsConfig.getProperty("grails.converters.domain.include.class", Boolean.class, (Object)false)));
    }

    private <C extends Converter> void registerObjectMarshallersFromApplicationContext(DefaultConverterConfiguration<C> cfg, Class<C> converterClass) {
        if (this.applicationContext == null) {
            return;
        }
        for (Object o : this.applicationContext.getBeansOfType(ObjectMarshallerRegisterer.class).values()) {
            ObjectMarshallerRegisterer omr = (ObjectMarshallerRegisterer)o;
            if (omr.getConverterClass() != converterClass) continue;
            cfg.registerObjectMarshaller(omr.getMarshaller(), omr.getPriority());
        }
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    private <C extends Converter> List<ObjectMarshaller<C>> getPreviouslyConfiguredMarshallers(Class<C> converterClass) {
        ConverterConfiguration<C> previousConfiguration = ConvertersConfigurationHolder.getConverterConfiguration(converterClass);
        return previousConfiguration.getOrderedObjectMarshallers();
    }
}

