/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.async.transform;

import grails.async.Promise;
import grails.async.Promises;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.TransformWithPriority;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.grails.async.transform.internal.DelegateAsyncUtils;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class DelegateAsyncTransformation
implements ASTTransformation,
TransformWithPriority {
    private static final ArgumentListExpression NO_ARGS = new ArgumentListExpression();
    private static final String VOID = "void";
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = new ClassNode(GroovyObjectSupport.class);
    public static final ClassNode OBJECT_CLASS_NODE = new ClassNode(Object.class);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + String.valueOf(Arrays.asList(nodes)));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode annotationNode = (AnnotationNode)nodes[0];
        if (parent instanceof ClassNode) {
            Expression value = annotationNode.getMember("value");
            if (value instanceof ClassExpression) {
                ClassNode classNode = (ClassNode)parent;
                ClassNode targetApi = value.getType().getPlainNodeReference();
                String fieldName = "$" + Introspector.decapitalize(targetApi.getNameWithoutPackage());
                FieldNode fieldNode = classNode.getField(fieldName);
                if (fieldNode == null) {
                    fieldNode = new FieldNode(fieldName, 2, targetApi, classNode, (Expression)new ConstructorCallExpression(targetApi, (Expression)NO_ARGS));
                    classNode.addField(fieldNode);
                }
                this.applyDelegateAsyncTransform(classNode, targetApi, fieldName);
            }
        } else if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            ClassNode targetApi = fieldNode.getType().getPlainNodeReference();
            ClassNode classNode = fieldNode.getOwner();
            this.applyDelegateAsyncTransform(classNode, targetApi, fieldNode.getName());
        }
    }

    private void applyDelegateAsyncTransform(ClassNode classNode, ClassNode targetApi, String fieldName) {
        List methods = targetApi.getAllDeclaredMethods();
        ClassNode promisesClass = ClassHelper.make(Promises.class).getPlainNodeReference();
        MethodNode createPromiseMethodTargetWithDecorators = promisesClass.getDeclaredMethod("createPromise", new Parameter[]{new Parameter(new ClassNode(Closure.class), "c"), new Parameter(new ClassNode(List.class), "c")});
        Map genericsSpec = GenericsUtils.createGenericsSpec((ClassNode)classNode);
        for (MethodNode candidate : methods) {
            Parameter[] parameters;
            MethodNode existingMethod;
            if (!DelegateAsyncTransformation.isCandidateMethod(candidate) || (existingMethod = classNode.getMethod(candidate.getName(), candidate.getParameters())) != null) continue;
            List<String> currentMethodGenPlaceholders = this.genericPlaceholderNames(candidate);
            ClassNode promiseNode = ClassHelper.make(Promise.class).getPlainNodeReference();
            ClassNode originalReturnType = GenericsUtils.correctToGenericsSpecRecurse((Map)genericsSpec, (ClassNode)candidate.getReturnType(), currentMethodGenPlaceholders);
            if (!originalReturnType.getNameWithoutPackage().equals(VOID)) {
                ClassNode returnType = originalReturnType;
                if (ClassHelper.isPrimitiveType((ClassNode)originalReturnType.redirect())) {
                    returnType = ClassHelper.getWrapper((ClassNode)originalReturnType.redirect());
                }
                if (!OBJECT_CLASS_NODE.equals((Object)returnType)) {
                    promiseNode.setGenericsTypes(new GenericsType[]{new GenericsType(returnType)});
                }
            }
            BlockStatement methodBody = new BlockStatement();
            BlockStatement promiseBody = new BlockStatement();
            ClosureExpression closureExpression = new ClosureExpression(new Parameter[0], (Statement)promiseBody);
            VariableScope variableScope = new VariableScope();
            closureExpression.setVariableScope(variableScope);
            VariableExpression thisObject = new VariableExpression("this");
            ClassNode delegateAsyncUtilsClassNode = new ClassNode(DelegateAsyncUtils.class);
            MethodNode getPromiseDecoratorsMethodNode = (MethodNode)delegateAsyncUtilsClassNode.getDeclaredMethods("getPromiseDecorators").get(0);
            ListExpression promiseDecorators = new ListExpression();
            ArgumentListExpression getPromiseDecoratorsArguments = new ArgumentListExpression((Expression)thisObject, (Expression)promiseDecorators);
            MethodCallExpression getDecoratorsMethodCall = new MethodCallExpression((Expression)new ClassExpression(delegateAsyncUtilsClassNode), "getPromiseDecorators", (Expression)getPromiseDecoratorsArguments);
            getDecoratorsMethodCall.setMethodTarget(getPromiseDecoratorsMethodNode);
            MethodCallExpression createPromiseWithDecorators = new MethodCallExpression((Expression)new ClassExpression(promisesClass), "createPromise", (Expression)new ArgumentListExpression((Expression)closureExpression, (Expression)getDecoratorsMethodCall));
            if (createPromiseMethodTargetWithDecorators != null) {
                createPromiseWithDecorators.setMethodTarget(createPromiseMethodTargetWithDecorators);
            }
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)createPromiseWithDecorators));
            ArgumentListExpression arguments = new ArgumentListExpression();
            for (Parameter p : parameters = DelegateAsyncTransformation.copyParameters(genericsSpec, StaticTypeCheckingSupport.parameterizeArguments((ClassNode)classNode, (MethodNode)candidate), currentMethodGenPlaceholders)) {
                p.setClosureSharedVariable(true);
                variableScope.putReferencedLocalVariable((Variable)p);
                VariableExpression ve = new VariableExpression((Variable)p);
                ve.setClosureSharedVariable(true);
                arguments.addExpression((Expression)ve);
            }
            MethodCallExpression delegateMethodCall = new MethodCallExpression((Expression)new VariableExpression(fieldName), candidate.getName(), (Expression)arguments);
            promiseBody.addStatement((Statement)new ExpressionStatement((Expression)delegateMethodCall));
            MethodNode newMethodNode = new MethodNode(candidate.getName(), 1, promiseNode, parameters, null, (Statement)methodBody);
            classNode.addMethod(newMethodNode);
        }
    }

    private List<String> genericPlaceholderNames(MethodNode candidate) {
        GenericsType[] candidateGenericsTypes = candidate.getGenericsTypes();
        ArrayList<String> names = new ArrayList<String>();
        if (candidateGenericsTypes != null) {
            for (GenericsType gt : candidateGenericsTypes) {
                names.add(gt.getName());
            }
        }
        return names;
    }

    private static ClassNode alignReturnType(ClassNode receiver, ClassNode originalReturnType) {
        ClassNode copiedReturnType = originalReturnType.getPlainNodeReference();
        ClassNode actualReceiver = receiver;
        ArrayList redirectTypes = new ArrayList();
        if (actualReceiver.redirect().getGenericsTypes() != null) {
            Collections.addAll(redirectTypes, actualReceiver.redirect().getGenericsTypes());
        }
        if (!redirectTypes.isEmpty()) {
            GenericsType[] redirectReceiverTypes = redirectTypes.toArray(new GenericsType[redirectTypes.size()]);
            GenericsType[] receiverParameterizedTypes = actualReceiver.getGenericsTypes();
            if (receiverParameterizedTypes == null) {
                receiverParameterizedTypes = redirectReceiverTypes;
            }
            if (originalReturnType.isUsingGenerics()) {
                GenericsType[] alignmentTypes = originalReturnType.getGenericsTypes();
                GenericsType[] genericsTypes = GenericsUtils.alignGenericTypes((GenericsType[])redirectReceiverTypes, (GenericsType[])receiverParameterizedTypes, (GenericsType[])alignmentTypes);
                copiedReturnType.setGenericsTypes(genericsTypes);
            }
        }
        return copiedReturnType;
    }

    private static boolean isCandidateMethod(MethodNode declaredMethod) {
        ClassNode groovyMethods = GROOVY_OBJECT_CLASS_NODE;
        String methodName = declaredMethod.getName();
        return !declaredMethod.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !groovyMethods.hasMethod(declaredMethod.getName(), declaredMethod.getParameters());
    }

    private static Parameter[] copyParameters(Map<String, ClassNode> genericsSpec, Parameter[] parameterTypes, List<String> currentMethodGenPlaceholders) {
        Parameter[] newParameterTypes = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameterType = parameterTypes[i];
            ClassNode newParamType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, (ClassNode)parameterType.getType(), currentMethodGenPlaceholders);
            Parameter newParameter = new Parameter(newParamType, parameterType.getName(), parameterType.getInitialExpression());
            newParameter.addAnnotations(parameterType.getAnnotations());
            newParameterTypes[i] = newParameter;
        }
        return newParameterTypes;
    }

    public int priority() {
        return 2146483617;
    }
}

