/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.grails.datastore.gorm.validation.constraints.AbstractVetoingConstraint;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;

public class BlankConstraint
extends AbstractVetoingConstraint {
    private final boolean blank;

    public BlankConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.blank = (Boolean)this.constraintParameter;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }

    @Override
    public Object getParameter() {
        return this.blank;
    }

    public boolean isBlank() {
        return this.blank;
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [blank] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be a boolean value");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "blank";
    }

    @Override
    protected boolean skipBlankValues() {
        return false;
    }

    @Override
    protected boolean processValidateWithVetoing(Object target, Object propertyValue, Errors errors) {
        if (!this.blank && propertyValue instanceof String && !StringUtils.hasText((CharSequence)((CharSequence)propertyValue))) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass};
            this.rejectValue(target, errors, "default.blank.message", "blank", args);
            return true;
        }
        return false;
    }
}

