/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.gorm;

import grails.compiler.ast.AstTransformer;
import grails.compiler.ast.GrailsArtefactClassInjector;
import groovy.transform.Canonical;
import java.net.URL;
import java.util.Collection;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.compiler.gorm.GormEntityTransformation;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.datastore.mapping.reflect.AstUtils;
import org.grails.io.support.GrailsResourceUtils;

@AstTransformer
public class GormTransformer
implements GrailsArtefactClassInjector {
    public String[] getArtefactTypes() {
        return new String[]{"Domain"};
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    public static Collection<String> getKnownEntityNames() {
        return AstUtils.getKnownEntityNames();
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (GrailsASTUtils.hasAnnotation((ClassNode)classNode, Canonical.class)) {
            GrailsASTUtils.error((SourceUnit)source, (ASTNode)classNode, (String)("Class [" + classNode.getName() + "] is marked with @groovy.transform.Canonical which is not supported for GORM entities."), (boolean)true);
        }
        GormEntityTransformation transformation = new GormEntityTransformation();
        transformation.visit(classNode, source);
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        if (GrailsASTUtils.hasAnnotation((ClassNode)classNode, Canonical.class)) {
            GrailsASTUtils.error((SourceUnit)source, (ASTNode)classNode, (String)("Class [" + classNode.getName() + "] is marked with @groovy.transform.Canonical which is not supported for GORM entities."), (boolean)true);
        }
        new GormEntityTransformation().visit(classNode, source);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, classNode);
    }
}

