/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.simple;

import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationContextEventPublisher;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DefaultApplicationEventPublisher;
import org.grails.datastore.gorm.events.DomainEventListener;
import org.grails.datastore.gorm.multitenancy.MultiTenantEventListener;
import org.grails.datastore.gorm.utils.ClasspathEntityScanner;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesInitializer;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesProvider;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.connections.InMemoryConnectionSources;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValueMappingContext;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.SchemaMultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.TenantResolver;
import org.grails.datastore.mapping.simple.SimpleMapSession;
import org.grails.datastore.mapping.simple.connections.SimpleMapConnectionSourceFactory;
import org.grails.datastore.mapping.transactions.DatastoreTransactionManager;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class SimpleMapDatastore
extends AbstractDatastore
implements Closeable,
TransactionCapableDatastore,
MultipleConnectionSourceCapableDatastore,
SchemaMultiTenantCapableDatastore<Map<String, Map>, ConnectionSourceSettings>,
ConnectionSourcesProvider<Map<String, Map>, ConnectionSourceSettings> {
    private final Map<String, Map> inmemoryData;
    private final TenantResolver tenantResolver;
    protected final GormEnhancer gormEnhancer;
    private final ConfigurableApplicationEventPublisher eventPublisher;
    private Map indices = new ConcurrentHashMap();
    private final PlatformTransactionManager transactionManager;
    private final ConnectionSources<Map<String, Map>, ConnectionSourceSettings> connectionSources;
    private final MultiTenancySettings.MultiTenancyMode multiTenancyMode;
    protected final Map<String, SimpleMapDatastore> datastoresByConnectionSource = new LinkedHashMap<String, SimpleMapDatastore>();
    protected final boolean failOnError;

    public SimpleMapDatastore(ConnectionSources<Map<String, Map>, ConnectionSourceSettings> connectionSources, MappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        super(mappingContext);
        this.connectionSources = connectionSources;
        ConnectionSource defaultConnectionSource = connectionSources.getDefaultConnectionSource();
        this.inmemoryData = (Map)defaultConnectionSource.getSource();
        DatastoreTransactionManager dtm = new DatastoreTransactionManager();
        dtm.setDatastore((Datastore)this);
        this.transactionManager = dtm;
        MultiTenancySettings multiTenancy = defaultConnectionSource.getSettings().getMultiTenancy();
        this.multiTenancyMode = multiTenancy.getMode();
        this.tenantResolver = multiTenancy.getTenantResolver();
        PropertyResolver config = connectionSources.getBaseConfiguration();
        this.failOnError = (Boolean)config.getProperty("grails.gorm.failOnError", Boolean.class, (Object)false);
        if (!(connectionSources instanceof SingletonConnectionSources)) {
            Iterable allConnectionSources = connectionSources.getAllConnectionSources();
            for (ConnectionSource connectionSource : allConnectionSources) {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                SimpleMapDatastore childDatastore = "DEFAULT".equals(connectionSource.getName()) ? this : new SimpleMapDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

                    @Override
                    protected GormEnhancer initialize(ConnectionSourceSettings settings) {
                        return null;
                    }
                };
                this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
            }
        }
        this.eventPublisher = eventPublisher;
        this.gormEnhancer = this.initialize(defaultConnectionSource.getSettings());
    }

    public SimpleMapDatastore(ConnectionSources<Map<String, Map>, ConnectionSourceSettings> connectionSources, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(connectionSources, (MappingContext)SimpleMapDatastore.createMappingContext(connectionSources, classes), eventPublisher);
    }

    public SimpleMapDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)new SimpleMapConnectionSourceFactory(), (PropertyResolver)configuration), eventPublisher, classes);
    }

    public SimpleMapDatastore() {
        this(DatastoreUtils.createPropertyResolver(null), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), new Class[0]);
    }

    public SimpleMapDatastore(Iterable<String> dataSourceNames, Class ... classes) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)SimpleMapDatastore.createMultipleDataSources(dataSourceNames, DatastoreUtils.createPropertyResolver(null)), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public SimpleMapDatastore(Class ... classes) {
        this(DatastoreUtils.createPropertyResolver(null), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public SimpleMapDatastore(PropertyResolver configuration, Iterable<String> dataSourceNames, Class ... classes) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)SimpleMapDatastore.createMultipleDataSources(dataSourceNames, configuration), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), classes);
    }

    public SimpleMapDatastore(PropertyResolver configuration, Iterable<String> dataSourceNames, Package ... packages) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)SimpleMapDatastore.createMultipleDataSources(dataSourceNames, configuration), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), new ClasspathEntityScanner().scan(packages));
    }

    public SimpleMapDatastore(Map configuration, Iterable<String> dataSourceNames, Package ... packages) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)SimpleMapDatastore.createMultipleDataSources(dataSourceNames, DatastoreUtils.createPropertyResolver((Map)configuration)), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), new ClasspathEntityScanner().scan(packages));
    }

    public SimpleMapDatastore(Map configuration, Package ... packages) {
        this(DatastoreUtils.createPropertyResolver((Map)configuration), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), new ClasspathEntityScanner().scan(packages));
    }

    public SimpleMapDatastore(PropertyResolver configuration, Iterable<String> dataSourceNames, Package packageToScan) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)SimpleMapDatastore.createMultipleDataSources(dataSourceNames, configuration), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher(), new ClasspathEntityScanner().scan(new Package[]{packageToScan}));
    }

    @Deprecated
    public SimpleMapDatastore(Map<String, Map> datastore, ConfigurableApplicationContext ctx) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)new SingletonConnectionSources((ConnectionSource)new DefaultConnectionSource("DEFAULT", datastore, new ConnectionSourceSettings()), DatastoreUtils.createPropertyResolver(null)), (ConfigurableApplicationEventPublisher)new ConfigurableApplicationContextEventPublisher(ctx), new Class[0]);
        this.setApplicationContext((ApplicationContext)ctx);
    }

    private static PropertyResolver getConfiguration(ConfigurableApplicationContext ctx) {
        PropertyResolver propertyResolver;
        try {
            propertyResolver = (PropertyResolver)ctx.getBean(PropertyResolver.class);
        }
        catch (Exception e) {
            propertyResolver = DatastoreUtils.createPropertyResolver(null);
        }
        return propertyResolver;
    }

    @Deprecated
    public SimpleMapDatastore(ConfigurableApplicationContext ctx) {
        this(SimpleMapDatastore.getConfiguration(ctx), (ConfigurableApplicationEventPublisher)new ConfigurableApplicationContextEventPublisher(ctx), new Class[0]);
        this.setApplicationContext((ApplicationContext)ctx);
    }

    @Deprecated
    public SimpleMapDatastore(MappingContext mappingContext, ConfigurableApplicationContext ctx) {
        this((ConnectionSources<Map<String, Map>, ConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)new SimpleMapConnectionSourceFactory(), (PropertyResolver)DatastoreUtils.createPropertyResolver(null)), mappingContext, (ConfigurableApplicationEventPublisher)new ConfigurableApplicationContextEventPublisher(ctx));
    }

    protected static KeyValueMappingContext createMappingContext(ConnectionSources<Map<String, Map>, ConnectionSourceSettings> connectionSources, Class ... classes) {
        KeyValueMappingContext ctx = new KeyValueMappingContext("test", connectionSources.getDefaultConnectionSource().getSettings());
        ctx.addPersistentEntities(classes);
        return ctx;
    }

    protected static InMemoryConnectionSources<Map<String, Map>, ConnectionSourceSettings> createMultipleDataSources(final Iterable<String> dataSourceNames, PropertyResolver propertyResolver) {
        SimpleMapConnectionSourceFactory simpleMapConnectionSourceFactory = new SimpleMapConnectionSourceFactory();
        return new InMemoryConnectionSources<Map<String, Map>, ConnectionSourceSettings>(simpleMapConnectionSourceFactory.create("DEFAULT", propertyResolver), (ConnectionSourceFactory)simpleMapConnectionSourceFactory, propertyResolver){

            protected Iterable<String> getConnectionSourceNames(ConnectionSourceFactory<Map<String, Map>, ConnectionSourceSettings> connectionSourceFactory, PropertyResolver configuration) {
                return dataSourceNames;
            }
        };
    }

    protected GormEnhancer initialize(ConnectionSourceSettings settings) {
        this.registerEventListeners(this.eventPublisher);
        this.mappingContext.addMappingContextListener(new MappingContext.Listener(){

            public void persistentEntityAdded(PersistentEntity entity) {
                SimpleMapDatastore.this.gormEnhancer.registerEntity(entity);
            }
        });
        return new GormEnhancer((Datastore)this, this.transactionManager, settings){

            protected <D> GormStaticApi<D> getStaticApi(Class<D> cls, String qualifier) {
                SimpleMapDatastore datastore = this.getDatastoreForQualifier(cls, qualifier);
                return new GormStaticApi(cls, (Datastore)datastore, this.createDynamicFinders((Datastore)datastore), datastore.getTransactionManager());
            }

            protected <D> GormValidationApi<D> getValidationApi(Class<D> cls, String qualifier) {
                SimpleMapDatastore datastore = this.getDatastoreForQualifier(cls, qualifier);
                return new GormValidationApi(cls, (Datastore)datastore);
            }

            protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls, String qualifier) {
                SimpleMapDatastore datastore = this.getDatastoreForQualifier(cls, qualifier);
                GormInstanceApi instanceApi = new GormInstanceApi(cls, (Datastore)datastore);
                instanceApi.setFailOnError(SimpleMapDatastore.this.failOnError);
                return instanceApi;
            }

            private <D> SimpleMapDatastore getDatastoreForQualifier(Class<D> cls, String qualifier) {
                ConnectionSource connectionSource;
                String defaultConnectionSourceName = ConnectionSourcesSupport.getDefaultConnectionSourceName((PersistentEntity)SimpleMapDatastore.this.getMappingContext().getPersistentEntity(cls.getName()));
                boolean isDefaultQualifier = qualifier.equals("DEFAULT");
                if (isDefaultQualifier && defaultConnectionSourceName.equals("DEFAULT")) {
                    return SimpleMapDatastore.this;
                }
                if (isDefaultQualifier) {
                    qualifier = defaultConnectionSourceName;
                }
                if ((connectionSource = SimpleMapDatastore.this.connectionSources.getConnectionSource(qualifier)) == null) {
                    throw new ConfigurationException("Invalid connection [" + defaultConnectionSourceName + "] configured for class [" + String.valueOf(cls) + "]");
                }
                return SimpleMapDatastore.this.datastoresByConnectionSource.get(qualifier);
            }
        };
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)new DomainEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new AutoTimestampEventListener((Datastore)this));
        if (this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            eventPublisher.addApplicationListener((ApplicationListener)new MultiTenantEventListener((Datastore)this));
        }
    }

    public Map getIndices() {
        return this.indices;
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        return new SimpleMapSession(this, this.getMappingContext(), (ApplicationEventPublisher)this.eventPublisher);
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public Map<String, Map> getBackingMap() {
        return this.inmemoryData;
    }

    public void clearData() {
        this.inmemoryData.clear();
        this.indices.clear();
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public ConnectionSources<Map<String, Map>, ConnectionSourceSettings> getConnectionSources() {
        return this.connectionSources;
    }

    public MultiTenancySettings.MultiTenancyMode getMultiTenancyMode() {
        return this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.SCHEMA ? MultiTenancySettings.MultiTenancyMode.DATABASE : this.multiTenancyMode;
    }

    public TenantResolver getTenantResolver() {
        return this.tenantResolver;
    }

    public Datastore getDatastoreForTenantId(Serializable tenantId) {
        if (this.multiTenancyMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            return this;
        }
        if (tenantId != null) {
            return this.getDatastoreForConnection(tenantId.toString());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1> T1 withNewSession(Serializable tenantId, Closure<T1> callable) {
        Datastore datastore = this.getDatastoreForTenantId(tenantId);
        Session session = datastore.connect();
        try {
            DatastoreUtils.bindNewSession((Session)session);
            Object object = callable.call((Object)session);
            return (T1)object;
        }
        finally {
            DatastoreUtils.unbindSession((Session)session);
        }
    }

    public Datastore getDatastoreForConnection(String connectionName) {
        SimpleMapDatastore childDatastore = this.datastoresByConnectionSource.get(connectionName);
        if (childDatastore == null) {
            throw new ConfigurationException("No datastore found for connection named [" + connectionName + "]");
        }
        return childDatastore;
    }

    @Override
    public void close() throws IOException {
        try {
            this.destroy();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.gormEnhancer.close();
    }

    public void addTenantForSchema(String schemaName) {
        ConnectionSource connectionSource = this.connectionSources.addConnectionSource(schemaName, Collections.emptyMap());
        SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, this.connectionSources.getBaseConfiguration());
        SimpleMapDatastore childDatastore = "DEFAULT".equals(connectionSource.getName()) ? this : new SimpleMapDatastore((ConnectionSources)singletonConnectionSources, this.mappingContext, this.eventPublisher){

            @Override
            protected GormEnhancer initialize(ConnectionSourceSettings settings) {
                return null;
            }
        };
        this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            this.gormEnhancer.registerEntity(persistentEntity);
        }
    }
}

