/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.codahale.metrics.Meter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StreamCopier {
    private static final int KB = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    private final ReadableByteChannel inputChannel;
    private final WritableByteChannel outputChannel;
    private final Long maxBytes;
    private int bufferSize = 32768;
    private Meter copySpeedMeter;
    private boolean closeChannelsOnComplete = false;
    private volatile boolean copied = false;
    private static Closeable NOOP_CLOSEABLE = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    public StreamCopier(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, null);
    }

    public StreamCopier(InputStream inputStream, OutputStream outputStream, Long maxBytes) {
        this(Channels.newChannel(inputStream), Channels.newChannel(outputStream), maxBytes);
    }

    public StreamCopier(ReadableByteChannel inputChannel, WritableByteChannel outputChannel) {
        this(inputChannel, outputChannel, null);
    }

    public StreamCopier(ReadableByteChannel inputChannel, WritableByteChannel outputChannel, Long maxBytes) {
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.maxBytes = maxBytes;
    }

    public StreamCopier withBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public StreamCopier withCopySpeedMeter(Meter copySpeedMeter) {
        this.copySpeedMeter = copySpeedMeter;
        return this;
    }

    public StreamCopier closeChannelsOnComplete() {
        this.closeChannelsOnComplete = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long copy() throws IOException {
        if (this.copied) {
            throw new IllegalStateException(String.format("%s already copied.", StreamCopier.class.getName()));
        }
        this.copied = true;
        try {
            long numBytes = 0L;
            long totalBytes = 0L;
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSize);
            while ((this.maxBytes == null || this.maxBytes > totalBytes) && (numBytes = this.fillBufferFromInputChannel(buffer)) != -1L) {
                buffer.flip();
                if (this.maxBytes != null && (totalBytes += numBytes) > this.maxBytes) {
                    buffer.limit(buffer.limit() - (int)(totalBytes - this.maxBytes));
                    totalBytes = this.maxBytes;
                }
                this.outputChannel.write(buffer);
                buffer.compact();
                if (this.copySpeedMeter == null) continue;
                this.copySpeedMeter.mark(numBytes);
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.outputChannel.write(buffer);
            }
            long l = totalBytes;
            return l;
        }
        finally {
            if (this.closeChannelsOnComplete) {
                this.inputChannel.close();
                this.outputChannel.close();
            }
        }
    }

    private long fillBufferFromInputChannel(ByteBuffer buffer) throws IOException {
        return this.inputChannel.read(buffer);
    }

    public static class NotEnoughPermitsException
    extends IOException {
        private NotEnoughPermitsException() {
            super("Not enough permits to perform stream copy.");
        }
    }
}

