/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class DownloadUtils {
    public static final String IVY_SETTINGS_FILE_NAME = "ivysettings.xml";

    public static URI[] downloadJar(String org, String module, String version, boolean transitive) throws IOException {
        HashMap artifactMap = Maps.newHashMap();
        artifactMap.put("org", org);
        artifactMap.put("module", module);
        artifactMap.put("version", version);
        artifactMap.put("transitive", transitive);
        return DownloadUtils.downloadJar(artifactMap);
    }

    public static URI[] downloadJar(Map<String, Object> artifactMap) throws IOException {
        System.setProperty("grape.config", DownloadUtils.getIvySettingsFile().getAbsolutePath());
        HashMap args = Maps.newHashMap();
        args.put("classLoader", AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader();
            }
        }));
        return Grape.resolve((Map)args, (Map[])new Map[]{artifactMap});
    }

    public static File getIvySettingsFile() throws IOException {
        URL settingsUrl = Thread.currentThread().getContextClassLoader().getResource(IVY_SETTINGS_FILE_NAME);
        if (settingsUrl == null) {
            throw new IOException("Failed to find ivysettings.xml from class path");
        }
        File ivySettingsFile = new File(settingsUrl.getFile());
        if (ivySettingsFile.exists()) {
            return ivySettingsFile;
        }
        ivySettingsFile = File.createTempFile("ivy.settings", ".xml");
        ivySettingsFile.deleteOnExit();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(ivySettingsFile));){
            Resources.copy((URL)settingsUrl, (OutputStream)os);
        }
        return ivySettingsFile;
    }
}

