/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opencsv.CSVReader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.FileUtils;

public class ConfigUtils {
    private final FileUtils fileUtils;
    private static final String GOBBLIN_CONFIG_BLACKLIST_KEYS = "gobblin.config.blacklistKeys";
    public static final String STRIP_SUFFIX = ".ROOT_VALUE";

    public ConfigUtils(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    public void saveConfigToFile(Config config, Path destPath) throws IOException {
        String configAsHoconString = config.root().render();
        this.fileUtils.saveToFile(configAsHoconString, destPath);
    }

    public static Properties configToProperties(Config config) {
        return ConfigUtils.configToProperties(config, (Optional<String>)Optional.absent());
    }

    public static Properties configToProperties(Config config, Optional<String> prefix) {
        Properties properties = new Properties();
        if (config != null) {
            Config resolvedConfig = config.resolve();
            for (Map.Entry entry : resolvedConfig.entrySet()) {
                if (prefix.isPresent() && !((String)entry.getKey()).startsWith((String)prefix.get())) continue;
                String propKey = ConfigUtils.desanitizeKey((String)entry.getKey());
                properties.setProperty(propKey, resolvedConfig.getString((String)entry.getKey()));
            }
        }
        return properties;
    }

    public static Properties configToProperties(Config config, String prefix) {
        return ConfigUtils.configToProperties(config, (Optional<String>)Optional.of((Object)prefix));
    }

    public static Config getConfigOrEmpty(Config config, String key) {
        try {
            if (config.hasPath(key)) {
                return config.getConfig(key);
            }
            return ConfigFactory.empty();
        }
        catch (ConfigException.WrongType wrongType) {
            return ConfigFactory.empty();
        }
    }

    public static State configToState(Config config) {
        return new State(ConfigUtils.configToProperties(config));
    }

    public static Config propertiesToConfig(Properties properties) {
        return ConfigUtils.propertiesToConfig(properties, (Optional<String>)Optional.absent());
    }

    public static Set<String> findFullPrefixKeys(Properties properties, Optional<String> keyPrefix) {
        TreeSet<String> propNames = new TreeSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!StringUtils.startsWith((CharSequence)entryKey, (CharSequence)((CharSequence)keyPrefix.or((Object)"")))) continue;
            propNames.add(entryKey);
        }
        HashSet<String> result = new HashSet<String>();
        String lastKey = null;
        for (String propName : propNames) {
            if (null != lastKey && propName.startsWith(lastKey + ".")) {
                result.add(lastKey);
            }
            lastKey = propName;
        }
        return result;
    }

    public static Config propertiesToConfig(Properties properties, Optional<String> prefix) {
        HashSet blacklistedKeys = new HashSet();
        if (properties.containsKey(GOBBLIN_CONFIG_BLACKLIST_KEYS)) {
            blacklistedKeys = new HashSet(Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)properties.getProperty(GOBBLIN_CONFIG_BLACKLIST_KEYS)));
        }
        Set<String> fullPrefixKeys = ConfigUtils.findFullPrefixKeys(properties, prefix);
        ImmutableMap.Builder immutableMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!StringUtils.startsWith((CharSequence)entryKey, (CharSequence)((CharSequence)prefix.or((Object)""))) || blacklistedKeys.contains(entryKey)) continue;
            if (fullPrefixKeys.contains(entryKey)) {
                entryKey = ConfigUtils.sanitizeFullPrefixKey(entryKey);
            } else if (entryKey.endsWith(STRIP_SUFFIX)) {
                throw new RuntimeException("Properties are not allowed to end in .ROOT_VALUE");
            }
            immutableMapBuilder.put((Object)entryKey, entry.getValue());
        }
        return ConfigFactory.parseMap((Map)immutableMapBuilder.build());
    }

    public static String sanitizeFullPrefixKey(String propKey) {
        return propKey + STRIP_SUFFIX;
    }

    public static String desanitizeKey(String propKey) {
        propKey = propKey.endsWith(STRIP_SUFFIX) ? propKey.substring(0, propKey.length() - STRIP_SUFFIX.length()) : propKey;
        propKey = propKey.replace("\"", "");
        return propKey;
    }

    public static Config propertiesToTypedConfig(Properties properties, Optional<String> prefix) {
        Map<String, Object> typedProps = ConfigUtils.guessPropertiesTypes(properties);
        ImmutableMap.Builder immutableMapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : typedProps.entrySet()) {
            if (!StringUtils.startsWith((CharSequence)entry.getKey(), (CharSequence)((CharSequence)prefix.or((Object)"")))) continue;
            immutableMapBuilder.put((Object)entry.getKey(), entry.getValue());
        }
        return ConfigFactory.parseMap((Map)immutableMapBuilder.build());
    }

    private static Map<String, Object> guessPropertiesTypes(Map<Object, Object> srcProperties) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> prop : srcProperties.entrySet()) {
            Object value;
            block7: {
                value = prop.getValue();
                if (null != value && value instanceof String && !Strings.isNullOrEmpty((String)value.toString())) {
                    try {
                        value = Long.parseLong(value.toString());
                    }
                    catch (NumberFormatException e) {
                        try {
                            value = Double.parseDouble(value.toString());
                        }
                        catch (NumberFormatException e2) {
                            if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("yes")) {
                                value = Boolean.TRUE;
                                break block7;
                            }
                            if (!value.toString().equalsIgnoreCase("false") && !value.toString().equalsIgnoreCase("no")) break block7;
                            value = Boolean.FALSE;
                        }
                    }
                }
            }
            res.put(prop.getKey().toString(), value);
        }
        return res;
    }

    public static String emptyIfNotPresent(Config config, String path) {
        return ConfigUtils.getString(config, path, "");
    }

    public static String getString(Config config, String path, String def) {
        if (config.hasPath(path)) {
            return config.getString(path);
        }
        return def;
    }

    public static Long getLong(Config config, String path, Long def) {
        if (config.hasPath(path)) {
            return config.getLong(path);
        }
        return def;
    }

    public static Integer getInt(Config config, String path, Integer def) {
        if (config.hasPath(path)) {
            return config.getInt(path);
        }
        return def;
    }

    public static boolean getBoolean(Config config, String path, boolean def) {
        if (config.hasPath(path)) {
            return config.getBoolean(path);
        }
        return def;
    }

    public static double getDouble(Config config, String path, double def) {
        if (config.hasPath(path)) {
            return config.getDouble(path);
        }
        return def;
    }

    public static Config getConfig(Config config, String path, Config def) {
        if (config.hasPath(path)) {
            return config.getConfig(path);
        }
        return def;
    }

    public static List<String> getStringList(Config config, String path) {
        if (!config.hasPath(path)) {
            return Collections.emptyList();
        }
        List valueList = Lists.newArrayList();
        try {
            valueList = config.getStringList(path);
        }
        catch (ConfigException.WrongType e) {
            if (StringUtils.isEmpty((CharSequence)config.getString(path))) {
                return Collections.emptyList();
            }
            try (CSVReader csvr = new CSVReader((Reader)new StringReader(config.getString(path)));){
                valueList = Lists.newArrayList((Object[])csvr.readNext());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)valueList, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input == null) {
                    return input;
                }
                return input.replaceAll("^\"|\"$", "");
            }
        }));
    }

    public static boolean hasNonEmptyPath(Config config, String key) {
        return config.hasPath(key) && StringUtils.isNotBlank((CharSequence)config.getString(key));
    }

    public static boolean verifySubset(Config superConfig, Config subConfig) {
        for (Map.Entry entry : subConfig.entrySet()) {
            if (superConfig.hasPath((String)entry.getKey()) && superConfig.getValue((String)entry.getKey()).unwrapped().equals(((ConfigValue)entry.getValue()).unwrapped())) continue;
            return false;
        }
        return true;
    }

    public static Config resolveEncrypted(Config config, Optional<String> encConfigPath) {
        if (!encConfigPath.isPresent() || !config.hasPath((String)encConfigPath.get())) {
            return config;
        }
        Config encryptedConfig = config.getConfig((String)encConfigPath.get());
        PasswordManager passwordManager = PasswordManager.getInstance((Properties)ConfigUtils.configToProperties(config));
        HashMap tmpMap = Maps.newHashMap();
        for (Map.Entry entry : encryptedConfig.entrySet()) {
            String val = ((ConfigValue)entry.getValue()).unwrapped().toString();
            val = passwordManager.readPassword(val);
            tmpMap.put(entry.getKey(), val);
        }
        return ConfigFactory.parseMap((Map)tmpMap).withFallback((ConfigMergeable)config);
    }
}

