/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AvroUtils.class);
    public static final String FIELD_LOCATION_DELIMITER = ".";
    private static final String AVRO_SUFFIX = ".avro";

    public static Optional<Schema> getFieldSchema(Schema schema, String fieldLocation) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        ArrayList pathList = Lists.newArrayList((Iterable)splitter.split((CharSequence)fieldLocation));
        if (pathList.size() == 0) {
            return Optional.absent();
        }
        return AvroUtils.getFieldSchemaHelper(schema, pathList, 0);
    }

    private static Optional<Schema> getFieldSchemaHelper(Schema schema, List<String> pathList, int field) {
        if (schema.getType() == Schema.Type.RECORD && schema.getField(pathList.get(field)) == null) {
            return Optional.absent();
        }
        switch (schema.getType()) {
            case UNION: {
                if (AvroSerdeUtils.isNullableType((Schema)schema)) {
                    return AvroUtils.getFieldSchemaHelper(AvroSerdeUtils.getOtherTypeFromNullableType((Schema)schema), pathList, field);
                }
                throw new AvroRuntimeException("Union of complex types cannot be handled : " + schema);
            }
            case MAP: {
                if (field + 1 == pathList.size()) {
                    return Optional.fromNullable((Object)schema.getValueType());
                }
                return AvroUtils.getFieldSchemaHelper(schema.getValueType(), pathList, ++field);
            }
            case RECORD: {
                if (field + 1 == pathList.size()) {
                    return Optional.fromNullable((Object)schema.getField(pathList.get(field)).schema());
                }
                return AvroUtils.getFieldSchemaHelper(schema.getField(pathList.get(field)).schema(), pathList, ++field);
            }
        }
        throw new AvroRuntimeException("Invalid type in schema : " + schema);
    }

    public static Optional<Schema.Field> getField(Schema schema, String fieldLocation) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        ArrayList pathList = Lists.newArrayList((Iterable)splitter.split((CharSequence)fieldLocation));
        if (pathList.size() == 0) {
            return Optional.absent();
        }
        return AvroUtils.getFieldHelper(schema, pathList, 0);
    }

    private static Optional<Schema.Field> getFieldHelper(Schema schema, List<String> pathList, int field) {
        Schema.Field curField = schema.getField(pathList.get(field));
        if (field + 1 == pathList.size()) {
            return Optional.fromNullable((Object)curField);
        }
        Schema fieldSchema = curField.schema();
        switch (fieldSchema.getType()) {
            case UNION: {
                throw new AvroRuntimeException("Union of complex types cannot be handled : " + schema);
            }
            case MAP: {
                return AvroUtils.getFieldHelper(fieldSchema.getValueType(), pathList, ++field);
            }
            case RECORD: {
                return AvroUtils.getFieldHelper(fieldSchema, pathList, ++field);
            }
        }
        throw new AvroRuntimeException("Invalid type in schema : " + schema);
    }

    public static Optional<Object> getFieldValue(GenericRecord record, String fieldLocation) {
        Map<String, Object> ret = AvroUtils.getMultiFieldValue(record, fieldLocation);
        return Optional.fromNullable((Object)ret.get(fieldLocation));
    }

    public static Map<String, Object> getMultiFieldValue(GenericRecord record, String fieldLocation) {
        Preconditions.checkNotNull((Object)record);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fieldLocation) ? 1 : 0) != 0);
        Splitter splitter = Splitter.on((String)FIELD_LOCATION_DELIMITER).omitEmptyStrings().trimResults();
        List pathList = splitter.splitToList((CharSequence)fieldLocation);
        if (pathList.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        AvroUtils.getFieldHelper(retVal, record, pathList, 0);
        return retVal;
    }

    private static void getFieldHelper(Map<String, Object> retVal, Object data, List<String> pathList, int field) {
        if (data == null) {
            return;
        }
        if (field + 1 == pathList.size()) {
            Object val = null;
            Joiner joiner = Joiner.on((String)FIELD_LOCATION_DELIMITER);
            String key = joiner.join(pathList.iterator());
            val = data instanceof Map ? AvroUtils.getObjectFromMap((Map)data, pathList.get(field)) : (data instanceof List ? AvroUtils.getObjectFromArray((List)data, Integer.parseInt(pathList.get(field))) : ((GenericData.Record)data).get(pathList.get(field)));
            if (val != null) {
                retVal.put(key, val);
            }
            return;
        }
        if (data instanceof Map) {
            AvroUtils.getFieldHelper(retVal, AvroUtils.getObjectFromMap((Map)data, pathList.get(field)), pathList, ++field);
            return;
        }
        if (data instanceof List) {
            if (pathList.get(field).trim().equals("*")) {
                List arr = (List)data;
                Iterator it = arr.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object val = it.next();
                    ArrayList<String> newPathList = new ArrayList<String>(pathList);
                    newPathList.set(field, String.valueOf(i));
                    AvroUtils.getFieldHelper(retVal, val, newPathList, field + 1);
                    ++i;
                }
            } else {
                AvroUtils.getFieldHelper(retVal, AvroUtils.getObjectFromArray((List)data, Integer.parseInt(pathList.get(field))), pathList, ++field);
            }
            return;
        }
        AvroUtils.getFieldHelper(retVal, ((GenericData.Record)data).get(pathList.get(field)), pathList, ++field);
    }

    public static Map<String, String> toStringMap(Object map) {
        if (map == null) {
            return null;
        }
        if (map instanceof Map) {
            Map rawMap = (Map)map;
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry entry : rawMap.entrySet()) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return stringMap;
        }
        throw new AvroRuntimeException("value must be a map");
    }

    private static Object getObjectFromMap(Map map, String key) {
        Utf8 utf8Key = new Utf8(key);
        return map.get(utf8Key);
    }

    private static Object getObjectFromArray(List array, int index) {
        return array.get(index);
    }

    public static GenericRecord convertRecordSchema(GenericRecord record, Schema newSchema) throws IOException {
        if (record.getSchema().equals((Object)newSchema)) {
            return record;
        }
        try {
            BinaryDecoder decoder = new DecoderFactory().binaryDecoder(AvroUtils.recordToByteArray(record), null);
            GenericDatumReader reader = new GenericDatumReader(record.getSchema(), newSchema);
            return (GenericRecord)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot convert avro record to new schema. Origianl schema = %s, new schema = %s", record.getSchema(), newSchema), e);
        }
    }

    public static byte[] recordToByteArray(GenericRecord record) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byteArray;
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            writer.write((Object)record, (Encoder)encoder);
            byte[] byArray = byteArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static Schema getSchemaFromDataFile(Path dataFile, FileSystem fs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Schema parseSchemaFromFile(Path filePath, FileSystem fs) throws IOException {
        Preconditions.checkArgument((boolean)fs.exists(filePath), (Object)(filePath + " does not exist"));
        try (FSDataInputStream in = fs.open(filePath);){
            Schema schema = new Schema.Parser().parse((InputStream)in);
            return schema;
        }
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, FileSystem fs, boolean overwrite) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, null, fs, overwrite);
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, Path tempFilePath, FileSystem fs, boolean overwrite) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, tempFilePath, fs, overwrite, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.READ));
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, FileSystem fs, boolean overwrite, FsPermission perm) throws IOException {
        AvroUtils.writeSchemaToFile(schema, filePath, null, fs, overwrite, perm);
    }

    public static void writeSchemaToFile(Schema schema, Path filePath, Path tempFilePath, FileSystem fs, boolean overwrite, FsPermission perm) throws IOException {
        boolean fileExists = fs.exists(filePath);
        if (!overwrite) {
            Preconditions.checkState((!fileExists ? 1 : 0) != 0, (Object)(filePath + " already exists"));
        } else if (fileExists && null == tempFilePath) {
            HadoopUtils.deletePath(fs, filePath, true);
            fileExists = false;
        }
        Path writeFilePath = fileExists ? tempFilePath : filePath;
        try (FSDataOutputStream dos = fs.create(writeFilePath);){
            dos.writeChars(schema.toString());
        }
        fs.setPermission(writeFilePath, perm);
        if (fileExists) {
            if (!fs.delete(filePath, true)) {
                throw new IOException(String.format("Failed to delete %s while renaming %s to %s", filePath, tempFilePath, filePath));
            }
            HadoopUtils.movePath(fs, tempFilePath, fs, filePath, true, fs.getConf());
        }
    }

    public static Schema getDirectorySchema(Path directory, FileSystem fs, boolean latest) throws IOException {
        Schema schema = null;
        try (Closer closer = Closer.create();){
            List<FileStatus> files = AvroUtils.getDirectorySchemaHelper(directory, fs);
            if (files == null || files.size() == 0) {
                LOG.warn("There is no previous avro file in the directory: " + directory);
            } else {
                FileStatus file = latest ? files.get(0) : files.get(files.size() - 1);
                LOG.debug("Path to get the avro schema: " + file);
                FsInput fi = new FsInput(file.getPath(), fs.getConf());
                GenericDatumReader genReader = new GenericDatumReader();
                schema = ((DataFileReader)closer.register((Closeable)new DataFileReader((SeekableInput)fi, (DatumReader)genReader))).getSchema();
            }
        }
        catch (IOException ioe) {
            throw new IOException("Cannot get the schema for directory " + directory, ioe);
        }
        return schema;
    }

    public static Schema getDirectorySchema(Path directory, Configuration conf, boolean latest) throws IOException {
        return AvroUtils.getDirectorySchema(directory, FileSystem.get((Configuration)conf), latest);
    }

    private static List<FileStatus> getDirectorySchemaHelper(Path directory, FileSystem fs) throws IOException {
        ArrayList files = Lists.newArrayList();
        if (fs.exists(directory)) {
            AvroUtils.getAllNestedAvroFiles(fs.getFileStatus(directory), files, fs);
            if (files.size() > 0) {
                Collections.sort(files, FileListUtils.LATEST_MOD_TIME_ORDER);
            }
        }
        return files;
    }

    private static void getAllNestedAvroFiles(FileStatus dir, List<FileStatus> files, FileSystem fs) throws IOException {
        if (dir.isDirectory()) {
            FileStatus[] filesInDir = fs.listStatus(dir.getPath());
            if (filesInDir != null) {
                for (FileStatus f : filesInDir) {
                    AvroUtils.getAllNestedAvroFiles(f, files, fs);
                }
            }
        } else if (dir.getPath().getName().endsWith(AVRO_SUFFIX)) {
            files.add(dir);
        }
    }

    public static Schema nullifyFieldsForSchemaMerge(Schema oldSchema, Schema newSchema) {
        if (oldSchema == null) {
            LOG.warn("No previous schema available, use the new schema instead.");
            return newSchema;
        }
        if (!oldSchema.getType().equals((Object)Schema.Type.RECORD) || !newSchema.getType().equals((Object)Schema.Type.RECORD)) {
            LOG.warn("Both previous schema and new schema need to be record type. Quit merging schema.");
            return newSchema;
        }
        ArrayList combinedFields = Lists.newArrayList();
        for (Schema.Field newFld : newSchema.getFields()) {
            combinedFields.add(new Schema.Field(newFld.name(), newFld.schema(), newFld.doc(), newFld.defaultValue()));
        }
        for (Schema.Field oldFld : oldSchema.getFields()) {
            Schema newFldSchema;
            if (newSchema.getField(oldFld.name()) != null) continue;
            ArrayList union = Lists.newArrayList();
            Schema oldFldSchema = oldFld.schema();
            if (oldFldSchema.getType().equals((Object)Schema.Type.UNION)) {
                union.add(Schema.create((Schema.Type)Schema.Type.NULL));
                for (Schema itemInUion : oldFldSchema.getTypes()) {
                    if (itemInUion.getType().equals((Object)Schema.Type.NULL)) continue;
                    union.add(itemInUion);
                }
                newFldSchema = Schema.createUnion((List)union);
                combinedFields.add(new Schema.Field(oldFld.name(), newFldSchema, oldFld.doc(), oldFld.defaultValue()));
                continue;
            }
            union.add(Schema.create((Schema.Type)Schema.Type.NULL));
            union.add(oldFldSchema);
            newFldSchema = Schema.createUnion((List)union);
            combinedFields.add(new Schema.Field(oldFld.name(), newFldSchema, oldFld.doc(), oldFld.defaultValue()));
        }
        Schema mergedSchema = Schema.createRecord((String)newSchema.getName(), (String)newSchema.getDoc(), (String)newSchema.getNamespace(), (boolean)newSchema.isError());
        mergedSchema.setFields((List)combinedFields);
        return mergedSchema;
    }

    public static Optional<Schema> removeUncomparableFields(Schema schema) {
        return AvroUtils.removeUncomparableFields(schema, Sets.newHashSet());
    }

    private static Optional<Schema> removeUncomparableFields(Schema schema, Set<Schema> processed) {
        switch (schema.getType()) {
            case RECORD: {
                return AvroUtils.removeUncomparableFieldsFromRecord(schema, processed);
            }
            case UNION: {
                return AvroUtils.removeUncomparableFieldsFromUnion(schema, processed);
            }
            case MAP: {
                return Optional.absent();
            }
            case ARRAY: {
                return Optional.absent();
            }
            case ENUM: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)schema);
    }

    private static Optional<Schema> removeUncomparableFieldsFromRecord(Schema record, Set<Schema> processed) {
        Preconditions.checkArgument((record.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        if (processed.contains(record)) {
            return Optional.absent();
        }
        processed.add(record);
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : record.getFields()) {
            Optional<Schema> newFieldSchema = AvroUtils.removeUncomparableFields(field.schema(), processed);
            if (!newFieldSchema.isPresent()) continue;
            fields.add(new Schema.Field(field.name(), (Schema)newFieldSchema.get(), field.doc(), field.defaultValue()));
        }
        Schema newSchema = Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)false);
        newSchema.setFields((List)fields);
        return Optional.of((Object)newSchema);
    }

    private static Optional<Schema> removeUncomparableFieldsFromUnion(Schema union, Set<Schema> processed) {
        Preconditions.checkArgument((union.getType() == Schema.Type.UNION ? 1 : 0) != 0);
        if (processed.contains(union)) {
            return Optional.absent();
        }
        processed.add(union);
        ArrayList newUnion = Lists.newArrayList();
        for (Schema unionType : union.getTypes()) {
            Optional<Schema> newType = AvroUtils.removeUncomparableFields(unionType, processed);
            if (!newType.isPresent()) continue;
            newUnion.add(newType.get());
        }
        if (newUnion.size() != union.getTypes().size()) {
            return Optional.absent();
        }
        return Optional.of((Object)Schema.createUnion((List)newUnion));
    }

    public static Schema switchName(Schema schema, String newName) {
        if (schema.getName().equals(newName)) {
            return schema;
        }
        Schema newSchema = Schema.createRecord((String)newName, (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        List fields = schema.getFields();
        Iterable fieldsNew = Iterables.transform((Iterable)fields, (Function)new Function<Schema.Field, Schema.Field>(){

            public Schema.Field apply(Schema.Field input) {
                if (null == input) {
                    return null;
                }
                Schema.Field field = new Schema.Field(input.name(), input.schema(), input.doc(), input.defaultValue(), input.order());
                return field;
            }
        });
        newSchema.setFields((List)Lists.newArrayList((Iterable)fieldsNew));
        return newSchema;
    }

    public static Schema switchNamespace(Schema schema, Map<String, String> namespaceOverride) {
        Schema newSchema;
        String newNamespace = "";
        switch (schema.getType()) {
            case ENUM: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                newSchema = Schema.createEnum((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (List)schema.getEnumSymbols());
                break;
            }
            case FIXED: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                newSchema = Schema.createFixed((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (int)schema.getFixedSize());
                break;
            }
            case MAP: {
                newSchema = Schema.createMap((Schema)AvroUtils.switchNamespace(schema.getValueType(), namespaceOverride));
                break;
            }
            case RECORD: {
                newNamespace = namespaceOverride.containsKey(schema.getNamespace()) ? namespaceOverride.get(schema.getNamespace()) : schema.getNamespace();
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
                if (schema.getFields().size() > 0) {
                    for (Schema.Field oldField : schema.getFields()) {
                        Schema.Field newField = new Schema.Field(oldField.name(), AvroUtils.switchNamespace(oldField.schema(), namespaceOverride), oldField.doc(), oldField.defaultValue(), oldField.order());
                        newFields.add(newField);
                    }
                }
                newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)newNamespace, (boolean)schema.isError());
                newSchema.setFields(newFields);
                break;
            }
            case UNION: {
                ArrayList<Schema> newUnionMembers = new ArrayList<Schema>();
                if (null != schema.getTypes() && schema.getTypes().size() > 0) {
                    for (Schema oldUnionMember : schema.getTypes()) {
                        newUnionMembers.add(AvroUtils.switchNamespace(oldUnionMember, namespaceOverride));
                    }
                }
                newSchema = Schema.createUnion(newUnionMembers);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray((Schema)AvroUtils.switchNamespace(schema.getElementType(), namespaceOverride));
                break;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                newSchema = Schema.create((Schema.Type)schema.getType());
                break;
            }
            default: {
                String exceptionMessage = String.format("Schema namespace replacement failed for \"%s\" ", schema);
                LOG.error(exceptionMessage);
                throw new AvroRuntimeException(exceptionMessage);
            }
        }
        AvroUtils.copyProperties(schema, newSchema);
        return newSchema;
    }

    private static void copyProperties(Schema oldSchema, Schema newSchema) {
        Preconditions.checkNotNull((Object)oldSchema);
        Preconditions.checkNotNull((Object)newSchema);
        Map props = oldSchema.getJsonProps();
        AvroUtils.copyProperties(props, newSchema);
    }

    private static void copyProperties(Map<String, JsonNode> props, Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (null != props) {
            for (Map.Entry<String, JsonNode> prop : props.entrySet()) {
                schema.addProp(prop.getKey(), prop.getValue());
            }
        }
    }

    public static Path serializeAsPath(GenericRecord record, boolean includeFieldNames, boolean replacePathSeparators) {
        if (record == null) {
            return new Path("");
        }
        ArrayList tokens = Lists.newArrayList();
        for (Schema.Field field : record.getSchema().getFields()) {
            String sanitizedName = HadoopUtils.sanitizePath(field.name(), "_");
            String sanitizedValue = HadoopUtils.sanitizePath(record.get(field.name()).toString(), "_");
            if (replacePathSeparators) {
                sanitizedName = sanitizedName.replaceAll("/", "_");
                sanitizedValue = sanitizedValue.replaceAll("/", "_");
            }
            if (includeFieldNames) {
                tokens.add(String.format("%s=%s", sanitizedName, sanitizedValue));
                continue;
            }
            if (Strings.isNullOrEmpty((String)sanitizedValue)) continue;
            tokens.add(sanitizedValue);
        }
        return new Path(Joiner.on((String)"/").join((Iterable)tokens));
    }

    public static GenericRecord slowDeserializeGenericRecord(byte[] serializedRecord, Schema schema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedRecord, null);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read(null, (Decoder)decoder);
    }

    public static class AvroPathFilter
    implements PathFilter {
        public boolean accept(Path path) {
            return path.getName().endsWith(AvroUtils.AVRO_SUFFIX);
        }
    }
}

