/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.salesforce;

import com.google.common.collect.Iterators;
import com.google.gson.JsonElement;
import com.sforce.async.BulkConnection;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.salesforce.BulkResultIterator;
import org.apache.gobblin.salesforce.FileIdVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChainingIterator
implements Iterator<JsonElement> {
    private static final Logger log = LoggerFactory.getLogger(ResultChainingIterator.class);
    private Iterator<JsonElement> iter;
    private int recordCount = 0;
    private int isDeletedRecordCount = 0;

    public ResultChainingIterator(BulkConnection conn, List<FileIdVO> fileIdList, int retryLimit, long retryInterval, long retryExceedQuotaInterval) {
        Iterator iterOfFiles = fileIdList.stream().map(x -> new BulkResultIterator(conn, (FileIdVO)x, retryLimit, retryInterval, retryExceedQuotaInterval)).iterator();
        this.iter = Iterators.concat(iterOfFiles);
    }

    public Iterator<JsonElement> get() {
        return this.iter;
    }

    public void add(Iterator<JsonElement> iter) {
        if (iter != null) {
            this.iter = Iterators.concat(this.iter, iter);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public JsonElement next() {
        JsonElement jsonElement = this.iter.next();
        ++this.recordCount;
        JsonElement isDeletedElement = jsonElement.getAsJsonObject().get("IsDeleted");
        if (isDeletedElement != null && isDeletedElement.getAsBoolean()) {
            ++this.isDeletedRecordCount;
        }
        if (!this.iter.hasNext()) {
            log.info("====Total records: [{}] isDeleted=true records: [{}]====", (Object)this.recordCount, (Object)this.isDeletedRecordCount);
        }
        return jsonElement;
    }
}

