/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.salesforce;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.source.extractor.exception.RestApiConnectionException;
import org.apache.gobblin.source.extractor.extract.restapi.RestApiConnector;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceConnector
extends RestApiConnector {
    private static final Logger log = LoggerFactory.getLogger(SalesforceConnector.class);
    private static final String DEFAULT_SERVICES_DATA_PATH = "/services/data";
    private static final String DEFAULT_AUTH_TOKEN_PATH = "/services/oauth2/token";
    protected String refreshToken;
    private String servicesDataEnvPath;

    public SalesforceConnector(State state) {
        super(state);
        this.refreshToken = SalesforceConnector.isPasswordGrant(state) ? null : state.getProp("source.conn.refresh.token");
    }

    public HttpEntity getAuthentication() throws RestApiConnectionException {
        log.debug("Authenticating salesforce");
        String clientId = this.state.getProp("source.conn.client.id");
        String clientSecret = this.state.getProp("source.conn.client.secret");
        if (this.state.getPropAsBoolean("source.conn.decrypt.client.id.secret", false)) {
            PasswordManager passwordManager = PasswordManager.getInstance((State)this.state);
            clientId = passwordManager.readPassword(clientId);
            clientSecret = passwordManager.readPassword(clientSecret);
        }
        String host = this.state.getProp("source.conn.host");
        ArrayList formParams = Lists.newArrayList();
        formParams.add(new BasicNameValuePair("client_id", clientId));
        formParams.add(new BasicNameValuePair("client_secret", clientSecret));
        if (this.refreshToken == null) {
            log.info("Authenticating salesforce with username/password");
            String userName = this.state.getProp("source.conn.username");
            String password = PasswordManager.getInstance((State)this.state).readPassword(this.state.getProp("source.conn.password"));
            String securityToken = PasswordManager.getInstance((State)this.state).readPassword(this.state.getProp("source.conn.security.token"));
            formParams.add(new BasicNameValuePair("grant_type", "password"));
            formParams.add(new BasicNameValuePair("username", userName));
            formParams.add(new BasicNameValuePair("password", password + securityToken));
        } else {
            log.info("Authenticating salesforce with refresh_token");
            formParams.add(new BasicNameValuePair("grant_type", "refresh_token"));
            formParams.add(new BasicNameValuePair("refresh_token", this.refreshToken));
        }
        try {
            HttpPost post = new HttpPost(host + DEFAULT_AUTH_TOKEN_PATH);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity((List)formParams));
            return this.getHttpClient().execute((HttpUriRequest)post).getEntity();
        }
        catch (Exception e) {
            throw new RestApiConnectionException("Failed to authenticate salesforce host:" + host + "; error-" + e.getMessage(), e);
        }
    }

    protected void addHeaders(HttpRequestBase httpRequest) {
        if (this.refreshToken == null) {
            super.addHeaders(httpRequest);
        } else {
            if (this.accessToken != null) {
                httpRequest.addHeader("Authorization", "Bearer " + this.accessToken);
            }
            httpRequest.addHeader("Content-Type", "application/json");
        }
    }

    protected static boolean isPasswordGrant(State state) {
        String userName = state.getProp("source.conn.username");
        String securityToken = state.getProp("source.conn.security.token");
        return userName != null && securityToken != null;
    }

    private String getServiceBaseUrl() {
        String dataEnvPath;
        this.servicesDataEnvPath = dataEnvPath = "/services/data/v" + this.state.getProp("source.conn.version");
        return this.instanceUrl + dataEnvPath;
    }

    public String getFullUri(String resourcePath) {
        return StringUtils.removeEnd((String)this.getServiceBaseUrl(), (String)"/") + StringUtils.removeEnd((String)resourcePath, (String)"/");
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getServicesDataEnvPath() {
        return this.servicesDataEnvPath;
    }
}

