/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.salesforce;

import com.google.gson.JsonElement;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.salesforce.SalesforceExtractor;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultIterator
implements Iterator<JsonElement> {
    private static final Logger log = LoggerFactory.getLogger(QueryResultIterator.class);
    private int recordCount = 0;
    private SalesforceExtractor extractor;
    private String schema;
    private String entity;
    private WorkUnit workUnit;
    private List<Predicate> predicateList;
    private Iterator<JsonElement> queryResultIter;

    public QueryResultIterator(SalesforceExtractor extractor, String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) {
        log.info("create query result iterator.");
        this.extractor = extractor;
        this.schema = schema;
        this.entity = entity;
        this.workUnit = workUnit;
        this.predicateList = predicateList;
    }

    @Override
    public boolean hasNext() {
        if (this.queryResultIter == null) {
            this.initQueryResultIter();
        }
        return this.queryResultIter.hasNext();
    }

    private void initQueryResultIter() {
        try {
            this.queryResultIter = this.extractor.getRecordSet(this.schema, this.entity, this.workUnit, this.predicateList);
        }
        catch (DataRecordException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonElement next() {
        if (this.queryResultIter == null) {
            this.initQueryResultIter();
        }
        JsonElement jsonElement = this.queryResultIter.next();
        ++this.recordCount;
        if (!this.queryResultIter.hasNext()) {
            log.info("----Rest API query records total:{}----", (Object)this.recordCount);
        }
        return jsonElement;
    }
}

