/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.salesforce;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sforce.async.BulkConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.salesforce.FileIdVO;
import org.apache.gobblin.salesforce.OpenAndSeekException;
import org.apache.gobblin.source.extractor.utils.InputStreamCSVReader;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkResultIterator
implements Iterator<JsonElement> {
    private static final Logger log = LoggerFactory.getLogger(BulkResultIterator.class);
    private FileIdVO fileIdVO;
    private int retryLimit;
    private BulkConnection conn;
    private InputStreamCSVReader csvReader;
    private List<String> header;
    private int columnSize;
    private int lineCount = 0;
    private long retryInterval;
    private long retryExceedQuotaInterval;
    private List<String> preLoadedLine = null;

    public BulkResultIterator(BulkConnection conn, FileIdVO fileIdVO, int retryLimit, long retryInterval, long retryExceedQuotaInterval) {
        log.info("create BulkResultIterator: " + fileIdVO);
        this.retryInterval = retryInterval;
        this.retryExceedQuotaInterval = retryExceedQuotaInterval;
        this.conn = conn;
        this.fileIdVO = fileIdVO;
        this.retryLimit = retryLimit;
    }

    private void initHeader() {
        this.header = this.nextLineWithRetry();
        this.columnSize = this.header.size();
        this.preLoadedLine = this.nextLineWithRetry();
    }

    private List<String> nextLineWithRetry() {
        Throwable rootCause = null;
        int executeCount = 0;
        while (executeCount < this.retryLimit + 1) {
            ++executeCount;
            try {
                if (this.csvReader == null) {
                    this.csvReader = this.openAndSeekCsvReader(rootCause);
                }
                ArrayList line = this.csvReader.nextRecord();
                ++this.lineCount;
                return line;
            }
            catch (InputStreamCSVReader.CSVParseException e) {
                throw new RuntimeException(e);
            }
            catch (OpenAndSeekException e) {
                rootCause = e.getCause();
                if (e.isCurrentExceptionExceedQuota()) {
                    log.warn("--Caught ExceededQuota: " + e.getMessage());
                    this.threadSleep(this.retryExceedQuotaInterval);
                    --executeCount;
                }
                log.info("***Retrying***1: {} - {}", (Object)this.fileIdVO, (Object)e.getMessage());
                this.csvReader = null;
            }
            catch (Exception e) {
                rootCause = e;
                this.threadSleep(this.retryInterval);
                log.info("***Retrying***2: {} - {}", (Object)this.fileIdVO, (Object)e.getMessage());
                this.csvReader = null;
            }
        }
        if (executeCount == 1) {
            throw new RuntimeException("***Fetch***: Failed", rootCause);
        }
        throw new RuntimeException("***Retried***: Failed, tried " + this.retryLimit + " times - ", rootCause);
    }

    private void threadSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            log.error("--Failed to sleep--", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.header == null) {
            this.initHeader();
        }
        return this.preLoadedLine != null;
    }

    @Override
    public JsonElement next() {
        if (this.header == null) {
            this.initHeader();
        }
        JsonObject jsonObject = Utils.csvToJsonObject(this.header, this.preLoadedLine, (int)this.columnSize);
        this.preLoadedLine = this.nextLineWithRetry();
        if (this.preLoadedLine == null) {
            log.info("----Record count: [{}] for {}", (Object)this.getRowCount(), (Object)this.fileIdVO);
        }
        return jsonObject;
    }

    private InputStreamCSVReader openAndSeekCsvReader(Throwable rootCause) throws OpenAndSeekException {
        while (rootCause != null && rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        String jobId = this.fileIdVO.getJobId();
        String batchId = this.fileIdVO.getBatchId();
        String resultId = this.fileIdVO.getResultId();
        log.info("Fetching [jobId={}, batchId={}, resultId={}]", new Object[]{jobId, batchId, resultId});
        this.closeCsvReader();
        try {
            InputStream is = this.conn.getQueryResultStream(jobId, batchId, resultId);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
            this.csvReader = new InputStreamCSVReader(br);
            ArrayList lastSkippedLine = null;
            for (int j = 0; j < this.lineCount; ++j) {
                lastSkippedLine = this.csvReader.nextRecord();
            }
            if (lastSkippedLine == null && this.preLoadedLine != null || lastSkippedLine != null && !lastSkippedLine.equals(this.preLoadedLine)) {
                String msg = rootCause == null ? "null" : rootCause.getMessage();
                throw new OpenAndSeekException("Failed to verify last skipped line - root cause [" + msg + "]", rootCause);
            }
            return this.csvReader;
        }
        catch (Exception currentException) {
            Throwable cause = rootCause == null ? currentException : rootCause;
            throw new OpenAndSeekException("Failed to [" + cause.getMessage() + "]", cause, currentException);
        }
    }

    private int getRowCount() {
        return this.lineCount - 2;
    }

    private void closeCsvReader() {
        if (this.csvReader != null) {
            try {
                this.csvReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

