/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.event.GobblinEventBuilder;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.util.GsonUtils;

public class IssueEventBuilder
extends GobblinEventBuilder {
    public static final String JOB_ISSUE = "JobIssue";
    private static final String ISSUE_EVENT_TYPE = "IssueEvent";
    private static final String METADATA_ISSUE = "issue";
    private Issue issue;

    public IssueEventBuilder(String name) {
        this(name, "gobblin.event");
    }

    public IssueEventBuilder(String name, String namespace) {
        super(name, namespace);
        this.metadata.put("eventType", ISSUE_EVENT_TYPE);
    }

    public static boolean isIssueEvent(GobblinTrackingEvent event) {
        String eventType = event.getMetadata() == null ? "" : (String)event.getMetadata().get("eventType");
        return StringUtils.isNotEmpty((String)eventType) && eventType.equals(ISSUE_EVENT_TYPE);
    }

    public static IssueEventBuilder fromEvent(GobblinTrackingEvent event) {
        if (!IssueEventBuilder.isIssueEvent(event)) {
            return null;
        }
        Map metadata = event.getMetadata();
        IssueEventBuilder issueEventBuilder = new IssueEventBuilder(event.getName(), event.getNamespace());
        metadata.forEach((key, value) -> {
            if (METADATA_ISSUE.equals(key)) {
                issueEventBuilder.issue = (Issue)GsonUtils.GSON_WITH_DATE_HANDLING.fromJson(value, Issue.class);
            } else {
                issueEventBuilder.addMetadata((String)key, (String)value);
            }
        });
        return issueEventBuilder;
    }

    public static Issue getIssueFromEvent(GobblinTrackingEvent event) {
        String serializedIssue = (String)event.getMetadata().get(METADATA_ISSUE);
        return (Issue)GsonUtils.GSON_WITH_DATE_HANDLING.fromJson(serializedIssue, Issue.class);
    }

    public GobblinTrackingEvent build() {
        if (this.issue == null) {
            throw new IllegalStateException("Issue must be set");
        }
        String serializedIssue = GsonUtils.GSON_WITH_DATE_HANDLING.toJson((Object)this.issue);
        this.addMetadata(METADATA_ISSUE, serializedIssue);
        return super.build();
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }
}

