/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.typesafe.config.Config;
import org.apache.gobblin.runtime.troubleshooter.AutomaticTroubleshooter;
import org.apache.gobblin.runtime.troubleshooter.AutomaticTroubleshooterConfig;
import org.apache.gobblin.runtime.troubleshooter.DefaultIssueRefinery;
import org.apache.gobblin.runtime.troubleshooter.InMemoryIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.NoopAutomaticTroubleshooter;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticTroubleshooterFactory {
    private static final Logger log = LoggerFactory.getLogger(AutomaticTroubleshooterFactory.class);
    private static final String TROUBLESHOOTER_CLASS = "org.apache.gobblin.troubleshooter.AutomaticTroubleshooterImpl";

    public static AutomaticTroubleshooter createForJob(Config config) {
        AutomaticTroubleshooterConfig troubleshooterConfig = new AutomaticTroubleshooterConfig(config);
        Class troubleshooterClass = AutomaticTroubleshooterFactory.tryGetTroubleshooterClass();
        if (troubleshooterClass == null) {
            log.info("To enable Gobblin automatic troubleshooter, reference 'gobblin-troubleshooter' module in your project. Troubleshooter will summarize the errors and warnings in the logs. It will also identify root causes of certain problems.");
            return new NoopAutomaticTroubleshooter();
        }
        if (troubleshooterConfig.isDisabled()) {
            log.info("Gobblin automatic troubleshooter is disabled. Remove the following property to re-enable it: gobblin.troubleshooter.disabled");
            return new NoopAutomaticTroubleshooter();
        }
        InMemoryIssueRepository issueRepository = new InMemoryIssueRepository();
        DefaultIssueRefinery issueRefinery = new DefaultIssueRefinery();
        try {
            return (AutomaticTroubleshooter)GobblinConstructorUtils.invokeLongestConstructor((Class)troubleshooterClass, (Object[])new Object[]{troubleshooterConfig, issueRepository, issueRefinery});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot create troubleshooter instance", e);
        }
    }

    private static Class tryGetTroubleshooterClass() {
        try {
            return Class.forName(TROUBLESHOOTER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

