/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.runtime.api.JobSpec;

public class JobSpecFilter
implements Predicate<JobSpec> {
    private final Optional<Predicate<URI>> uriPredicate;
    private final Optional<Predicate<String>> versionPredicate;

    public boolean apply(JobSpec input) {
        Preconditions.checkNotNull((Object)input);
        boolean res = true;
        if (this.uriPredicate.isPresent()) {
            res &= ((Predicate)this.uriPredicate.get()).apply((Object)input.getUri());
        }
        if (res && this.versionPredicate.isPresent()) {
            res &= ((Predicate)this.versionPredicate.get()).apply((Object)input.getVersion());
        }
        return res;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JobSpecFilter eqJobSpecURI(URI jobSpecURI) {
        return JobSpecFilter.builder().eqURI(jobSpecURI).build();
    }

    public static JobSpecFilter eqJobSpecURI(String jobSpecURI) {
        return JobSpecFilter.builder().eqURI(jobSpecURI).build();
    }

    public JobSpecFilter(Optional<Predicate<URI>> uriPredicate, Optional<Predicate<String>> versionPredicate) {
        this.uriPredicate = uriPredicate;
        this.versionPredicate = versionPredicate;
    }

    public static class Builder {
        private Predicate<URI> uriPredicate;
        private Predicate<String> versionPredicate;

        public Builder eqURI(URI uri) {
            this.uriPredicate = Predicates.equalTo((Object)uri);
            return this;
        }

        public Builder eqURI(String uri) {
            try {
                this.uriPredicate = Predicates.equalTo((Object)new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("invalid URI: " + uri, e);
            }
            return this;
        }

        public Builder eqVersion(String version) {
            this.versionPredicate = Predicates.equalTo((Object)version);
            return this;
        }

        public JobSpecFilter build() {
            return new JobSpecFilter((Optional<Predicate<URI>>)Optional.fromNullable(this.uriPredicate), (Optional<Predicate<String>>)Optional.fromNullable(this.versionPredicate));
        }

        public Predicate<URI> getUriPredicate() {
            return this.uriPredicate;
        }

        public Predicate<String> getVersionPredicate() {
            return this.versionPredicate;
        }

        public void setUriPredicate(Predicate<URI> uriPredicate) {
            this.uriPredicate = uriPredicate;
        }

        public void setVersionPredicate(Predicate<String> versionPredicate) {
            this.versionPredicate = versionPredicate;
        }
    }
}

