/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Predicate;
import java.net.URI;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecutionDriver;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobLifecycleListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;

public class FilteredJobLifecycleListener
implements JobLifecycleListener {
    private final Predicate<JobSpec> filter;
    private final JobLifecycleListener delegate;

    @Override
    public void onAddJob(JobSpec addedJob) {
        if (this.filter.apply((Object)addedJob)) {
            this.delegate.onAddJob(addedJob);
        }
    }

    @Override
    public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
        JobSpec fakeJobSpec = JobSpec.builder(deletedJobURI).withVersion(deletedJobVersion).build();
        if (this.filter.apply((Object)fakeJobSpec)) {
            this.delegate.onDeleteJob(deletedJobURI, deletedJobVersion);
        }
    }

    @Override
    public void onUpdateJob(JobSpec updatedJob) {
        if (this.filter.apply((Object)updatedJob)) {
            this.delegate.onUpdateJob(updatedJob);
        }
    }

    @Override
    public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
        if (this.filter.apply((Object)state.getJobSpec())) {
            this.delegate.onStatusChange(state, previousStatus, newStatus);
        }
    }

    @Override
    public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        if (this.filter.apply((Object)state.getJobSpec())) {
            this.delegate.onStageTransition(state, previousStage, newStage);
        }
    }

    @Override
    public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        if (this.filter.apply((Object)state.getJobSpec())) {
            this.delegate.onMetadataChange(state, key, oldValue, newValue);
        }
    }

    @Override
    public void onJobScheduled(JobSpecSchedule jobSchedule) {
        if (this.filter.apply((Object)jobSchedule.getJobSpec())) {
            this.delegate.onJobScheduled(jobSchedule);
        }
    }

    @Override
    public void onJobUnscheduled(JobSpecSchedule jobSchedule) {
        if (this.filter.apply((Object)jobSchedule.getJobSpec())) {
            this.delegate.onJobUnscheduled(jobSchedule);
        }
    }

    @Override
    public void onJobTriggered(JobSpec jobSpec) {
        if (this.filter.apply((Object)jobSpec)) {
            this.delegate.onJobTriggered(jobSpec);
        }
    }

    @Override
    public void onJobLaunch(JobExecutionDriver jobDriver) {
        if (this.filter.apply((Object)jobDriver.getJobExecutionState().getJobSpec())) {
            this.delegate.onJobLaunch(jobDriver);
        }
    }

    public FilteredJobLifecycleListener(Predicate<JobSpec> filter, JobLifecycleListener delegate) {
        this.filter = filter;
        this.delegate = delegate;
    }
}

