/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_store;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metastore.MysqlDataSourceFactory;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.FlowSpecSearchObject;
import org.apache.gobblin.runtime.api.InstrumentedSpecStore;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecSerDeException;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSpecStore
extends InstrumentedSpecStore {
    private static final Logger log = LoggerFactory.getLogger(MysqlSpecStore.class);
    public static final String CONFIG_PREFIX = "mysqlSpecStore";
    public static final String DEFAULT_TAG_VALUE = "";
    private static final String NEW_COLUMN = "spec_json";
    private static final String EXISTS_STATEMENT = "SELECT EXISTS(SELECT * FROM %s WHERE spec_uri = ?)";
    protected static final String INSERT_STATEMENT = "INSERT INTO %s (spec_uri, flow_group, flow_name, template_uri, user_to_proxy, source_identifier, destination_identifier, schedule, tag, isRunImmediately, owning_group, spec, spec_json) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE spec = VALUES(spec), spec_json = VALUES(spec_json)";
    private static final String DELETE_STATEMENT = "DELETE FROM %s WHERE spec_uri = ?";
    private static final String GET_STATEMENT = "SELECT spec_uri, spec, spec_json FROM %s WHERE ";
    private static final String GET_ALL_STATEMENT = "SELECT spec_uri, spec, spec_json FROM %s";
    private static final String GET_ALL_URIS_STATEMENT = "SELECT spec_uri FROM %s";
    private static final String GET_ALL_STATEMENT_WITH_TAG = "SELECT spec_uri FROM %s WHERE tag = ?";
    protected final DataSource dataSource;
    protected final String tableName;
    private final URI specStoreURI;
    protected final SpecSerDe specSerDe;

    public MysqlSpecStore(Config config, SpecSerDe specSerDe) throws IOException {
        super(config, specSerDe);
        if (config.hasPath(CONFIG_PREFIX)) {
            config = config.getConfig(CONFIG_PREFIX).withFallback((ConfigMergeable)config);
        }
        this.dataSource = MysqlDataSourceFactory.get((Config)config, (SharedResourcesBroker)SharedResourcesBrokerFactory.getImplicitBroker());
        this.tableName = config.getString("state.store.db.table");
        this.specStoreURI = URI.create(config.getString("state.store.db.url"));
        this.specSerDe = specSerDe;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.getCreateJobStateTableTemplate());){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected String getCreateJobStateTableTemplate() {
        return "CREATE TABLE IF NOT EXISTS " + this.tableName + " (spec_uri VARCHAR(" + FlowSpec.Utils.maxFlowSpecUriLength() + ") NOT NULL, flow_group VARCHAR(" + 128 + "), flow_name VARCHAR(" + 128 + "), template_uri VARCHAR(128), user_to_proxy VARCHAR(128), source_identifier VARCHAR(128), destination_identifier VARCHAR(128), schedule VARCHAR(128), tag VARCHAR(128) NOT NULL, modified_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, isRunImmediately BOOLEAN, timezone VARCHAR(128), owning_group VARCHAR(128), spec LONGBLOB, " + NEW_COLUMN + " JSON, PRIMARY KEY (spec_uri))";
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean existsImpl(URI specUri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addSpecImpl(Spec spec) throws IOException {
        this.addSpec(spec, DEFAULT_TAG_VALUE);
    }

    public void addSpec(Spec spec, String tagValue) throws IOException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format(INSERT_STATEMENT, this.tableName));){
            this.setAddPreparedStatement(statement, spec, tagValue);
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException | SpecSerDeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean deleteSpec(Spec spec) throws IOException {
        return this.deleteSpec(spec.getUri());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteSpecImpl(URI specUri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean deleteSpec(URI specUri, String version) throws IOException {
        return this.deleteSpec(specUri);
    }

    @Override
    public Spec updateSpecImpl(Spec spec) throws IOException {
        this.addSpec(spec);
        return spec;
    }

    @Override
    public Spec getSpecImpl(URI specUri) throws IOException, SpecNotFoundException {
        Iterator<Spec> specsIterator = this.getSpecsImpl(FlowSpecSearchObject.builder().flowSpecUri(specUri).build()).iterator();
        if (specsIterator.hasNext()) {
            return specsIterator.next();
        }
        throw new SpecNotFoundException(specUri);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<Spec> getSpecsImpl(SpecSearchObject specSearchObject) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Spec getSpec(URI specUri, String version) throws IOException, SpecNotFoundException {
        return this.getSpec(specUri);
    }

    @Override
    public Collection<Spec> getAllVersionsOfSpec(URI specUri) throws IOException, SpecNotFoundException {
        return Lists.newArrayList((Object[])new Spec[]{this.getSpec(specUri)});
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<Spec> getSpecsImpl() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<Spec> getSpecsInternal(PreparedStatement statement) throws IOException {
        ArrayList<Spec> specs = new ArrayList<Spec>();
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                specs.add(rs.getString(3) == null ? this.specSerDe.deserialize(ByteStreams.toByteArray((InputStream)rs.getBlob(2).getBinaryStream())) : this.specSerDe.deserialize(rs.getString(2).getBytes(Charsets.UTF_8)));
            }
        }
        catch (SQLException | SpecSerDeException e) {
            log.error("Failed to deserialize spec", (Throwable)e);
            throw new IOException(e);
        }
        return specs;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<URI> getSpecURIsImpl() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<URI> getSpecURIsWithTag(String tag) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Iterator<URI> getURIIteratorByQuery(PreparedStatement statement) throws SQLException {
        ArrayList<URI> specs = new ArrayList<URI>();
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                URI specURI = URI.create(rs.getString(1));
                specs.add(specURI);
            }
        }
        return specs.iterator();
    }

    @Override
    public Optional<URI> getSpecStoreURI() {
        return Optional.of((Object)this.specStoreURI);
    }

    static String createGetPreparedStatement(FlowSpecSearchObject flowSpecSearchObject, String tableName) throws IOException {
        String baseStatement = String.format(GET_STATEMENT, tableName);
        ArrayList<String> conditions = new ArrayList<String>();
        if (flowSpecSearchObject.getFlowSpecUri() != null) {
            conditions.add("spec_uri = ?");
        }
        if (flowSpecSearchObject.getFlowGroup() != null) {
            conditions.add("flow_group = ?");
        }
        if (flowSpecSearchObject.getFlowName() != null) {
            conditions.add("flow_name = ?");
        }
        if (flowSpecSearchObject.getTemplateURI() != null) {
            conditions.add("template_uri = ?");
        }
        if (flowSpecSearchObject.getUserToProxy() != null) {
            conditions.add("user_to_proxy = ?");
        }
        if (flowSpecSearchObject.getSourceIdentifier() != null) {
            conditions.add("source_identifier = ?");
        }
        if (flowSpecSearchObject.getDestinationIdentifier() != null) {
            conditions.add("destination_identifier = ?");
        }
        if (flowSpecSearchObject.getSchedule() != null) {
            conditions.add("schedule = ?");
        }
        if (flowSpecSearchObject.getModifiedTimestamp() != null) {
            conditions.add("modified_time = ?");
        }
        if (flowSpecSearchObject.getIsRunImmediately() != null) {
            conditions.add("isRunImmediately = ?");
        }
        if (flowSpecSearchObject.getOwningGroup() != null) {
            conditions.add("owning_group = ?");
        }
        if (flowSpecSearchObject.getPropertyFilter() != null) {
            String propertyFilter = flowSpecSearchObject.getPropertyFilter();
            Splitter commaSplitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
            for (String property : commaSplitter.splitToList((CharSequence)propertyFilter)) {
                if (property.contains("=")) {
                    String[] keyValue = property.split("=");
                    if (keyValue.length != 2) {
                        log.error("Incorrect flow config search query");
                        continue;
                    }
                    conditions.add("spec_json->'$.configAsProperties.\"" + keyValue[0] + "\"' like '%" + keyValue[1] + "%'");
                    continue;
                }
                conditions.add("spec_json->'$.configAsProperties.\"" + property + "\"' is not null");
            }
        }
        if (conditions.size() == 0) {
            throw new IOException("At least one condition is required to query flow configs.");
        }
        return baseStatement + String.join((CharSequence)" AND ", conditions);
    }

    private static void setGetPreparedStatement(PreparedStatement statement, FlowSpecSearchObject flowSpecSearchObject) throws SQLException {
        int i = 0;
        if (flowSpecSearchObject.getFlowSpecUri() != null) {
            statement.setString(++i, flowSpecSearchObject.getFlowSpecUri().toString());
        }
        if (flowSpecSearchObject.getFlowGroup() != null) {
            statement.setString(++i, flowSpecSearchObject.getFlowGroup());
        }
        if (flowSpecSearchObject.getFlowName() != null) {
            statement.setString(++i, flowSpecSearchObject.getFlowName());
        }
        if (flowSpecSearchObject.getTemplateURI() != null) {
            statement.setString(++i, flowSpecSearchObject.getTemplateURI());
        }
        if (flowSpecSearchObject.getUserToProxy() != null) {
            statement.setString(++i, flowSpecSearchObject.getUserToProxy());
        }
        if (flowSpecSearchObject.getSourceIdentifier() != null) {
            statement.setString(++i, flowSpecSearchObject.getSourceIdentifier());
        }
        if (flowSpecSearchObject.getDestinationIdentifier() != null) {
            statement.setString(++i, flowSpecSearchObject.getDestinationIdentifier());
        }
        if (flowSpecSearchObject.getSchedule() != null) {
            statement.setString(++i, flowSpecSearchObject.getModifiedTimestamp());
        }
        if (flowSpecSearchObject.getIsRunImmediately() != null) {
            statement.setBoolean(++i, flowSpecSearchObject.getIsRunImmediately());
        }
        if (flowSpecSearchObject.getOwningGroup() != null) {
            statement.setString(++i, flowSpecSearchObject.getOwningGroup());
        }
    }

    protected void setAddPreparedStatement(PreparedStatement statement, Spec spec, String tagValue) throws SQLException {
        FlowSpec flowSpec = (FlowSpec)spec;
        URI specUri = flowSpec.getUri();
        Config flowConfig = flowSpec.getConfig();
        String flowGroup = flowConfig.getString("flow.group");
        String flowName = flowConfig.getString("flow.name");
        String templateURI = new Gson().toJson(flowSpec.getTemplateURIs());
        String userToProxy = ConfigUtils.getString((Config)flowSpec.getConfig(), (String)"user.to.proxy", null);
        String sourceIdentifier = flowConfig.getString("gobblin.flow.sourceIdentifier");
        String destinationIdentifier = flowConfig.getString("gobblin.flow.destinationIdentifier");
        String schedule = ConfigUtils.getString((Config)flowConfig, (String)"job.schedule", null);
        String owningGroup = ConfigUtils.getString((Config)flowConfig, (String)"flow.owningGroup", null);
        boolean isRunImmediately = ConfigUtils.getBoolean((Config)flowConfig, (String)"flow.runImmediately", (boolean)false);
        int i = 0;
        statement.setString(++i, specUri.toString());
        statement.setString(++i, flowGroup);
        statement.setString(++i, flowName);
        statement.setString(++i, templateURI);
        statement.setString(++i, userToProxy);
        statement.setString(++i, sourceIdentifier);
        statement.setString(++i, destinationIdentifier);
        statement.setString(++i, schedule);
        statement.setString(++i, tagValue);
        statement.setBoolean(++i, isRunImmediately);
        statement.setString(++i, owningGroup);
        statement.setBlob(++i, new ByteArrayInputStream(this.specSerDe.serialize(flowSpec)));
        statement.setString(++i, new String(this.specSerDe.serialize(flowSpec), Charsets.UTF_8));
    }
}

