/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.typesafe.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.util.CompletedFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFsSpecProducer
implements SpecProducer<Spec> {
    private static final Logger log = LoggerFactory.getLogger(LocalFsSpecProducer.class);
    private String specProducerPath;
    public static final String LOCAL_FS_PRODUCER_PATH_KEY = "localFsSpecProducer.dir";

    public LocalFsSpecProducer(Config config) {
        this.specProducerPath = config.getString(LOCAL_FS_PRODUCER_PATH_KEY);
        File parentDir = new File(this.specProducerPath);
        if (!parentDir.exists()) {
            if (parentDir.mkdirs()) {
                log.info("Creating directory path at {}", (Object)this.specProducerPath);
            } else {
                throw new RuntimeException(String.format("Unable to create folder to write specs to at %s", this.specProducerPath));
            }
        }
    }

    public Future<?> addSpec(Spec addedSpec) {
        return this.writeSpec(addedSpec, SpecExecutor.Verb.ADD);
    }

    public Future<?> updateSpec(Spec updatedSpec) {
        return this.writeSpec(updatedSpec, SpecExecutor.Verb.UPDATE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Future<?> writeSpec(Spec spec, SpecExecutor.Verb verb) {
        if (!(spec instanceof JobSpec)) throw new RuntimeException("Unsupported spec type " + spec.getClass());
        String flowExecutionId = ((JobSpec)spec).getConfigAsProperties().getProperty("flow.executionId");
        String jobFileName = LocalFsSpecProducer.getJobFileName(spec.getUri(), flowExecutionId);
        try (FileOutputStream fStream = new FileOutputStream(this.specProducerPath + File.separatorChar + jobFileName);){
            ((JobSpec)spec).getConfigAsProperties().store(fStream, null);
            log.info("Writing job {} to {}", (Object)jobFileName, (Object)this.specProducerPath);
            CompletedFuture completedFuture = new CompletedFuture((Object)Boolean.TRUE, null);
            return completedFuture;
        }
        catch (IOException e) {
            log.error("Exception encountered when adding Spec {}", (Object)spec);
            return new CompletedFuture((Object)Boolean.TRUE, (Throwable)e);
        }
    }

    public Future<?> deleteSpec(URI deletedSpecURI, Properties headers) {
        String prefix = String.join((CharSequence)"_", deletedSpecURI.getPath().split("/"));
        File dir = new File(this.specProducerPath);
        File[] foundFiles = dir.listFiles((file, name) -> name.startsWith(prefix) && name.endsWith(".job"));
        for (int i = 0; i < foundFiles.length; ++i) {
            Boolean didDelete = foundFiles[i].delete();
            if (didDelete.booleanValue()) continue;
            return new CompletedFuture((Object)Boolean.TRUE, (Throwable)new RuntimeException(String.format("Failed to delete file with uri %s", deletedSpecURI)));
        }
        return new CompletedFuture((Object)Boolean.TRUE, null);
    }

    public Future<? extends List<Spec>> listSpecs() {
        throw new UnsupportedOperationException();
    }

    public static String getJobFileName(URI specUri, String flowExecutionId) {
        CharSequence[] uriTokens = specUri.getPath().split("/");
        return String.join((CharSequence)"_", uriTokens) + "_" + flowExecutionId + ".job";
    }
}

