/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.mapreduce;

import org.apache.gobblin.runtime.mapreduce.CustomizedProgresser;
import org.apache.hadoop.mapreduce.Mapper;

public class CustomizedProgresserBase
implements CustomizedProgresser {
    private static final String STATIC_PROGRESS = "customizedProgress.staticProgressValue";
    private static final float DEFAULT_STATIC_PROGRESS = 0.5f;
    private float staticProgress;

    public CustomizedProgresserBase(Mapper.Context mapperContext) {
        this.staticProgress = mapperContext.getConfiguration().getFloat(STATIC_PROGRESS, 0.5f);
    }

    @Override
    public float getCustomizedProgress() {
        return this.staticProgress;
    }

    public static class BaseFactory
    implements CustomizedProgresser.Factory {
        @Override
        public CustomizedProgresser createCustomizedProgresser(Mapper.Context mapperContext) {
            return new CustomizedProgresserBase(mapperContext);
        }
    }
}

