/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.locks;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.typesafe.config.Config;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.runtime.locks.JobLock;
import org.apache.gobblin.runtime.locks.JobLockFactory;
import org.apache.gobblin.runtime.locks.JobLockFactoryManager;
import org.slf4j.Logger;

public abstract class AbstractJobLockFactoryManager<T extends JobLock, F extends JobLockFactory<T>>
implements JobLockFactoryManager<T, F> {
    private final Cache<Config, F> _factoryCache;

    protected AbstractJobLockFactoryManager(Cache<Config, F> factoryCache) {
        this._factoryCache = factoryCache;
    }

    public AbstractJobLockFactoryManager() {
        this(CacheBuilder.newBuilder().build());
    }

    protected abstract Config getFactoryConfig(Config var1);

    protected abstract F createFactoryInstance(Optional<Logger> var1, Config var2, Config var3);

    @Override
    public F getJobLockFactory(final Config sysConfig, final Optional<Logger> log) {
        final Config factoryConfig = this.getFactoryConfig(sysConfig);
        try {
            return (F)((JobLockFactory)this._factoryCache.get((Object)factoryConfig, new Callable<F>(){

                @Override
                public F call() throws Exception {
                    return AbstractJobLockFactoryManager.this.createFactoryInstance((Optional<Logger>)log, sysConfig, factoryConfig);
                }
            }));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to create a job lock factory: " + e, e);
        }
    }
}

