/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_spec;

import com.google.common.base.Splitter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.InMemoryJobCatalog;
import org.apache.gobblin.runtime.job_catalog.PackagedTemplatesJobCatalogDecorator;
import org.apache.gobblin.runtime.job_spec.JobResolutionCallbacks;
import org.apache.gobblin.runtime.job_spec.ResolvedJobSpec;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;

public class JobSpecResolver {
    public static final String JOB_RESOLUTION_ACTIONS_KEY = "org.apache.gobblin.jobResolution.actions";
    private final JobCatalogWithTemplates jobCatalog;
    private final List<JobResolutionCallbacks> jobResolutionCallbacks;
    private final Config sysConfig;

    public static JobSpecResolver mock() {
        try {
            return new Builder().sysConfig(ConfigFactory.empty()).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error. This is an error in code.", ioe);
        }
    }

    public static Builder builder(GobblinInstanceDriver driver) throws IOException {
        return new Builder().sysConfig(driver.getSysConfig().getConfig()).jobCatalog(driver.getJobCatalog());
    }

    public static Builder builder(Config sysConfig) throws IOException {
        return new Builder().sysConfig(sysConfig);
    }

    public ResolvedJobSpec resolveJobSpec(JobSpec jobSpec) throws SpecNotFoundException, JobTemplate.TemplateException, ConfigException {
        if (jobSpec instanceof ResolvedJobSpec) {
            return (ResolvedJobSpec)jobSpec;
        }
        JobTemplate jobTemplate = null;
        if (jobSpec.getJobTemplate().isPresent()) {
            jobTemplate = (JobTemplate)jobSpec.getJobTemplate().get();
        } else if (jobSpec.getTemplateURI().isPresent()) {
            jobTemplate = this.jobCatalog.getTemplate((URI)jobSpec.getTemplateURI().get());
        }
        for (JobResolutionCallbacks action : this.jobResolutionCallbacks) {
            action.beforeResolution(this, jobSpec, jobTemplate);
        }
        Config resolvedConfig = jobTemplate == null ? jobSpec.getConfig().resolve() : jobTemplate.getResolvedConfig(jobSpec.getConfig()).resolve();
        ResolvedJobSpec resolvedJobSpec = new ResolvedJobSpec(jobSpec, resolvedConfig);
        for (JobResolutionCallbacks action : this.jobResolutionCallbacks) {
            action.afterResolution(this, resolvedJobSpec);
        }
        return resolvedJobSpec;
    }

    public JobSpecResolver(JobCatalogWithTemplates jobCatalog, List<JobResolutionCallbacks> jobResolutionCallbacks, Config sysConfig) {
        this.jobCatalog = jobCatalog;
        this.jobResolutionCallbacks = jobResolutionCallbacks;
        this.sysConfig = sysConfig;
    }

    public static class Builder {
        private JobCatalogWithTemplates jobCatalog = new PackagedTemplatesJobCatalogDecorator(new InMemoryJobCatalog());
        private List<JobResolutionCallbacks> jobResolutionCallbacks = new ArrayList<JobResolutionCallbacks>();
        private Config sysConfig;

        private Builder sysConfig(Config sysConfig) throws IOException {
            this.sysConfig = sysConfig;
            for (String action : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)ConfigUtils.getString((Config)sysConfig, (String)JobSpecResolver.JOB_RESOLUTION_ACTIONS_KEY, (String)""))) {
                try {
                    ClassAliasResolver resolver = new ClassAliasResolver(JobResolutionCallbacks.class);
                    JobResolutionCallbacks actionInstance = (JobResolutionCallbacks)resolver.resolveClass(action).newInstance();
                    this.jobResolutionCallbacks.add(actionInstance);
                }
                catch (ReflectiveOperationException roe) {
                    throw new IOException(roe);
                }
            }
            return this;
        }

        public Builder jobCatalog(JobCatalog jobCatalog) {
            this.jobCatalog = new PackagedTemplatesJobCatalogDecorator(jobCatalog);
            return this;
        }

        public Builder jobResolutionAction(JobResolutionCallbacks action) {
            this.jobResolutionCallbacks.add(action);
            return this;
        }

        public JobSpecResolver build() {
            return new JobSpecResolver(this.jobCatalog, this.jobResolutionCallbacks, this.sysConfig);
        }
    }
}

